package com.thrid.party.codec.demo;

import com.zteits.nbiot.decoder.ProtocolAdapterImpl;
import org.junit.Before;
import org.junit.Test;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.huawei.m2m.cig.tup.modules.protocol_adapter.IProtocolAdapter;

/**
 * Unit test for simple App.
 */
public class ProtocolServiceImplTest {

    private IProtocolAdapter protocolAdapter;

    @Before
    public void setProtocolAdapter() {
        this.protocolAdapter = new ProtocolAdapterImpl();
    }

    /**
     * 测试用例1：设备向平台上报数据。
     * <p>
     * <pre>
     * 设备上报数据:AA72000032088D0320623399
     * </pre>
     *
     * @throws Exception
     */
    @Test
    public void testDecodeDeviceReportData() throws Exception {
        byte[] deviceReqByte = initDeviceReqByte();
        ObjectNode objectNode = protocolAdapter.decode(deviceReqByte);
        String str = objectNode.toString();
        System.out.println(str);
    }

    public static void main(String[] args) throws Exception {
        IProtocolAdapter protocolAdapter = new ProtocolAdapterImpl();
        byte[] deviceReqByte = initDeviceReqByte();
        ObjectNode objectNode = protocolAdapter.decode(deviceReqByte);
        String str = objectNode.toString();
        System.out.println(str);


        /*byte[] deviceReqByte = initDeviceReqByte();
        ObjectNode cloudRspObjectNode = initCloudRspObjectNode(deviceReqByte);
        byte[] outputByte2 = protocolAdapter.encode(cloudRspObjectNode);
        System.out.println("cloudRsp output:" + parseByte2HexStr(outputByte2));*/
    }

    /**
     * 测试用例2：平台向设备下发控制命令:
     * <p>
     * <pre>
     * {
     * //"identifier": "123",
     * "msgType": "cloudReq",
     * "cmd": "SET_DEVICE_LEVEL",
     * "mid": 2016,
     * "paras": { "value": "10" },
     * "hasMore": 0
     * }
     * </pre>
     */
    @Test
    public void testEncodeIoTSendCommand() throws Exception {
        ObjectNode CloudReqObjectNode = initCloudReqObjectNode();
        byte[] outputByte = protocolAdapter.encode(CloudReqObjectNode);
        System.out.println("cloudReq output:" + parseByte2HexStr(outputByte));
    }

    /**
     * 测试用例3：设备对平台命令的应答消息 有命令短id
     * <p>
     * <pre>
     * 设备应答消息:AA7201000107E0
     *
     * <pre>
     *
     * @throws Exception
     */
    @Test
    public void testDecodeDeviceResponseIoT() throws Exception {
        byte[] deviceRspByte = initDeviceRspByte();
        ObjectNode objectNode = protocolAdapter.decode(deviceRspByte);
        String str = objectNode.toString();
        System.out.println(str);
    }

    /**
     * 测试用例4：平台收到设备的上报数据后对设备的应答，如果不需要应答则返回null即可
     * <pre>
     * {
     * "identifier": "0",
     * "msgType": "cloudRsp",
     * "request": [AA,72,00,00,32,08,8D,03,20,62,33,99],
     * "errcode": 0,
     * "hasMore": 0
     * }
     *
     * <pre>
     *
     * @throws Exception
     */
    @Test
    public void testEncodeIoTResponseDevice() throws Exception {
        byte[] deviceReqByte = initDeviceReqByte();
        ObjectNode cloudRspObjectNode = initCloudRspObjectNode(deviceReqByte);
        byte[] outputByte2 = protocolAdapter.encode(cloudRspObjectNode);
        System.out.println("cloudRsp output:" + parseByte2HexStr(outputByte2));
    }

    public static String parseByte2HexStr(byte[] buf) {
        if (null == buf) {
            return null;
        }

        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < buf.length; i++) {
            String hex = Integer.toHexString(buf[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            sb.append(hex.toUpperCase());
        }
        return sb.toString();
    }

    /*
     * 初始化：设备数据上报码流
     */
    private static byte[] initDeviceReqByte() {
        /**
         * 本例入参： 57 58 48 53 50 5F 4D 44 21 00 00 00 00 5A 9E 68 42 01 00 01 0B B8
         01 13 1D B1 12 00 14 00 1E 00 0F 04 00 00 01 00 00 02 00 05 00 0A 00 0F 00 00 00 00 00 00 00 00 00 00 00 00 27 8F
         */
        byte[] byteDeviceReq = new byte[60];



        byteDeviceReq[0] = (byte) 0x57;
        byteDeviceReq[1] = (byte) 0x58;
        byteDeviceReq[2] = (byte) 0x48;
        byteDeviceReq[3] = (byte) 0x53;

        byteDeviceReq[4] = (byte) 0x50;
        byteDeviceReq[5] = (byte) 0x5F;
        byteDeviceReq[6] = (byte) 0x4D;
        byteDeviceReq[7] = (byte) 0x44;

        byteDeviceReq[8] = (byte) 0x21;

        byteDeviceReq[9] = (byte) 0x00;

        byteDeviceReq[10] = (byte) 0x00;
        byteDeviceReq[11] = (byte) 0x00;
        byteDeviceReq[12] = (byte) 0x00;

        byteDeviceReq[13] = (byte) 0x5A;
        byteDeviceReq[14] = (byte) 0x9E;
        byteDeviceReq[15] = (byte) 0x68;
        byteDeviceReq[16] = (byte) 0x42;
        byteDeviceReq[17] = (byte) 0x01;

        byteDeviceReq[18] = (byte) 0x00;
        byteDeviceReq[19] = (byte) 0x01;
        byteDeviceReq[20] = (byte) 0x0B;
        byteDeviceReq[21] = (byte) 0xB8;
        byteDeviceReq[22] = (byte) 0x01;
        byteDeviceReq[23] = (byte) 0x13;
        byteDeviceReq[24] = (byte) 0x1D;
        byteDeviceReq[25] = (byte) 0xB1;
        byteDeviceReq[26] = (byte) 0x12;
        byteDeviceReq[27] = (byte) 0x00;
        byteDeviceReq[28] = (byte) 0x14;
        byteDeviceReq[29] = (byte) 0x00;
        byteDeviceReq[30] = (byte) 0x1E;
        byteDeviceReq[31] = (byte) 0x00;
        byteDeviceReq[32] = (byte) 0x0F;

        byteDeviceReq[33] = (byte) 0x04;
        byteDeviceReq[34] = (byte) 0x00;
        byteDeviceReq[35] = (byte) 0x00;
        byteDeviceReq[36] = (byte) 0x01;
        byteDeviceReq[37] = (byte) 0x00;
        byteDeviceReq[38] = (byte) 0x00;
        byteDeviceReq[39] = (byte) 0x02;
        byteDeviceReq[40] = (byte) 0x00;
        byteDeviceReq[41] = (byte) 0x05;
        byteDeviceReq[42] = (byte) 0x00;
        byteDeviceReq[43] = (byte) 0x0A;
        byteDeviceReq[44] = (byte) 0x00;
        byteDeviceReq[45] = (byte) 0x0F;
        byteDeviceReq[46] = (byte) 0x00;
        byteDeviceReq[47] = (byte) 0x00;
        byteDeviceReq[48] = (byte) 0x00;
        byteDeviceReq[49] = (byte) 0x00;
        byteDeviceReq[50] = (byte) 0x00;
        byteDeviceReq[51] = (byte) 0x00;
        byteDeviceReq[52] = (byte) 0x00;
        byteDeviceReq[53] = (byte) 0x00;
        byteDeviceReq[54] = (byte) 0x00;
        byteDeviceReq[55] = (byte) 0x00;
        byteDeviceReq[56] = (byte) 0x00;
        byteDeviceReq[57] = (byte) 0x00;
        byteDeviceReq[58] = (byte) 0x27;
        byteDeviceReq[59] = (byte) 0x8F;



        return byteDeviceReq;
    }

    /*
     * 初始化：平台向设备命令下发数据
     */
    private static ObjectNode initCloudReqObjectNode() {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode cloudReqObjectNode = mapper.createObjectNode();
        ObjectNode paras = mapper.createObjectNode();
        paras.put("value", "10");
        cloudReqObjectNode.put("identifier", "123");
        cloudReqObjectNode.put("msgType", "cloudReq");
        cloudReqObjectNode.put("cmd", "SET_DEVICE_LEVEL");
        cloudReqObjectNode.put("paras", paras);
        cloudReqObjectNode.put("hasMore", 0);
        cloudReqObjectNode.put("mid", 2016);
        return cloudReqObjectNode;
    }

    /*
     * 初始化：设备对平台的响应码流
     */
    private static byte[] initDeviceRspByte() {
        /*
         * 测试用例：有命令短mid 设备应答消息:AA7201000107E0
         */
        byte[] byteDeviceRsp = new byte[12];
        byteDeviceRsp[0] = (byte) 0xAA;
        byteDeviceRsp[1] = (byte) 0x72;
        byteDeviceRsp[2] = (byte) 0x01;
        byteDeviceRsp[3] = (byte) 0x00;
        byteDeviceRsp[4] = (byte) 0x01;
        byteDeviceRsp[5] = (byte) 0x07;
        byteDeviceRsp[6] = (byte) 0xE0;
        return byteDeviceRsp;
    }

    /*
     * 初始化：平台对设备的应答数据
     */
    private static ObjectNode initCloudRspObjectNode(byte[] device2CloudByte) {

        ObjectMapper mapper = new ObjectMapper();
        ObjectNode cloudRspObjectNode = mapper.createObjectNode();
        cloudRspObjectNode.put("msgType", "cloudRsp");
        // 设备上报的码流
        cloudRspObjectNode.put("request", device2CloudByte);
        cloudRspObjectNode.put("errcode", 0);
        cloudRspObjectNode.put("hasMore", 0);
        return cloudRspObjectNode;
    }
}
