package com.zteits.nbiot.decoder;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

import java.util.Arrays;
import java.util.Date;

public class ZteitsCmdProcess {

    private String msgType = "cloudRsp";
    private String serviceId = "VehicleDetectorInfo";
    private String cmd = "SET_DEVICE_LEVEL";
    private int hasMore = 1;
    //请求处理的结果码,0表示成功，1表示失败
    private int errcode = 1;
    private int mid = 0;
    private byte[] requests;
    private JsonNode paras;


    public ZteitsCmdProcess() {
    }

    public ZteitsCmdProcess(ObjectNode input) {

        try {
            this.msgType = input.get("msgType").asText();
            this.requests = input.get("request").binaryValue();
            /*
            平台收到设备上报消息，编码ACK
            {
                "msgType":"cloudRsp",
                "request": ***,//设备上报的码流
                "errcode":0,
                "hasMore":0
            }
            * */
            if (msgType.equals("cloudRsp")) {
                //在此组装ACK的值
                this.errcode = input.get("errcode").asInt();
                this.hasMore = input.get("hasMore").asInt();
            }
        } catch (Exception e) {
            this.errcode = 1;
            e.printStackTrace();
        }

    }

    public byte[] toByte() {
        try {
            /*
            平台收到设备的上报数据，根据需要编码ACK，对设备进行响应，如果此处返回null，表示不需要对设备响应。
            * */
            if (this.msgType.equals("cloudRsp")) {

                byte[] ack = new byte[28];
                ack[0] = (byte) 0x77;
                ack[1] = (byte)0x00;
                //请求处理的结果码。
                //0表示成功，1表示失败
                if(errcode == 0){
                    ack[2] = (byte)0x70;
                }else if(errcode == 1){
                    ack[2] = (byte)0x30;
                }
                //packCount 2H
                ack[3] = requests[18];
                ack[4] = requests[19];
                //magId 4H
                ack[5] = requests[22];
                ack[6] = requests[23];
                ack[7] = requests[24];
                ack[8] = requests[25];
                //command 2H
                ack[9] = (byte)0x00;
                ack[10] = (byte)0x00;
                //时间8H
                ack[11] = (byte)0x00;
                ack[12] = (byte)0x00;
                ack[13] = (byte)0x00;
                ack[14] = (byte)0x00;
                Long time = new Date().getTime()/1000;
                byte[] timeByte = Utilty.int2Bytes(time.intValue(), 4);
                ack[15] = timeByte[0];
                ack[16] = timeByte[1];
                ack[17] = timeByte[2];
                ack[18] = timeByte[3];

                ack[19] = (byte)errcode;
                ack[20] = (byte)0x00;
                ack[21] = (byte)0x00;
                ack[22] = (byte)0x00;
                ack[23] = (byte)0x00;
                ack[24] = (byte)0x00;
                ack[25] = (byte)0x00;
                return CRC16Util.appendCrc16(ack);
            }
            return null;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

}
