package com.zteits.nbiot.decoder;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.huawei.m2m.cig.tup.modules.protocol_adapter.IProtocolAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


public class ProtocolAdapterImpl implements IProtocolAdapter {

    private static final Logger logger = LoggerFactory.getLogger(ProtocolAdapterImpl.class);
    // 厂商名称
    private static final String MANU_FACTURERID = "ZTEITS";
    private static final String MODEL = "ZTEITS";

    @Override
    public String getManufacturerId() {
        return MANU_FACTURERID;
    }

    @Override
    public String getModel() {
        return MODEL;
    }

    public void activate() {
        logger.info("Codec demo HttpMessageHander activated.");
    }

    public void deactivate() {
        logger.info("Codec demo HttpMessageHander deactivated.");
    }

    public byte[] encode(ObjectNode input) throws Exception {
        logger.info("接收到平台的信息为 " + input.toString());
        try {
            ZteitsCmdProcess cmdProcess = new ZteitsCmdProcess(input);
            byte[] byteNode = cmdProcess.toByte();
            return byteNode;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public ObjectNode decode(byte[] binaryData) throws Exception {
        try {
            logger.info("接收到的报文:"+Utilty.parseByte2HexStr(binaryData));
            ZteitsReportProcess zteitsReportProcess = new ZteitsReportProcess(binaryData);
            ObjectNode objectNode = zteitsReportProcess.toJsonNode();
            logger.info("dynamic zteitsReportProcess " + objectNode.toString());
            return objectNode;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

}
