package com.fh.party;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ReportProcess {
    private byte cmdid = 0x01;
    private int pid;
    private int tid;
    private int eventcnt;
    private int verno;
    private byte eventstate;

    //
    private String factoryCode = "fh";
    private String model = "fh";
    private int reportType;
    private int reportTime;
    private int state;
    private int packCount;
    private int voltage;
    private int magId;
    private int rssi;
    private int version;

    public ReportProcess(byte[] binaryData) throws ParseException {
        pid = binaryData[1];
        tid = binaryData[2];
        eventcnt = binaryData[3];
        verno = binaryData[4];
        eventstate = binaryData[5];
        if((eventstate & 1) == 1){
            reportType = 33;
        }
        if((eventstate & 2) == 2){
            reportType = 32;
        }
        if((eventstate & 3) == 3){
            reportType = 32;
        }
        magId = tid;
        reportTime = calLastedTime();
        if((eventstate & 32) == 32){
            state = 1;
        }else{
            state = 0;
        }
    }

    public ObjectNode toJsonNode() {
        try {
            //组装body体
            ObjectMapper mapper = new ObjectMapper();
            ObjectNode root = mapper.createObjectNode();
            // root.put("identifier", this.identifier);
            root.put("factoryCode", this.factoryCode);
            root.put("model", this.model);
            root.put("reportType", this.reportType);
            root.put("reportTime", this.reportTime);
            root.put("state", this.state);
            root.put("magId", this.magId);
            return root;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /**
     * 1970-1-1 经过的秒总数
     * @return
     */
    public static int calLastedTime() throws ParseException {
        long a = new Date().getTime();
        DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date startDate = dateFormat.parse("1970-01-01");
        long b = startDate.getTime();
        return (int)((a - b) / 1000);
    }

    /**
     * 将byte转换为一个长度为8的byte数组，数组每个值代表bit
     */
    public static byte[] byteToArray(byte b) {
        byte[] array = new byte[8];
        for (int i = 7; i >= 0; i--) {
            array[i] = (byte)(b & 1);
            b = (byte) (b >> 1);
        }
        return array;
    }

    /**
     * 把byte转为字符串的bit
     */
    public static String byteToBit(byte b) {
        return ""
                + (byte) ((b >> 7) & 0x1) + (byte) ((b >> 6) & 0x1)
                + (byte) ((b >> 5) & 0x1) + (byte) ((b >> 4) & 0x1)
                + (byte) ((b >> 3) & 0x1) + (byte) ((b >> 2) & 0x1)
                + (byte) ((b >> 1) & 0x1) + (byte) ((b >> 0) & 0x1);
    }

    public static void main(String[] args) throws ParseException {
    }
}