import org.apache.commons.lang.StringUtils;

import java.io.*;
import java.net.Socket;
import java.util.Scanner;

public class Test {
    private static Socket socket;
    private  DataInputStream reader ;
    private static PrintStream writer;
    private static Scanner scanner = new Scanner(System.in);


    public static void main(String[] args) throws IOException {
        new Test().startTheSocket();
    }



    //开始连接服务端
    private void startTheSocket() throws IOException{
        toConnectTheServer();//创建Socket并初始化
        openTheThreadToReceiveInfoFromServer();//开启一个新的线程来接受服务端发来的信息

        //一个循环，用于读取键盘的输入
        int i = 0;
        while(true) {
            i++;
            // 建立连接后获得输出流
            byte temp[] =  new byte[64];
            temp[0] = 0x20;temp[1] = (byte) 0x80;temp[2] = 0x04;temp[3] = 0x1a;temp[4] = 0x00;temp[5] = 0x01;
            temp[6] = 0x00;temp[7] = 0x00;temp[8] = 0x00;temp[9] = 0x17;temp[10] = 0x0d;temp[11] = 0x5a;
            temp[12] = (byte) 0x15;temp[13] = (byte) 0x00;temp[14] = 0x4a;temp[15] = 0x00;temp[16] = 0x00;temp[17] = 0x00;
            temp[18] = 0x00;temp[19] = 0x01;temp[20] = 0x01;temp[21] = 0x00;temp[22] = 0x00;temp[23] = 0x00;
            temp[24] = 0x01;temp[25] = 0x00;temp[26] = 0x07;temp[27] = (byte) 0xf0;temp[28] = 0x2a;temp[29] = 0x04;
            temp[30] = 0x01;temp[31] = 0x07;temp[32] = 0x00;temp[33] = 0x00;temp[34] = (byte) 0x69;temp[35] = (byte) 0x2b;
            System.out.println("开始向服务端发送第"+i+"次。。。");
            String yourMessage = scanner.nextLine();
            //不为空则发送信息
            if(yourMessage!=null) {
                if(i%3==0){
                    System.out.println("发送非正常的");
                    writer.write(new byte[4]);
                }else if(i%3==1){
                    System.out.println("发送非正常的11");
                    byte tt[] = new byte[4];
                    tt[0] = 0x22;
                    writer.write(tt);
                }else{
                    System.out.println("发送正常的");
                    writer.write(temp);
                }
                //writer.flush();//记得flush清空缓冲区
            }

            //判断是否退出
            if (yourMessage.equals("exit")) {
                disConnect();
                System.exit(0);
            }
        }
    }

    //创建一个Socket来连接本机的18080端口的服务端并初始化reader和writer
    private void toConnectTheServer() throws IOException {
        socket=new Socket("127.0.0.1",7890);
        //socket=new Socket("47.96.41.38",17890);
        reader = new DataInputStream(socket.getInputStream());
        writer = new PrintStream((socket.getOutputStream()),true);
    }

    private void openTheThreadToReceiveInfoFromServer() throws IOException {
        new Thread(new Runnable() {
            @Override
            public void run() {
                try {
                    printMessage();//打印从服务端收到的信息
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    //循环不断读取服务端的信息
    private void printMessage() throws IOException {
        while (true) {
            byte[] bytes = new byte[1024];
            int len;
            while ((len = reader.read(bytes)) != -1) {
                //注意指定编码格式，发送方和接收方一定要统一，建议使用UTF-8
                String sb = new String(bytes, 0, len,"UTF-8");
                if(!StringUtils.isBlank(sb.toString())){
                    System.out.println("get message from server: " + sb);
                }
            }
        }
    }

    //关闭各种
    private void disConnect() throws IOException {
        socket.close();
        reader.close();
        writer.close();
    }

}
