package com.zteits.job.util;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class TransUtil {

	public static String bytes2HexString(byte[] b,int size){
		StringBuffer result = new StringBuffer();
		String hex;
		for (int i=0; i<size;i++){
			hex=Integer.toHexString(b[i] & 0xFF);
			if(hex.length() == 1){
				hex = '0' + hex;
			}
			result.append(hex.toUpperCase());
		}
		return result.toString();
	}

	/**
	 * @Title:hexString2Bytes @Description:16进制字符串转字节数组 @param src
	 *                        16进制字符串 @return 字节数组 @throws
	 */
	public static byte[] hexString2Bytes(String src) {
		int l = src.length() / 2;
		byte[] ret = new byte[l];
		for (int i = 0; i < l; i++) {
			ret[i] = (byte) Integer.valueOf(src.substring(i * 2, i * 2 + 2), 16).byteValue();
		}
		return ret;
	}
	
	public static String MD5(String str){
		
		byte[] b;
		try {
			MessageDigest md5 = MessageDigest.getInstance("MD5");
			b = md5.digest(str.getBytes("utf-8"));
			return bytes2HexString(b,b.length);
		} catch (NoSuchAlgorithmException | UnsupportedEncodingException e) {
			e.printStackTrace();
		} 
		return null;
	}
	
	/**
	 * 将十进制转换成十六进制
	 * @param i
	 * @return
	 */
	public static String toHexString(Integer i){
		StringBuilder sb = new StringBuilder();
		sb.append(Integer.toHexString(i));
		while (sb.length()<8){
			sb.insert(0, "0");
		}
		return sb.toString();
	}
	
	/**
	 * 将十进制转换成十六进制
	 * @param i
	 * @return
	 */
	public static String toHexString(Long i){
		StringBuilder sb = new StringBuilder();
		sb.append(Long.toHexString(i));
		while (sb.length()<8){
			sb.insert(0, "0");
		}
		return sb.toString();
	}
	
	
	public static String getMac(String str){
		StringBuilder sb = new StringBuilder(str);
		while(sb.length() % 16 != 0){
			sb.append(0);
		}
		String mac=null;
		for(int i=0;i<sb.length();i=i+16){
			if(mac == null){
				mac=sb.substring(i, i+16);
			}else{
				mac = Long.toHexString(Long.parseLong(mac,16)^Long.parseLong(sb.substring(i, i+16),16));
			}
		}
		StringBuilder sb1 = new StringBuilder(mac);
		while(sb1.length()<16){
			sb1.insert(0, "0");
		}
		return sb1.toString();
	}
	
    /** 
     * 16进制字符串转换为字符串 
     *  
     * @param s 
     * @return 
     */  
    public static String hexStringToString(String s) {  
        if (s == null || s.equals("")) {  
            return null;  
        }  
        s = s.replace(" ", "");  
        byte[] baKeyword = new byte[s.length() / 2];  
        for (int i = 0; i < baKeyword.length; i++) {  
            try {  
                baKeyword[i] = (byte) (0xff & Integer.parseInt(  
                        s.substring(i * 2, i * 2 + 2), 16));  
            } catch (Exception e) {  
                e.printStackTrace();  
            }  
        }  
        try {  
            s = new String(baKeyword, "utf-8");  
            new String();  
        } catch (Exception e1) {  
            e1.printStackTrace();  
        }  
        return s;  
    } 
}
