package com.zteits.job.util;

import com.zteits.clouds.api.dto.park.param.*;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;


public class ParkBeanUtil {
	
	/**
	 * 将获取来的字节流转换为车位信息类
	 * @param builder
	 * @return
	 */
	public static BerthResponse parseToBerthBean(StringBuilder builder){
		if(builder.length()<94){
			return null;
		}
		int index = 74;
		BerthResponse bean = new BerthResponse();
		bean.setVer(builder.subSequence(index, index+=2).toString());
		String status = builder.subSequence(index, index+=2).toString();
		ErrorCode ec = ErrorCode.valueOf(Integer.parseInt(status, 16));
		bean.setStatus(ec==ErrorCode.SUCCESS);
		bean.setMessage(ec.toString());
		bean.setTotal(Integer.parseInt(builder.subSequence(index, index+=8).toString(), 16));
		int count = Integer.parseInt(builder.subSequence(index, index+=8).toString(), 16);
		bean.setCount(count);
		//装载车位对象
		bean.setList(fillBerthList(builder,index,count));
		return bean;
	}	
	
	public static List<BerthBean> fillBerthList(StringBuilder builder, int index, int count){
		List<BerthBean> list = new ArrayList<>();
		for(int i=0;i<count;i++){
			BerthBean berth = new BerthBean();
			berth.setBerthId(Long.parseLong(builder.subSequence(index, index+=8).toString(), 16));
			berth.setBerthNoLen(Integer.parseInt(builder.subSequence(index, index+=2).toString(), 16));
			String hexBerth = builder.subSequence(index, index+=(berth.getBerthNoLen()*2)).toString();
			berth.setBerthNo(TransUtil.hexStringToString(hexBerth));
			berth.setBerthType(builder.subSequence(index, index+=2).toString());
			berth.setParkId(Long.parseLong(builder.subSequence(index, index+=8).toString(), 16));
			berth.setIsOccupy(Integer.parseInt(builder.subSequence(index, index+=2).toString(), 16) );
			if(berth.getIsOccupy() == 1){
				berth.setOccupyTime(new Date(Long.parseLong(builder.subSequence(index, index+=8).toString(), 16)*1000));
			}
			berth.setFlag(Integer.parseInt(builder.subSequence(index, index+=2).toString(), 16));
			if(berth.getFlag() ==1){
				long mil = Long.parseLong(builder.subSequence(index, index+=8).toString(), 16);
				if(mil != 0){
					berth.setInTime(new Date(mil*1000));
				}
				berth.setLicenseLen(Integer.parseInt(builder.subSequence(index, index+=2).toString(), 16));
				String hexLicense = builder.subSequence(index, index+=(berth.getLicenseLen()*2)).toString();
				berth.setLicense(TransUtil.hexStringToString(hexLicense));
				berth.setStopType(Integer.parseInt(builder.subSequence(index, index+=2).toString(), 16));
				berth.setTimeOut(Integer.parseInt(builder.subSequence(index, index+=2).toString(), 16));
				berth.setIsOnline(Integer.parseInt(builder.subSequence(index, index+=2).toString(), 16));
				berth.setDeadTime(new Date(Long.parseLong(builder.subSequence(index, index+=8).toString(), 16)*1000));
				berth.setPhoneLen(Integer.parseInt(builder.subSequence(index, index+=2).toString(), 16));
				if(berth.getStopType()==13){
					String hexPhoneNo=builder.subSequence(index, index+=(berth.getPhoneLen()*2)).toString();
					berth.setPhoneNo(TransUtil.hexStringToString(hexPhoneNo));
				}
			}
			list.add(berth);
		}
		return list;
	}
	
	/**
	 * 将获取来的字节流转换为停车场信息类
	 * @param builder
	 * @return
	 */
	public static ParkResponse parseToParkBean(StringBuilder builder){
		if(builder.length()<94){
			return null;
		}
		int index = 74;
		ParkResponse bean = new ParkResponse();
		bean.setVer(builder.subSequence(index, index+=2).toString());
		String status = builder.subSequence(index, index+=2).toString();
		ErrorCode ec = ErrorCode.valueOf(Integer.parseInt(status, 16));
		bean.setStatus(ec==ErrorCode.SUCCESS);
		bean.setMessage(ec.toString());
		bean.setTotal(Integer.parseInt(builder.subSequence(index, index+=4).toString(), 16));
		int count = Integer.parseInt(builder.subSequence(index, index+=4).toString(), 16);
		bean.setCount(count);
		//中心点经纬度
		/*String lat = builder.subSequence(index, index+=16).toString();
		bean.setCenterLatitude(hexStringToString(lat));
		bean.setCenterLongitude(hexStringToString(builder.subSequence(index, index+=16).toString()));*/
		//装载停车场对象
		bean.setList(fillParkList(builder,index,count));
		return bean;
	}	
	
	public static List<ParkBean> fillParkList(StringBuilder builder, int index, int count){
		List<ParkBean> list = new ArrayList<>();
		for(int i=0;i<count;i++){
			ParkBean park = new ParkBean();
			park.setParkingId(Long.parseLong(builder.subSequence(index, index+=8).toString(), 16));
			park.setParkingNameLen(Integer.parseInt(builder.subSequence(index, index+=2).toString(), 16));
			String hexPark = builder.subSequence(index, index+=(park.getParkingNameLen()*2)).toString();
			park.setParkingName(TransUtil.hexStringToString(hexPark));
			park.setRoadId(Long.valueOf(builder.subSequence(index, index+=8).toString(), 16));
			park.setParkingCount(Integer.valueOf(builder.subSequence(index, index+=4).toString(), 16));
			park.setEmpty(Integer.valueOf(builder.subSequence(index, index+=4).toString(), 16));
			park.setType(Integer.valueOf((builder.subSequence(index, index+=2).toString()), 16));
			
			list.add(park);
		}
		return list;
	}
	
	/**
	 * 将获取来的字节流转换为路段信息类
	 * @param builder
	 * @return
	 */
	public static RoadResponse parseToRoadBean(StringBuilder builder){
		
		if(builder.length()<94){
			return null;
		}
		int index = 74;
		RoadResponse bean = new RoadResponse();
		bean.setVer(builder.subSequence(index, index+=2).toString());
		String status = builder.subSequence(index, index+=2).toString();
		ErrorCode ec = ErrorCode.valueOf(Integer.parseInt(status, 16));
		bean.setStatus(ec==ErrorCode.SUCCESS);
		bean.setMessage(ec.toString());
		//请求结点名字长度
		bean.setCurrentNameLen(Integer.parseInt(builder.subSequence(index, index+=2).toString(), 16));
		String hexroad = builder.subSequence(index, index+=(bean.getCurrentNameLen()*2)).toString();
		//请求结点名字
		bean.setCurrentName(TransUtil.hexStringToString(hexroad));
		bean.setTotal(Integer.parseInt(builder.subSequence(index, index+=4).toString(), 16));
		int count = Integer.parseInt(builder.subSequence(index, index+=4).toString(), 16);
		bean.setCount(count);
		//装载路段，区域对象
		bean.setList(fillRoadList(builder,index,count));
		return bean;
	}	
	
	public static List<RoadBean> fillRoadList(StringBuilder builder, int index, int count){
		List<RoadBean> list = new ArrayList<>();
		for(int i=0;i<count;i++){
			RoadBean road = new RoadBean();
			road.setRoadId(Long.parseLong(builder.subSequence(index, index+=8).toString(), 16));
			road.setRoadNameLen(Integer.parseInt(builder.subSequence(index, index+=2).toString(), 16));
			String hexroad = builder.subSequence(index, index+=(road.getRoadNameLen()*2)).toString();
			road.setRoadName(TransUtil.hexStringToString(hexroad));
			road.setFlag(Integer.valueOf(builder.subSequence(index, index+=2).toString(), 16) );
			road.setParkingCount(Integer.valueOf(builder.subSequence(index, index+=4).toString(), 16));
			road.setBerthCount(Long.valueOf(builder.subSequence(index, index+=8).toString(), 16));
			road.setEmty(Long.valueOf((builder.subSequence(index, index+=8).toString()), 16));
			list.add(road);
		}
		return list;
	}
	
	/**
	 * 将获取来的字节流转换为当前车位信息类
	 * @param builder
	 * @return
	 */
	public static CurBerthResponse parseToCurBerthBean(StringBuilder builder){
		if(builder.length()<94){
			return null;
		}
		int index = 74;
		CurBerthResponse bean = new CurBerthResponse();
		bean.setVer(builder.subSequence(index, index+=2).toString());
		String status = builder.subSequence(index, index+=2).toString();
		ErrorCode ec = ErrorCode.valueOf(Integer.parseInt(status, 16));
		bean.setStatus(ec==ErrorCode.SUCCESS);
		bean.setMessage(ec.toString());
		bean.setRoadOrPark(Long.valueOf(builder.subSequence(index, index+=8).toString(), 16));
		bean.setTotal(Integer.parseInt(builder.subSequence(index, index+=8).toString(), 16));
		int count = Integer.parseInt(builder.subSequence(index, index+=8).toString(), 16);
		bean.setCount(count);
		//装载当前车位对象
		bean.setList(fillCurBerthList(builder,index,count));
		return bean;
	}	
	
	public static List<CurBerthBean> fillCurBerthList(StringBuilder builder, int index, int count){
		List<CurBerthBean> list = new ArrayList<>();
		for(int i=0;i<count;i++){
			CurBerthBean berth = new CurBerthBean();
			berth.setBerthId(Long.parseLong(builder.subSequence(index, index+=8).toString(), 16));
			berth.setBerthNoLen(Integer.parseInt(builder.subSequence(index, index+=2).toString(), 16));
			String hexBerth = builder.subSequence(index, index+=(berth.getBerthNoLen()*2)).toString();
			berth.setBerthNo(TransUtil.hexStringToString(hexBerth));
			String parkId = builder.subSequence(index, index+=8).toString();
			berth.setParkId(Long.parseLong(parkId, 16));
			if(!berth.getParkId().equals("104000000")){
				continue;
			}
			berth.setFlag(Integer.parseInt(builder.subSequence(index, index+=2).toString(), 16));
			berth.setComeTime(new Date(Long.parseLong(builder.subSequence(index, index+=8).toString(), 16)*1000));
			berth.setDropped(Integer.parseInt(builder.subSequence(index, index+=2).toString(), 16));
			list.add(berth);
		}
		return list;
	}
}
