package com.zteits.job.util;

import org.mybatis.generator.api.CommentGenerator;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.dom.java.*;
import org.mybatis.generator.api.dom.xml.XmlElement;
import org.springframework.util.StringUtils;

import java.util.Properties;

/**
 * 自定义Mybatis注释  使用数据库中的注释
 *
 */
public class MybatisGeneratorCommon implements CommentGenerator{

	@Override
	public void addConfigurationProperties(Properties properties) {}

	@Override
	public void addFieldComment(Field field, IntrospectedTable introspectedTable,
			IntrospectedColumn introspectedColumn) {
		if(StringUtils.isEmpty(introspectedColumn.getRemarks()))
			return;
		field.addJavaDocLine("/**"+introspectedColumn.getRemarks()+"*/");		
	}

	@Override
	public void addFieldComment(Field field, IntrospectedTable introspectedTable) {}

	@Override
	public void addModelClassComment(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {}

	@Override
	public void addClassComment(InnerClass innerClass, IntrospectedTable introspectedTable) {}

	@Override
	public void addClassComment(InnerClass innerClass, IntrospectedTable introspectedTable, boolean markAsDoNotDelete) {}

	@Override
	public void addEnumComment(InnerEnum innerEnum, IntrospectedTable introspectedTable) {}

	@Override
	public void addGetterComment(Method method, IntrospectedTable introspectedTable,
			IntrospectedColumn introspectedColumn) {
		if(StringUtils.isEmpty(introspectedColumn.getRemarks()))
			return;
		method.addJavaDocLine("/**获取"+introspectedColumn.getRemarks()+"*/");		
	}

	@Override
	public void addSetterComment(Method method, IntrospectedTable introspectedTable,
			IntrospectedColumn introspectedColumn) {
		if(StringUtils.isEmpty(introspectedColumn.getRemarks()))
			return;
		method.addJavaDocLine("/**设置"+introspectedColumn.getRemarks()+"*/");
	}

	@Override
	public void addGeneralMethodComment(Method method, IntrospectedTable introspectedTable) {}

	@Override
	public void addJavaFileComment(CompilationUnit compilationUnit) {}

	@Override
	public void addComment(XmlElement xmlElement) {}

	@Override
	public void addRootComment(XmlElement rootElement) {}
}
