package com.zteits.job.util;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

/**
 * Copyright: Copyright (c) 2018  zteits
 *
 * @ClassName: com.clouds.common.threadpool
 * @Description: 自定义线程池 替代spring 默认实现的线程池
 * @version: v1.0.0
 * @author: atao
 * @date: 2018/3/22   下午7:59
 * Modification History:
 * Date         Author          Version      Description
 * ---------------------------------------------------------*
 * 2018/3/22      atao          v1.0.0          创建
 */
@Configuration
public class MyThreadPoolExecutor {


    // 线程池维护线程的最少数量
    private static final int SIZE_CORE_POOL = 15;

    // 线程池维护线程的最大数量
    private static final int SIZE_MAX_POOL = 15;

    @Bean
    public ThreadPoolTaskExecutor myTaskAsyncPool() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(SIZE_CORE_POOL);
        executor.setMaxPoolSize(SIZE_MAX_POOL);
        executor.setThreadNamePrefix("MyTaskAsyncPool-");
        executor.initialize();
        return executor;
    }


}
