package com.zteits.job.util;

public enum ErrorCode {

	SUCCESS(0),
	ERR_EQP(-1),
	ERR_SINGLEID(-2),
	ERR_PWD(-3),
	ERR_COM(-4),
	ERR_REP(-5),
	ERR_SERVICE(-6),
	ERR_REQUEST(-7),
	ERR_ROAD(-8),
	ERR_PARK(-9),
	ERR_BERTH(-10),
	ERR_PEM(-11);
	
	
	private final Integer value;
	
	Integer getValue(){
		return value;
	}
	
	private ErrorCode(Integer value){
		this.value=value;
	}
	
	public static ErrorCode valueOf(Integer value){
		switch (value) {
		case 0:
			return SUCCESS;
		case -1:
			return ERR_EQP;
		case -2:
			return ERR_SINGLEID;
		case -3:
			return ERR_PWD;
		case -4:
			return ERR_COM;
		case -5:
			return ERR_REP;
		case -6:
			return ERR_SERVICE;
		case -7:
			return ERR_REQUEST;
		case -8:
			return ERR_ROAD;
		case -9:
			return ERR_PARK;
		case -10:
			return ERR_BERTH;
		case -11:
			return ERR_PEM;
		default:
			return null;
		}
	}
	
	public  String toString(){
		switch (value) {
		case 0:
			return "成功";
		case -1:
			return "非法的设备";
		case -2:
			return "非法的标识ID";
		case -3:
			return "密码不对";
		case -4:
			return "非法的命令";
		case -5:
			return "非法的报文";
		case -6:
			return "服务器内部错误";
		case -7:
			return "请求参数有误";
		case -8:
			return "区域或路段不存在";
		case -9:
			return "停车场不存在";
		case -10:
			return "车位不存在";
		case -11:
			return "无操作权限";
		default:
			return null;
		}
	}
}
