package com.zteits.job.task.getfreeberths.impl;

import java.util.HashMap;
import java.util.Map;

import com.clouds.common.constants.CodeValKindEnum;
import com.zteits.job.domain.ParkingLot;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.clouds.common.utils.ApprntSignUtil;
import com.zteits.clouds.api.apibase.constants.AppPublicArgsEnum;
import com.zteits.clouds.api.apibase.constants.SourceTypeEnum;
import com.zteits.job.task.getfreeberths.base.FreeBerthCommonService;
import com.zteits.job.task.getfreeberths.base.ThirdFreeBerthServiceBeanName;
import com.zteits.job.task.getfreeberths.CallThirdQueryFreeBerthService;
import com.zteits.job.task.getfreeberths.param.GetRealFreeBerthsDO;
import com.zteits.job.util.HttpClientTutorial;

@Service(ThirdFreeBerthServiceBeanName.PublicBerthInfoService)
public class PublicQueryFreeBerthServiceImpl extends FreeBerthCommonService implements CallThirdQueryFreeBerthService {
	private static final Logger logger = LoggerFactory.getLogger(PublicQueryFreeBerthServiceImpl.class);

    @Override
    public GetRealFreeBerthsDO queryFreeBerths(ParkingLot parkingLot) {
        String sourceType = parkingLot.getSourceType()+"";
        String factoryName = "";
        CodeValKindEnum codeValKindEnum = null;
        if(SourceTypeEnum.QING_DAO.getValue().equals(Integer.valueOf(sourceType))){
            factoryName = "青岛";
            codeValKindEnum = CodeValKindEnum.QINGDAO_NOTICE_ADDRINFO;
        }else if(SourceTypeEnum.NAN_ZHE.getValue().equals(Integer.valueOf(sourceType))){
            factoryName = "南泽";
            codeValKindEnum = CodeValKindEnum.NANZE_NOTICE_ADDRINFO;
        }
        try {
            Map<String, String> map = queryUrlMap(codeValKindEnum);
            String appId = map.get("APP_ID");
            String appSecret = map.get("APP_SECRET");
            String url = map.get("URL");

            Map<String, Object> returnMap = new HashMap<>();
            returnMap.put(AppPublicArgsEnum.APP_ID.getCode(), appId);
            returnMap.put(AppPublicArgsEnum.APP_SALT.getCode(), appSecret);
            returnMap.put(AppPublicArgsEnum.APP_SIGN_TYPE.getCode(), "md5");
            returnMap.put("parkCode", parkingLot.getPlNo());
            String appSign = ApprntSignUtil.signRequest(returnMap, appSecret, "md5");
            returnMap.put("sign", appSign);
            String rs = "";
            String url1 = url + "/query/queryParkInfo";
            String plNoInfo = parkingLot.getPlName()+"["+parkingLot.getPlNo()+"]";
            String req = JSON.toJSONString(returnMap,true);
            logger.info(factoryName+" 获取"+plNoInfo+"空闲车位请求参数："+req+"------请求URL:"+url1);
            rs = HttpClientTutorial.httpPostRequest(url1, req);
            logger.info(factoryName+"获取"+plNoInfo+"空闲车位响应信息"+rs);
            //返回示例：{"code":"0","message":"成功","data":{"parkCode":"P32118200D","totalParkingSpace":"55","freeParkingSpace":"18"}}
            if(StringUtils.isBlank(rs)){
                logger.warn(factoryName+"获取空闲车位响应信息为空");
                return null;
            }
            JSONObject resultJson = JSON.parseObject(rs);
            if("0".equals(resultJson.getString("code"))){
                //成功
                GetRealFreeBerthsDO berthsDO = JSON.parseObject(resultJson.getString("data"),GetRealFreeBerthsDO.class);
                return berthsDO;
            }else{
                logger.warn(factoryName+"获取空闲车位请求参数："+req+"------请求URL:"+url1);
                logger.error(factoryName+"获取空闲车位接口返回失败："+rs);
            }
        } catch (Exception e) {
            logger.error(factoryName+"获取空闲车位接口失败",e);
        }
        return null;
    }
	
}
