package com.zteits.job.task.getfreeberths.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.clouds.common.cache.park.IRainPkNoRelationCacheUtil;
import com.clouds.common.constants.CodeValKindEnum;
import com.clouds.common.utils.ApprntSignUtil;
import com.clouds.common.utils.MD5Utils;
import com.zteits.clouds.api.apibase.constants.AppPublicArgsEnum;
import com.zteits.clouds.api.apibase.constants.SourceTypeEnum;
import com.zteits.job.domain.ParkingLot;
import com.zteits.job.task.getfreeberths.CallThirdQueryFreeBerthService;
import com.zteits.job.task.getfreeberths.base.FreeBerthCommonService;
import com.zteits.job.task.getfreeberths.base.ThirdFreeBerthServiceBeanName;
import com.zteits.job.task.getfreeberths.param.GetRealFreeBerthsDO;
import com.zteits.job.util.HttpClientTutorial;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

@Service(ThirdFreeBerthServiceBeanName.IrainQueryFreeBerthService)
public class IrainQueryFreeBerthServiceImpl extends FreeBerthCommonService implements CallThirdQueryFreeBerthService {
	private static final Logger logger = LoggerFactory.getLogger(IrainQueryFreeBerthServiceImpl.class);


    /**
     * 调用第三方接口查询空闲车位数
     * @throws IOException
     * 2018年5月11日 zhaowg
     */
    @Override
    public GetRealFreeBerthsDO queryFreeBerths(ParkingLot parkingLot) {
        String parkCode = IRainPkNoRelationCacheUtil.getIRainPayPkNoByPlNo(parkingLot.getPlNo());
        if(StringUtils.isBlank(parkCode)){
            return null;
        }
        String sourceTypeName = "艾润";
        CodeValKindEnum codeValKindEnum = CodeValKindEnum.IRAIN_NOTICE_ADDRINFO;
        Map<String, String> map = queryUrlMap(codeValKindEnum);
        String appId = map.get("APP_ID");
        String appSecret = map.get("APP_SECRET");
        String url = map.get("URL");
        Map<String, Object> paramss = new HashMap<String, Object>();
        try {
            Long time = System.currentTimeMillis();
            /**** 艾润 通知 */
            String md5 = MD5Utils.enMD5(appId + appSecret + time);
            paramss.put("appid", appId);
            paramss.put("sign", md5);
            paramss.put("timestamp", time);
            paramss.put("park_code", parkCode);
            String rs = "";
            logger.info("艾润空闲车位请求参数:"+ JSONObject.toJSONString(paramss));
            rs = HttpClientTutorial.httpPostRequest(url + "/park/QueryByCode", paramss);
            logger.info("艾润空闲车位响应信息:"+ JSONObject.toJSONString(rs));
            JSONObject jsonObject = JSON.parseObject(rs);
            if(jsonObject.getInteger("status")==1){
                GetRealFreeBerthsDO getRealFreeBerthsDO = new GetRealFreeBerthsDO();
                JSONObject data = jsonObject.getJSONObject("data");
                getRealFreeBerthsDO.setTotalParkingSpace(data.getInteger("space_total")+"");
                getRealFreeBerthsDO.setFreeParkingSpace(data.getInteger("space_empty")+"");
                getRealFreeBerthsDO.setParkCode(parkingLot.getPlNo());
                return getRealFreeBerthsDO;
            }else{
                logger.warn("艾润空闲车位请求参数:"+ JSONObject.toJSONString(paramss));
                logger.error("艾润响应状态为失败:"+rs);
            }
        } catch (Exception e) {
            logger.error("艾润空闲车位获取：" + e);
        }
        return null;
    }
}
