package com.zteits.job.task.getfreeberths.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

import com.alibaba.fastjson.JSON;
import com.zteits.job.domain.ParkingLot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.fastjson.JSONObject;
import com.clouds.common.constants.CodeValKindEnum;
import com.clouds.common.utils.MD5Utils;
import com.xiaoleilu.hutool.date.DateUtil;
import com.zteits.clouds.api.apibase.constants.ErrorType;
import com.zteits.clouds.api.apibase.exception.BizException;
import com.zteits.job.task.getfreeberths.base.FreeBerthCommonService;
import com.zteits.job.task.getfreeberths.base.ThirdFreeBerthServiceBeanName;
import com.zteits.job.task.getfreeberths.CallThirdQueryFreeBerthService;
import com.zteits.job.task.getfreeberths.param.GetRealFreeBerthsDO;
import com.zteits.job.util.HttpClientTutorial;

@Service(ThirdFreeBerthServiceBeanName.HongmenBerthInfoService)
public class HongmenQueryFreeBerthServiceImpl extends FreeBerthCommonService implements CallThirdQueryFreeBerthService {
	private static final Logger logger = LoggerFactory.getLogger(HongmenQueryFreeBerthServiceImpl.class);

    @Override
    public GetRealFreeBerthsDO queryFreeBerths(ParkingLot parkingLot) {
        String sourceTypeName = "红门";
        CodeValKindEnum codeValKindEnum = CodeValKindEnum.HONGMEN_NOTICE_ADDRINFO;
        Map<String, String> map = queryUrlMap(codeValKindEnum);
        String appId = map.get("APP_ID");
        String appSecret = map.get("APP_SECRET");
        String url = map.get("URL");
        String type = "PARKING_SPACE_QUERY";
        String requestId = UUID.randomUUID().toString();
        String timestamp = DateUtil.format(new Date(),"yyyyMMddHHmmss");
        Map<String, Object> returnMap = new HashMap<>();
        returnMap.put("type", type);
        returnMap.put("appId", appId);
        returnMap.put("requestId", requestId);
        returnMap.put("timestamp", timestamp);
        returnMap.put("sign",(MD5Utils.enMD5(appId + requestId + type + appSecret + timestamp)).toLowerCase());
        Map<String, Object> body = new HashMap<>();
        body.put("parkingId", parkingLot.getPlOutNo());
        returnMap.put("body", body);
            
        String rs = "";
        String plNoInfo = parkingLot.getPlName()+"["+parkingLot.getPlNo()+"]";
        try {
            String req = JSON.toJSONString(returnMap,true);
            logger.info(sourceTypeName+" 获取"+plNoInfo+"空闲车位请求参数："+req+"------请求URL:"+url);
            rs = HttpClientTutorial.httpPostRequest(url, req);
            logger.info(sourceTypeName+"获取"+plNoInfo+"空闲车位响应信息"+rs);
        }catch (Exception e) {
            logger.error(sourceTypeName+"获取"+plNoInfo+"空闲车位信息异常",e);
            return null;
        }
        if(StringUtils.isBlank(rs)){
            logger.error(sourceTypeName+"获取"+plNoInfo+"空闲车位信息返回空");
            return null;
        }

        JSONObject jsobj = JSONObject.parseObject(rs);
        String code = jsobj.getString("code");
        GetRealFreeBerthsDO getRealFreeBerthsDO = new GetRealFreeBerthsDO();
        if (code.equals("SUCCESS")) {
            //开始解析
            if(StringUtils.isBlank(jsobj.getString("body"))){
                logger.error(sourceTypeName+"获取"+plNoInfo+"空闲车位信息返回无body字段",rs);
                return null;
            }
            JSONObject bodyObj = JSONObject.parseObject(jsobj.getString("body"));
            getRealFreeBerthsDO.setFreeParkingSpace(bodyObj.getInteger("available")+"");
            getRealFreeBerthsDO.setParkCode(parkingLot.getPlNo());
            getRealFreeBerthsDO.setTotalParkingSpace(bodyObj.getInteger("total")+"");
            return getRealFreeBerthsDO;
        }
        return null;
    }
    
}
