package com.zteits.job.task.getfreeberths.base;

import java.util.Map;

import com.zteits.job.task.getfreeberths.CallThirdQueryFreeBerthService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.zteits.clouds.api.apibase.constants.ErrorType;
import com.zteits.clouds.api.apibase.constants.SourceTypeEnum;
import com.zteits.clouds.api.apibase.exception.BizException;

/**
 * 业务服务路由
 * Copyright: Copyright (c) 2017  zteits
 *
 * @ClassName: ThirdBerthInfoServiceRoute.java
 * @Description:
 * @version: v1.0.0
 * @author: wangfei
 * @date: 2018年9月13日   上午10:13:42
 * Modification History:
 * Date         Author          Version      Description
 * ---------------------------------------------------------*
 * 2018年9月13日      wangfei          v1.0.0          创建
 */
public class ThirdFreeBerthServiceRoute {
	private static final Logger logger = LoggerFactory.getLogger(ThirdFreeBerthServiceRoute.class);
	
	/**
	 * 根据数据来源路由具体的业务服务-后期可以将路由关系配置到数据库，缓存等
	 * @param typeEnum
	 * @param serviceMap
	 * @return
	 * 2018年9月13日 wangfei
	 */
    public static CallThirdQueryFreeBerthService selectThirdBerthService(SourceTypeEnum typeEnum, Map<String, CallThirdQueryFreeBerthService> serviceMap) {
        logger.info("开始数据来源类型:"+typeEnum.getDesc()+" 路由具体的业务服务");
        String serviceBeanName = "";
        switch (typeEnum) {
        /**青岛-公共接口*/
        case QING_DAO:
            serviceBeanName = ThirdFreeBerthServiceBeanName.PublicBerthInfoService;
            break;
        /**南泽-公共接口*/
            case NAN_ZHE:
            serviceBeanName = ThirdFreeBerthServiceBeanName.PublicBerthInfoService;
            break;
        /**红门*/
        case HONG_MEN:
            serviceBeanName = ThirdFreeBerthServiceBeanName.HongmenBerthInfoService;
            break;
        /**艾润*/
        case IRAIN:
            serviceBeanName = ThirdFreeBerthServiceBeanName.IrainQueryFreeBerthService;
            break;
        default:
            break;
        }
        if(!serviceMap.containsKey(serviceBeanName)){
            throw new BizException(ErrorType.APP_ERROR,"根据数据来源："+typeEnum.getDesc()+"没有找到对应的处理业务服务",false);
        }
        CallThirdQueryFreeBerthService service = serviceMap.get(serviceBeanName);
        logger.info("根据数据来源："+typeEnum.getDesc()+" 路由到的业务服务为："+service.getClass().getName());
        return service;
    }
}
