package com.zteits.job.task.getfreeberths.base;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.alibaba.dubbo.common.utils.StringUtils;
import com.clouds.common.cache.sys.SysCodeValueCacheUtil;
import com.clouds.common.constants.CodeValKindEnum;
import com.clouds.common.utils.ResultUtils;
import com.zteits.clouds.api.apibase.bean.BizResult;
import com.zteits.clouds.api.apibase.constants.BasicEnum;
import com.zteits.clouds.api.apibase.constants.ErrorType;
import com.zteits.clouds.api.apibase.exception.BizException;
import com.zteits.clouds.api.dto.sys.DataDicKindDetailDTO;
import com.zteits.clouds.api.dto.sys.param.DataDicKindDetailRequest;
import com.zteits.job.service.DataDictionaryService;

@Component
public class FreeBerthCommonService {
    @Autowired
    private DataDictionaryService dataDictionaryService;

    protected Map<String,String> queryUrlMap(CodeValKindEnum codeValKindEnum){
        //获取对应的配置文件
        Map<String, String> map = SysCodeValueCacheUtil.queryCodeValueAndNames(codeValKindEnum);
        if(map==null || map.isEmpty()){
            DataDicKindDetailRequest dataDicKindDetailRequest = new DataDicKindDetailRequest();
            dataDicKindDetailRequest.setCodeKind(codeValKindEnum.name());
            dataDicKindDetailRequest.setSysCode(BasicEnum.SYS_CODE.getValue());
            BizResult<List<DataDicKindDetailDTO>> bizResult = dataDictionaryService.getDataDictionaryKindDetails(dataDicKindDetailRequest);
            List<DataDicKindDetailDTO> dataDicKindDetailDTOS = ResultUtils.getBizResultData(bizResult);
            if(CollectionUtils.isEmpty(dataDicKindDetailDTOS)){
                throw new BizException(ErrorType.SYS_CODE_NOT_CONFIG,"字典表未配置"+codeValKindEnum.name(),false);
            }
            map = dataDicKindDetailDTOS.stream().collect(Collectors.toMap(DataDicKindDetailDTO::getCodeValue,DataDicKindDetailDTO::getCodeValueName));
        }
        String appId = map.get("APP_ID");
        String appSecret = map.get("APP_SECRET");
        String url = map.get("URL");
        if(StringUtils.isBlank(appId)){
            throw new BizException(ErrorType.SYS_CODE_NOT_CONFIG,"字典表"+codeValKindEnum.name()+"APP_ID为空",false);
        }
        if(StringUtils.isBlank(appSecret)){
            throw new BizException(ErrorType.SYS_CODE_NOT_CONFIG,"字典表"+codeValKindEnum.name()+"APP_SECRET为空",false);
        }
        if(StringUtils.isBlank(url)){
            throw new BizException(ErrorType.SYS_CODE_NOT_CONFIG,"字典表"+codeValKindEnum.name()+"URL为空",false);
        }
        return map;
    }
}
