package com.zteits.job.task.fangge.impl;

import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.zteits.clouds.api.apibase.constants.ErrorType;
import com.zteits.clouds.api.apibase.exception.BizException;
import com.zteits.clouds.api.dto.park.dto.ParkingLotDTO;
import com.zteits.clouds.api.dto.park.param.InitBerthState;
import com.zteits.clouds.api.dto.park.param.InitBerthStateRequest;
import com.zteits.job.constant.BerthConstant;
import com.zteits.job.constant.EqpConstant;
import com.zteits.job.dao.park.BerthsDao;
import com.zteits.job.dao.park.EqpDao;
import com.zteits.job.dao.park.ParkFreeBerthDao;
import com.zteits.job.dao.park.ParkingLotDao;
import com.zteits.job.domain.TpPBerths;
import com.zteits.job.task.fangge.FangGeBerthsOperService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Component
public class FangGeBerthsOperServiceImpl implements FangGeBerthsOperService {
    @Autowired
    private ParkingLotDao parkingLotDao;
    @Autowired
    private BerthsDao berthsDao;
    @Autowired
    private EqpDao eqpDao;
    @Autowired
    private ParkFreeBerthDao parkFreeBerthDao;
    @Transactional
    @Override
    public Boolean initBerthState(InitBerthStateRequest request) {
        //通过外部停车场编号查询停车场信息
        ParkingLotDTO dto = parkingLotDao.queryParkingLotInfoByPlOutNo(request.getPlOutNo());
        if(dto == null){
            throw new BizException(ErrorType.BIZ_ERROR, "根据外部停车场编号["+request.getPlOutNo()+"没有找到对应停车场信息]");
        }
        List<InitBerthState> berthStates = request.getInitBerthState();
        if(CollectionUtils.isEmpty(berthStates)){
            return true;
        }
        //车位状态批量更新为空闲
        berthsDao.batchUpdateBerthStateForFree(dto.getPlNo(), null);
        //设备状态批量更新为故障
        eqpDao.batchUpdateEqpStateForFault(dto.getPlNo(), request.getEqpType());

        List<String> onlineBerths = new ArrayList<>();
        for (InitBerthState initBerthStateVO : berthStates) {
            if(initBerthStateVO.getIsOccupy().equals(BerthConstant.isOccupy.HAVE_CAR)){
                //更新车位状态为占用
                this.updateBerthByEqpReport(initBerthStateVO.getIsOccupy(), initBerthStateVO.getEqpReportTime(), initBerthStateVO.getBerthNo(), dto.getPlNo());
            }

            if(initBerthStateVO.getEqpIsOnline().equals(EqpConstant.IS_ONLINE.ON_LINE)){
                onlineBerths.add(initBerthStateVO.getBerthNo());
            }
        }
        if(!CollectionUtils.isEmpty(onlineBerths)){
            //更新设备状态为在线
            eqpDao.updateEqpStatusByBerthsNo(EqpConstant.IS_ONLINE.ON_LINE, onlineBerths, dto.getPlNo(), request.getEqpType());
        }
        //更新停车场空闲车位数
        parkFreeBerthDao.updateFreeBerthNumByPlNo(dto.getPlNo());
        return true;
    }

    /**
     * 根据设备更新车位状态
     * @param isOccupy
     * @param eqpReportTime
     * @param berthNo
     * @param plNo
     * 2017年11月2日 zhaowg
     */
    private void updateBerthByEqpReport(String isOccupy, Date eqpReportTime, String berthNo,
                                        String plNo) {
        TpPBerths tpPBerths = new TpPBerths();
        tpPBerths.setBerthNo(berthNo);
        tpPBerths.setPlNo(plNo);
        tpPBerths.setIsOccupy(isOccupy);
        if(isOccupy.equals(BerthConstant.isOccupy.NO_CAR)){
            tpPBerths.setEqpOutTime(eqpReportTime);
        }else if(isOccupy.equals(BerthConstant.isOccupy.HAVE_CAR)){
            tpPBerths.setEqpInTime(eqpReportTime);
        }
        tpPBerths.setModifyTime(new Date());
        berthsDao.updateBerthInfoByBerthNoAndPlNo(tpPBerths );
    }
}
