package com.zteits.job.task.fangge;

import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.zteits.clouds.api.dto.park.param.BerthBean;
import com.zteits.clouds.api.dto.park.param.BerthResponse;
import com.zteits.clouds.api.dto.park.param.InitBerthState;
import com.zteits.clouds.api.dto.park.param.InitBerthStateRequest;
import com.zteits.job.util.ParkBeanUtil;
import com.zteits.job.util.TransUtil;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 物联网小镇JOB，获取全部泊位信息,更新空闲车位，推送空闲车位信息
 */
//@Component
public class GetBerthsInfoForTownJob {
    private static final Logger logger = LoggerFactory.getLogger(GetBerthsInfoForTownJob.class);
    @Value("${project.syscode}")
    private String sysCode;
    @Value("${fangle.SERVER}")
    private String SERVER;
    @Value("${fangle.SERVPORT}")
    private int SERVPORT;
    @Value("${fangle.TIMEOUT}")
    private int TIMEOUT;
    @Autowired
    private FangGeBerthsOperService fangGeBerthsOperService;
    /**
     * 间隔10秒执行一次
     *
     * 2018年5月4日 zhaowg
     */
    @Scheduled(fixedDelay=10000)
    public void execute(){
        if(StringUtils.isBlank(SERVER)){
            return;
        }
        String cmd = "AA00000000000000000000000000000000000000000000000000000000000000E20000000A0400000190010632EA00EE00000190010632";
        logger.debug("请求参数："+cmd);
        StringBuilder builder =  sendMessage(cmd);
        logger.debug("返回参数："+builder);
        BerthResponse result =  ParkBeanUtil.parseToBerthBean(builder);

        if(CollectionUtils.isEmpty(result.getList())){
            return;
        }
        logger.debug("开始更新车位数据");
        //按照停车场编号分组
        Map<String,List<InitBerthState>> pkmap = Maps.newHashMap();
        for (BerthBean curBerth : result.getList()) {
            String plOutNo = curBerth.getParkId()+"";
            List<InitBerthState> berths = Lists.newArrayList();
            if(pkmap.containsKey(plOutNo)){
                berths = pkmap.get(plOutNo);
            }

            InitBerthState berthState = new InitBerthState();
            berthState.setBerthNo("FG_"+curBerth.getBerthNo());
            berthState.setEqpIsOnline(curBerth.getIsOnline()==null?"0":curBerth.getIsOnline()+"");
            berthState.setEqpReportTime(new Date());
            /**车位状态： 1有车，2无车,3异常*/
            berthState.setIsOccupy(curBerth.getFlag()==0?"2":"1");

            berths.add(berthState);

            pkmap.put(plOutNo, berths);
        }

        //初始化车位状态
        for (Map.Entry<String, List<InitBerthState>> entry : pkmap.entrySet()) {
            InitBerthStateRequest request = new InitBerthStateRequest();
            request.setSysCode(sysCode);
            request.setInitBerthState(entry.getValue());
            /**设备类型 字典表[TD_P_EQP_EQP_TYPE] 1-地磁；2-视频桩；3-地锁等*/
            request.setEqpType(1);
            request.setPlOutNo(entry.getKey());
            fangGeBerthsOperService.initBerthState(request );
        }
        logger.info("更新车位数据完成");
    }

    //发送socket
    private StringBuilder sendMessage(String cmd){
        StringBuilder builder = new StringBuilder();
        try (Socket socket = new Socket(SERVER, SERVPORT)) {
            socket.setSoTimeout(TIMEOUT);
            OutputStream out = socket.getOutputStream();
            out.write(TransUtil.hexString2Bytes(cmd));
            out.flush();
            // 从服务端程序接收数据
            InputStream in = socket.getInputStream();
            BufferedInputStream bis = new BufferedInputStream(in);
            byte[] buffer = new byte[8194];
            int c;
            c=bis.read(buffer);
//		        while ((c=bis.read(buffer))!=-1) {
            builder.append(TransUtil.bytes2HexString(buffer,c));
//		        }
        } catch (Exception e) {

            logger.error("socket发送信息失败",e);
        }
        return builder;
    }
}
