/**
 * 
 */
package com.zteits.job.service.impl;

import java.util.List;
import java.util.Map;

import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.alibaba.fastjson.JSON;
import com.clouds.common.cache.sys.SysCodeValueCacheUtil;
import com.google.common.collect.Maps;
import com.zteits.clouds.api.apibase.bean.BizResult;
import com.zteits.clouds.api.apibase.constants.DataStatusEnum;
import com.zteits.clouds.api.apibase.constants.ErrorType;
import com.zteits.clouds.api.apibase.exception.BizException;
import com.zteits.clouds.api.dto.sys.DataDicKindDetailDTO;
import com.zteits.clouds.api.dto.sys.SysCodeValueDTO;
import com.zteits.clouds.api.dto.sys.param.DataDicKindDetailRequest;
import com.zteits.job.dao.sys.SysCodeValueDao;
import com.zteits.job.domain.SysCodeValue;
import com.zteits.job.domain.SysCodeValueExample;
import com.zteits.job.service.DataDictionaryService;


/**
 * @author hxz
 *
 */
@Component
public class DataDictionaryServiceImpl implements DataDictionaryService {

	@Autowired
	private SysCodeValueDao sysCodeValueDao;
	

	@Override
	public BizResult<List<DataDicKindDetailDTO>> getDataDictionaryKindDetails(DataDicKindDetailRequest requestObject) {	
		if (null == requestObject) {
            throw new BizException(ErrorType.PARAMM_NULL, "请求对象为空");
        }
		
		SysCodeValueExample example = new SysCodeValueExample ();
		example.createCriteria().andCodeKindEqualTo(requestObject.getCodeKind()).andDataStateEqualTo(DataStatusEnum.DATA_STATUS_VALID.value());
		List<SysCodeValue> sysCodeValueDOList = sysCodeValueDao.getDataDictionaryKindDetails(example);
		List<DataDicKindDetailDTO> dataDicKindDetailDTOList = null;
		if (null != sysCodeValueDOList) {
			//放入缓存
			Map<String,SysCodeValueDTO> sysCodeDTOs = Maps.newLinkedHashMap();
			for (SysCodeValue codeValue : sysCodeValueDOList) {
				SysCodeValueDTO dto = new SysCodeValueDTO();
				BeanUtils.copyProperties(codeValue, dto);
				sysCodeDTOs.put(codeValue.getCodeValue(),dto);
			}
			SysCodeValueCacheUtil.setCodeValues(requestObject.getCodeKind().toUpperCase(),sysCodeDTOs);
			dataDicKindDetailDTOList = JSON.parseArray(JSON.toJSONString(sysCodeValueDOList, false), DataDicKindDetailDTO.class);
		}
		return new BizResult<List<DataDicKindDetailDTO>>(dataDicKindDetailDTOList);
	}
	

}
