package com.zteits.job.domain;

import java.util.Date;

public class ParkingLot {
    /**停车场主键*/
    private Long plId;

    /**停车场名称*/
    private String plName;

    /**停车场编码*/
    private String plNo;

    /**停车场外部编码*/
    private String plOutNo;

    /**停车场状态：1-使用中，2-演示停车场*/
    private Integer state;

    /**数据来源类型：1-艾润;2-路测;3-捷商;4-南泽 ;5-共享车位，6:青岛（注:和parking_lot表中source_type保持一致）*/
    private Integer sourceType;

    /**省份ID*/
    private Long plProvinceId;

    /**省份名称*/
    private String plProvinceName;

    /**城市ID*/
    private Long plCityId;

    /**城市名称*/
    private String plCityName;

    /**区县ID*/
    private Long plCountryId;

    /**区县名称*/
    private String plCountryName;

    /**停车场地址*/
    private String plAddress;

    /**停车泊位数*/
    private Integer plBerthNum;

    /**停车场收费方式:0-免费，1-收费*/
    private Integer plPayType;

    /**充电桩泊位数量*/
    private Integer plChargeNum;

    /**停车场类型:1:路内、占用道路停车位、路侧停车场，2-路外、封闭停车场*/
    private Integer plType;

    /**停车场类型属性：1000-路内分类：1101-临时车位，1201-长时车位，1301-禁停车位；2000-路外停车属性：2100-建筑物，2101-住宅小区，2102-学校，2103-医院，2104-物流专用，2105-商业综合体，2106-政府事业单位；2200-城市公共，2201-公共场所，2202-交通枢纽*/
    private String plTypeProp;

    /**营业开始时间*/
    private String plBusiTimeStart;

    /**营业结束时间*/
    private String plBusiTimeEnd;

    /**停车场入口数量*/
    private Integer plEntranceNum;

    /**停车场出口数量*/
    private Integer plExitNum;

    /**数据状态:0-失效,1-生效*/
    private Integer dataStatus;

    /**创建时间*/
    private Date createTime;

    /**创建人*/
    private Long createOp;

    /**更新时间*/
    private Date modifyTime;

    /**更新人*/
    private Long modifyOp;

    /**停车场收费描述，多段内容使用‘#’分隔*/
    private String plRate;

    /**服务电话*/
    private String serviceTel;

    /**停车场图片*/
    private String plPicturePath;

    /**停车场商圈属性:1:商场、2:医院、3:小区、4:学校、5:写字楼、6:景区、7:交通场站、8:其他*/
    private Integer busiCircle;

    /**备注*/
    private String remark;

    /**块id*/
    private Long plAreaBlockId;

    /**块名称*/
    private String plAreaBlockName;

    /**营业类型：1:自营，2:非自营*/
    private String plBusiType;

    /**服务点对应二级组织ID*/
    private Long orgId;

    /**组织名称*/
    private String orgName;

    /**获取停车场主键*/
    public Long getPlId() {
        return plId;
    }

    /**设置停车场主键*/
    public void setPlId(Long plId) {
        this.plId = plId;
    }

    /**获取停车场名称*/
    public String getPlName() {
        return plName;
    }

    /**设置停车场名称*/
    public void setPlName(String plName) {
        this.plName = plName == null ? null : plName.trim();
    }

    /**获取停车场编码*/
    public String getPlNo() {
        return plNo;
    }

    /**设置停车场编码*/
    public void setPlNo(String plNo) {
        this.plNo = plNo == null ? null : plNo.trim();
    }

    /**获取停车场外部编码*/
    public String getPlOutNo() {
        return plOutNo;
    }

    /**设置停车场外部编码*/
    public void setPlOutNo(String plOutNo) {
        this.plOutNo = plOutNo == null ? null : plOutNo.trim();
    }

    /**获取停车场状态：1-使用中，2-演示停车场*/
    public Integer getState() {
        return state;
    }

    /**设置停车场状态：1-使用中，2-演示停车场*/
    public void setState(Integer state) {
        this.state = state;
    }

    /**获取数据来源类型：1-艾润;2-路测;3-捷商;4-南泽 ;5-共享车位，6:青岛（注:和parking_lot表中source_type保持一致）*/
    public Integer getSourceType() {
        return sourceType;
    }

    /**设置数据来源类型：1-艾润;2-路测;3-捷商;4-南泽 ;5-共享车位，6:青岛（注:和parking_lot表中source_type保持一致）*/
    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    /**获取省份ID*/
    public Long getPlProvinceId() {
        return plProvinceId;
    }

    /**设置省份ID*/
    public void setPlProvinceId(Long plProvinceId) {
        this.plProvinceId = plProvinceId;
    }

    /**获取省份名称*/
    public String getPlProvinceName() {
        return plProvinceName;
    }

    /**设置省份名称*/
    public void setPlProvinceName(String plProvinceName) {
        this.plProvinceName = plProvinceName == null ? null : plProvinceName.trim();
    }

    /**获取城市ID*/
    public Long getPlCityId() {
        return plCityId;
    }

    /**设置城市ID*/
    public void setPlCityId(Long plCityId) {
        this.plCityId = plCityId;
    }

    /**获取城市名称*/
    public String getPlCityName() {
        return plCityName;
    }

    /**设置城市名称*/
    public void setPlCityName(String plCityName) {
        this.plCityName = plCityName == null ? null : plCityName.trim();
    }

    /**获取区县ID*/
    public Long getPlCountryId() {
        return plCountryId;
    }

    /**设置区县ID*/
    public void setPlCountryId(Long plCountryId) {
        this.plCountryId = plCountryId;
    }

    /**获取区县名称*/
    public String getPlCountryName() {
        return plCountryName;
    }

    /**设置区县名称*/
    public void setPlCountryName(String plCountryName) {
        this.plCountryName = plCountryName == null ? null : plCountryName.trim();
    }

    /**获取停车场地址*/
    public String getPlAddress() {
        return plAddress;
    }

    /**设置停车场地址*/
    public void setPlAddress(String plAddress) {
        this.plAddress = plAddress == null ? null : plAddress.trim();
    }

    /**获取停车泊位数*/
    public Integer getPlBerthNum() {
        return plBerthNum;
    }

    /**设置停车泊位数*/
    public void setPlBerthNum(Integer plBerthNum) {
        this.plBerthNum = plBerthNum;
    }

    /**获取停车场收费方式:0-免费，1-收费*/
    public Integer getPlPayType() {
        return plPayType;
    }

    /**设置停车场收费方式:0-免费，1-收费*/
    public void setPlPayType(Integer plPayType) {
        this.plPayType = plPayType;
    }

    /**获取充电桩泊位数量*/
    public Integer getPlChargeNum() {
        return plChargeNum;
    }

    /**设置充电桩泊位数量*/
    public void setPlChargeNum(Integer plChargeNum) {
        this.plChargeNum = plChargeNum;
    }

    /**获取停车场类型:1:路内、占用道路停车位、路侧停车场，2-路外、封闭停车场*/
    public Integer getPlType() {
        return plType;
    }

    /**设置停车场类型:1:路内、占用道路停车位、路侧停车场，2-路外、封闭停车场*/
    public void setPlType(Integer plType) {
        this.plType = plType;
    }

    /**获取停车场类型属性：1000-路内分类：1101-临时车位，1201-长时车位，1301-禁停车位；2000-路外停车属性：2100-建筑物，2101-住宅小区，2102-学校，2103-医院，2104-物流专用，2105-商业综合体，2106-政府事业单位；2200-城市公共，2201-公共场所，2202-交通枢纽*/
    public String getPlTypeProp() {
        return plTypeProp;
    }

    /**设置停车场类型属性：1000-路内分类：1101-临时车位，1201-长时车位，1301-禁停车位；2000-路外停车属性：2100-建筑物，2101-住宅小区，2102-学校，2103-医院，2104-物流专用，2105-商业综合体，2106-政府事业单位；2200-城市公共，2201-公共场所，2202-交通枢纽*/
    public void setPlTypeProp(String plTypeProp) {
        this.plTypeProp = plTypeProp == null ? null : plTypeProp.trim();
    }

    /**获取营业开始时间*/
    public String getPlBusiTimeStart() {
        return plBusiTimeStart;
    }

    /**设置营业开始时间*/
    public void setPlBusiTimeStart(String plBusiTimeStart) {
        this.plBusiTimeStart = plBusiTimeStart == null ? null : plBusiTimeStart.trim();
    }

    /**获取营业结束时间*/
    public String getPlBusiTimeEnd() {
        return plBusiTimeEnd;
    }

    /**设置营业结束时间*/
    public void setPlBusiTimeEnd(String plBusiTimeEnd) {
        this.plBusiTimeEnd = plBusiTimeEnd == null ? null : plBusiTimeEnd.trim();
    }

    /**获取停车场入口数量*/
    public Integer getPlEntranceNum() {
        return plEntranceNum;
    }

    /**设置停车场入口数量*/
    public void setPlEntranceNum(Integer plEntranceNum) {
        this.plEntranceNum = plEntranceNum;
    }

    /**获取停车场出口数量*/
    public Integer getPlExitNum() {
        return plExitNum;
    }

    /**设置停车场出口数量*/
    public void setPlExitNum(Integer plExitNum) {
        this.plExitNum = plExitNum;
    }

    /**获取数据状态:0-失效,1-生效*/
    public Integer getDataStatus() {
        return dataStatus;
    }

    /**设置数据状态:0-失效,1-生效*/
    public void setDataStatus(Integer dataStatus) {
        this.dataStatus = dataStatus;
    }

    /**获取创建时间*/
    public Date getCreateTime() {
        return createTime;
    }

    /**设置创建时间*/
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    /**获取创建人*/
    public Long getCreateOp() {
        return createOp;
    }

    /**设置创建人*/
    public void setCreateOp(Long createOp) {
        this.createOp = createOp;
    }

    /**获取更新时间*/
    public Date getModifyTime() {
        return modifyTime;
    }

    /**设置更新时间*/
    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    /**获取更新人*/
    public Long getModifyOp() {
        return modifyOp;
    }

    /**设置更新人*/
    public void setModifyOp(Long modifyOp) {
        this.modifyOp = modifyOp;
    }

    /**获取停车场收费描述，多段内容使用‘#’分隔*/
    public String getPlRate() {
        return plRate;
    }

    /**设置停车场收费描述，多段内容使用‘#’分隔*/
    public void setPlRate(String plRate) {
        this.plRate = plRate == null ? null : plRate.trim();
    }

    /**获取服务电话*/
    public String getServiceTel() {
        return serviceTel;
    }

    /**设置服务电话*/
    public void setServiceTel(String serviceTel) {
        this.serviceTel = serviceTel == null ? null : serviceTel.trim();
    }

    /**获取停车场图片*/
    public String getPlPicturePath() {
        return plPicturePath;
    }

    /**设置停车场图片*/
    public void setPlPicturePath(String plPicturePath) {
        this.plPicturePath = plPicturePath == null ? null : plPicturePath.trim();
    }

    /**获取停车场商圈属性:1:商场、2:医院、3:小区、4:学校、5:写字楼、6:景区、7:交通场站、8:其他*/
    public Integer getBusiCircle() {
        return busiCircle;
    }

    /**设置停车场商圈属性:1:商场、2:医院、3:小区、4:学校、5:写字楼、6:景区、7:交通场站、8:其他*/
    public void setBusiCircle(Integer busiCircle) {
        this.busiCircle = busiCircle;
    }

    /**获取备注*/
    public String getRemark() {
        return remark;
    }

    /**设置备注*/
    public void setRemark(String remark) {
        this.remark = remark == null ? null : remark.trim();
    }

    /**获取块id*/
    public Long getPlAreaBlockId() {
        return plAreaBlockId;
    }

    /**设置块id*/
    public void setPlAreaBlockId(Long plAreaBlockId) {
        this.plAreaBlockId = plAreaBlockId;
    }

    /**获取块名称*/
    public String getPlAreaBlockName() {
        return plAreaBlockName;
    }

    /**设置块名称*/
    public void setPlAreaBlockName(String plAreaBlockName) {
        this.plAreaBlockName = plAreaBlockName == null ? null : plAreaBlockName.trim();
    }

    /**获取营业类型：1:自营，2:非自营*/
    public String getPlBusiType() {
        return plBusiType;
    }

    /**设置营业类型：1:自营，2:非自营*/
    public void setPlBusiType(String plBusiType) {
        this.plBusiType = plBusiType == null ? null : plBusiType.trim();
    }

    /**获取服务点对应二级组织ID*/
    public Long getOrgId() {
        return orgId;
    }

    /**设置服务点对应二级组织ID*/
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    /**获取组织名称*/
    public String getOrgName() {
        return orgName;
    }

    /**设置组织名称*/
    public void setOrgName(String orgName) {
        this.orgName = orgName == null ? null : orgName.trim();
    }
}