package com.zteits.job.domain;

import java.util.Date;

public class OrderPark {
    /**主键*/
    private Long id;

    /**订单id*/
    private String orderId;

    /**停车大类型[字典表:PARK_ORDER_TYPE]:100:短时停车免费,200:临停车,300:授权车免费,400:手动免费开闸 500:白名单车辆免费*/
    private Integer parkOrderType;

    /**停车类型明细[字典表:PARK_DETAIL_TYPE]:201:临停车,301:包年车辆,302:包月车辆,303:包季度车辆,304:半年卡车辆,305:包天车辆,501:白名单车辆*/
    private Integer parkDetailType;

    /**停车状态 10:在场 ,20:离场，30:预订*/
    private Integer parkState;

    /**订单状态[字典表:ORDER_STATE]:-50:已取消,10:待核算,20：待支付,30:支付中,40：支付完成,50:已完成,52:欠费逃逸, 53:已补缴 60:退款中 70:退款成功*/
    private Integer orderState;

    /**终端来源[字典表:TERMINAL_SOURCE]：1:任你听 2：pda 3：微信公共号 4:云平台 5:道闸*/
    private Integer terminalSource;

    /**数据来源类型[字典表:PARK_SOURCE_TYPE]：1-艾润;2-路测;3-捷商;4-南泽;5-共享车位;6-青岛（注:和parking_lot表中source_type保持一致）*/
    private Integer sourceType;

    /**停车场编号*/
    private String plNo;

    /**停车场名称*/
    private String plName;

    /**泊位区间编号*/
    private String berthRangeNo;

    /**泊位区间名称*/
    private String berthRangeName;

    /**泊位编号*/
    private String berthNo;

    /**优惠金额 单位:分*/
    private Long orderDicountFee;

    /**订单实收费用 单位:分*/
    private Long orderActFee;

    /**订单应收金额 单位:分*/
    private Long orderTotalFee;

    /**预付费订单实收费用 单位:分*/
    private Long preActFee;

    /**预付费订单应收金额 单位:分*/
    private Long preTotalFee;

    /**租用超时应收费用 单位:分*/
    private Long overtimeTotalFee;

    /**租用超时实收费用 单位:分*/
    private Long overtimeActFee;

    /**补缴订单实收金额 单位:分*/
    private Long backActFee;

    /**欠费金额(补缴应收金额) 单位:分*/
    private Long arrearageFee;

    /**实际退款成功金额 单位:分*/
    private Long refundActFee;

    /**平台服务费*/
    private Long platformServiceFee;

    /**车牌号*/
    private String carNumber;

    /**车辆类型[字典表:ORDER_CAR_TYPE]:1:大型车；2:小型车*/
    private Integer carType;

    /**车牌颜色[字典表:ORDER_CAR_NUM_COLOR]：0：蓝色 1：黄色 2：白色 3：黑色 4：绿色*/
    private String carNumberColor;

    /**预约进场时间*/
    private Date preParkInTime;

    /**预约出场时间*/
    private Date preParkOutTime;

    /**车辆进场时间*/
    private Date parkInTime;

    /**车辆出场时间*/
    private Date parkOutTime;

    /**停车时长  单位：秒*/
    private Long parkingDuration;

    /**第三方订单id(主键)*/
    private String recordId;

    /**进场设备编号/收费员编号*/
    private String parkInSourceCode;

    /**进场设备编号名称/收费员编号名称*/
    private String parkInSourceName;

    /**出场设备编号/收费员编号*/
    private String parkOutSourceCode;

    /**出场设备编号名称/收费员编号名称*/
    private String parkOutSourceName;

    /**进场时该停车场空闲车位数*/
    private Integer inFreeBerths;

    /**出场时该停车场空闲车位数*/
    private Integer outFreeBerths;

    /**客户类型:1:企业客户2:个人客户*/
    private Integer custType;

    /**客户id*/
    private String custId;

    /**COMMENT '0 未开发票 1 已开发票' */
    private Integer invoiceState;

    /**订单描述*/
    private String remark;

    /**数据状态：1有效，0无效*/
    private Integer dataState;

    /**创建人ID*/
    private String createEmpId;

    /**创建人*/
    private String createEmpName;

    /**创建时间*/
    private Date createDate;

    /**修改人ID*/
    private String modfiyEmpId;

    /**修改人*/
    private String modfiyEmpName;

    /**修改时间*/
    private Date modfiyDate;

    /**平账类型  -1:帐未平, 0:未开始平账 1:账已平*/
    private Integer qeualType;

    /**与支付单差异类型：-1：优惠差异,-2:实收差异，-3：应收差异，-4：优惠、实收、应收都有差异，-5：优惠、实收差异、-6：优惠、应收、差异，-7：实收、应收有差异 0：无差异*/
    private Integer diffType;

    /**差异描述*/
    private String diffRemark;

    /**与支付单比对时间*/
    private Date diffCompareDate;

    /**交易服务费 单位:分*/
    private Long tradeServiceFee;

    /**获取主键*/
    public Long getId() {
        return id;
    }

    /**设置主键*/
    public void setId(Long id) {
        this.id = id;
    }

    /**获取订单id*/
    public String getOrderId() {
        return orderId;
    }

    /**设置订单id*/
    public void setOrderId(String orderId) {
        this.orderId = orderId == null ? null : orderId.trim();
    }

    /**获取停车大类型[字典表:PARK_ORDER_TYPE]:100:短时停车免费,200:临停车,300:授权车免费,400:手动免费开闸 500:白名单车辆免费*/
    public Integer getParkOrderType() {
        return parkOrderType;
    }

    /**设置停车大类型[字典表:PARK_ORDER_TYPE]:100:短时停车免费,200:临停车,300:授权车免费,400:手动免费开闸 500:白名单车辆免费*/
    public void setParkOrderType(Integer parkOrderType) {
        this.parkOrderType = parkOrderType;
    }

    /**获取停车类型明细[字典表:PARK_DETAIL_TYPE]:201:临停车,301:包年车辆,302:包月车辆,303:包季度车辆,304:半年卡车辆,305:包天车辆,501:白名单车辆*/
    public Integer getParkDetailType() {
        return parkDetailType;
    }

    /**设置停车类型明细[字典表:PARK_DETAIL_TYPE]:201:临停车,301:包年车辆,302:包月车辆,303:包季度车辆,304:半年卡车辆,305:包天车辆,501:白名单车辆*/
    public void setParkDetailType(Integer parkDetailType) {
        this.parkDetailType = parkDetailType;
    }

    /**获取停车状态 10:在场 ,20:离场，30:预订*/
    public Integer getParkState() {
        return parkState;
    }

    /**设置停车状态 10:在场 ,20:离场，30:预订*/
    public void setParkState(Integer parkState) {
        this.parkState = parkState;
    }

    /**获取订单状态[字典表:ORDER_STATE]:-50:已取消,10:待核算,20：待支付,30:支付中,40：支付完成,50:已完成,52:欠费逃逸, 53:已补缴 60:退款中 70:退款成功*/
    public Integer getOrderState() {
        return orderState;
    }

    /**设置订单状态[字典表:ORDER_STATE]:-50:已取消,10:待核算,20：待支付,30:支付中,40：支付完成,50:已完成,52:欠费逃逸, 53:已补缴 60:退款中 70:退款成功*/
    public void setOrderState(Integer orderState) {
        this.orderState = orderState;
    }

    /**获取终端来源[字典表:TERMINAL_SOURCE]：1:任你听 2：pda 3：微信公共号 4:云平台 5:道闸*/
    public Integer getTerminalSource() {
        return terminalSource;
    }

    /**设置终端来源[字典表:TERMINAL_SOURCE]：1:任你听 2：pda 3：微信公共号 4:云平台 5:道闸*/
    public void setTerminalSource(Integer terminalSource) {
        this.terminalSource = terminalSource;
    }

    /**获取数据来源类型[字典表:PARK_SOURCE_TYPE]：1-艾润;2-路测;3-捷商;4-南泽;5-共享车位;6-青岛（注:和parking_lot表中source_type保持一致）*/
    public Integer getSourceType() {
        return sourceType;
    }

    /**设置数据来源类型[字典表:PARK_SOURCE_TYPE]：1-艾润;2-路测;3-捷商;4-南泽;5-共享车位;6-青岛（注:和parking_lot表中source_type保持一致）*/
    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    /**获取停车场编号*/
    public String getPlNo() {
        return plNo;
    }

    /**设置停车场编号*/
    public void setPlNo(String plNo) {
        this.plNo = plNo == null ? null : plNo.trim();
    }

    /**获取停车场名称*/
    public String getPlName() {
        return plName;
    }

    /**设置停车场名称*/
    public void setPlName(String plName) {
        this.plName = plName == null ? null : plName.trim();
    }

    /**获取泊位区间编号*/
    public String getBerthRangeNo() {
        return berthRangeNo;
    }

    /**设置泊位区间编号*/
    public void setBerthRangeNo(String berthRangeNo) {
        this.berthRangeNo = berthRangeNo == null ? null : berthRangeNo.trim();
    }

    /**获取泊位区间名称*/
    public String getBerthRangeName() {
        return berthRangeName;
    }

    /**设置泊位区间名称*/
    public void setBerthRangeName(String berthRangeName) {
        this.berthRangeName = berthRangeName == null ? null : berthRangeName.trim();
    }

    /**获取泊位编号*/
    public String getBerthNo() {
        return berthNo;
    }

    /**设置泊位编号*/
    public void setBerthNo(String berthNo) {
        this.berthNo = berthNo == null ? null : berthNo.trim();
    }

    /**获取优惠金额 单位:分*/
    public Long getOrderDicountFee() {
        return orderDicountFee;
    }

    /**设置优惠金额 单位:分*/
    public void setOrderDicountFee(Long orderDicountFee) {
        this.orderDicountFee = orderDicountFee;
    }

    /**获取订单实收费用 单位:分*/
    public Long getOrderActFee() {
        return orderActFee;
    }

    /**设置订单实收费用 单位:分*/
    public void setOrderActFee(Long orderActFee) {
        this.orderActFee = orderActFee;
    }

    /**获取订单应收金额 单位:分*/
    public Long getOrderTotalFee() {
        return orderTotalFee;
    }

    /**设置订单应收金额 单位:分*/
    public void setOrderTotalFee(Long orderTotalFee) {
        this.orderTotalFee = orderTotalFee;
    }

    /**获取预付费订单实收费用 单位:分*/
    public Long getPreActFee() {
        return preActFee;
    }

    /**设置预付费订单实收费用 单位:分*/
    public void setPreActFee(Long preActFee) {
        this.preActFee = preActFee;
    }

    /**获取预付费订单应收金额 单位:分*/
    public Long getPreTotalFee() {
        return preTotalFee;
    }

    /**设置预付费订单应收金额 单位:分*/
    public void setPreTotalFee(Long preTotalFee) {
        this.preTotalFee = preTotalFee;
    }

    /**获取租用超时应收费用 单位:分*/
    public Long getOvertimeTotalFee() {
        return overtimeTotalFee;
    }

    /**设置租用超时应收费用 单位:分*/
    public void setOvertimeTotalFee(Long overtimeTotalFee) {
        this.overtimeTotalFee = overtimeTotalFee;
    }

    /**获取租用超时实收费用 单位:分*/
    public Long getOvertimeActFee() {
        return overtimeActFee;
    }

    /**设置租用超时实收费用 单位:分*/
    public void setOvertimeActFee(Long overtimeActFee) {
        this.overtimeActFee = overtimeActFee;
    }

    /**获取补缴订单实收金额 单位:分*/
    public Long getBackActFee() {
        return backActFee;
    }

    /**设置补缴订单实收金额 单位:分*/
    public void setBackActFee(Long backActFee) {
        this.backActFee = backActFee;
    }

    /**获取欠费金额(补缴应收金额) 单位:分*/
    public Long getArrearageFee() {
        return arrearageFee;
    }

    /**设置欠费金额(补缴应收金额) 单位:分*/
    public void setArrearageFee(Long arrearageFee) {
        this.arrearageFee = arrearageFee;
    }

    /**获取实际退款成功金额 单位:分*/
    public Long getRefundActFee() {
        return refundActFee;
    }

    /**设置实际退款成功金额 单位:分*/
    public void setRefundActFee(Long refundActFee) {
        this.refundActFee = refundActFee;
    }

    /**获取平台服务费*/
    public Long getPlatformServiceFee() {
        return platformServiceFee;
    }

    /**设置平台服务费*/
    public void setPlatformServiceFee(Long platformServiceFee) {
        this.platformServiceFee = platformServiceFee;
    }

    /**获取车牌号*/
    public String getCarNumber() {
        return carNumber;
    }

    /**设置车牌号*/
    public void setCarNumber(String carNumber) {
        this.carNumber = carNumber == null ? null : carNumber.trim();
    }

    /**获取车辆类型[字典表:ORDER_CAR_TYPE]:1:大型车；2:小型车*/
    public Integer getCarType() {
        return carType;
    }

    /**设置车辆类型[字典表:ORDER_CAR_TYPE]:1:大型车；2:小型车*/
    public void setCarType(Integer carType) {
        this.carType = carType;
    }

    /**获取车牌颜色[字典表:ORDER_CAR_NUM_COLOR]：0：蓝色 1：黄色 2：白色 3：黑色 4：绿色*/
    public String getCarNumberColor() {
        return carNumberColor;
    }

    /**设置车牌颜色[字典表:ORDER_CAR_NUM_COLOR]：0：蓝色 1：黄色 2：白色 3：黑色 4：绿色*/
    public void setCarNumberColor(String carNumberColor) {
        this.carNumberColor = carNumberColor == null ? null : carNumberColor.trim();
    }

    /**获取预约进场时间*/
    public Date getPreParkInTime() {
        return preParkInTime;
    }

    /**设置预约进场时间*/
    public void setPreParkInTime(Date preParkInTime) {
        this.preParkInTime = preParkInTime;
    }

    /**获取预约出场时间*/
    public Date getPreParkOutTime() {
        return preParkOutTime;
    }

    /**设置预约出场时间*/
    public void setPreParkOutTime(Date preParkOutTime) {
        this.preParkOutTime = preParkOutTime;
    }

    /**获取车辆进场时间*/
    public Date getParkInTime() {
        return parkInTime;
    }

    /**设置车辆进场时间*/
    public void setParkInTime(Date parkInTime) {
        this.parkInTime = parkInTime;
    }

    /**获取车辆出场时间*/
    public Date getParkOutTime() {
        return parkOutTime;
    }

    /**设置车辆出场时间*/
    public void setParkOutTime(Date parkOutTime) {
        this.parkOutTime = parkOutTime;
    }

    /**获取停车时长  单位：秒*/
    public Long getParkingDuration() {
        return parkingDuration;
    }

    /**设置停车时长  单位：秒*/
    public void setParkingDuration(Long parkingDuration) {
        this.parkingDuration = parkingDuration;
    }

    /**获取第三方订单id(主键)*/
    public String getRecordId() {
        return recordId;
    }

    /**设置第三方订单id(主键)*/
    public void setRecordId(String recordId) {
        this.recordId = recordId == null ? null : recordId.trim();
    }

    /**获取进场设备编号/收费员编号*/
    public String getParkInSourceCode() {
        return parkInSourceCode;
    }

    /**设置进场设备编号/收费员编号*/
    public void setParkInSourceCode(String parkInSourceCode) {
        this.parkInSourceCode = parkInSourceCode == null ? null : parkInSourceCode.trim();
    }

    /**获取进场设备编号名称/收费员编号名称*/
    public String getParkInSourceName() {
        return parkInSourceName;
    }

    /**设置进场设备编号名称/收费员编号名称*/
    public void setParkInSourceName(String parkInSourceName) {
        this.parkInSourceName = parkInSourceName == null ? null : parkInSourceName.trim();
    }

    /**获取出场设备编号/收费员编号*/
    public String getParkOutSourceCode() {
        return parkOutSourceCode;
    }

    /**设置出场设备编号/收费员编号*/
    public void setParkOutSourceCode(String parkOutSourceCode) {
        this.parkOutSourceCode = parkOutSourceCode == null ? null : parkOutSourceCode.trim();
    }

    /**获取出场设备编号名称/收费员编号名称*/
    public String getParkOutSourceName() {
        return parkOutSourceName;
    }

    /**设置出场设备编号名称/收费员编号名称*/
    public void setParkOutSourceName(String parkOutSourceName) {
        this.parkOutSourceName = parkOutSourceName == null ? null : parkOutSourceName.trim();
    }

    /**获取进场时该停车场空闲车位数*/
    public Integer getInFreeBerths() {
        return inFreeBerths;
    }

    /**设置进场时该停车场空闲车位数*/
    public void setInFreeBerths(Integer inFreeBerths) {
        this.inFreeBerths = inFreeBerths;
    }

    /**获取出场时该停车场空闲车位数*/
    public Integer getOutFreeBerths() {
        return outFreeBerths;
    }

    /**设置出场时该停车场空闲车位数*/
    public void setOutFreeBerths(Integer outFreeBerths) {
        this.outFreeBerths = outFreeBerths;
    }

    /**获取客户类型:1:企业客户2:个人客户*/
    public Integer getCustType() {
        return custType;
    }

    /**设置客户类型:1:企业客户2:个人客户*/
    public void setCustType(Integer custType) {
        this.custType = custType;
    }

    /**获取客户id*/
    public String getCustId() {
        return custId;
    }

    /**设置客户id*/
    public void setCustId(String custId) {
        this.custId = custId == null ? null : custId.trim();
    }

    /**获取COMMENT '0 未开发票 1 已开发票' */
    public Integer getInvoiceState() {
        return invoiceState;
    }

    /**设置COMMENT '0 未开发票 1 已开发票' */
    public void setInvoiceState(Integer invoiceState) {
        this.invoiceState = invoiceState;
    }

    /**获取订单描述*/
    public String getRemark() {
        return remark;
    }

    /**设置订单描述*/
    public void setRemark(String remark) {
        this.remark = remark == null ? null : remark.trim();
    }

    /**获取数据状态：1有效，0无效*/
    public Integer getDataState() {
        return dataState;
    }

    /**设置数据状态：1有效，0无效*/
    public void setDataState(Integer dataState) {
        this.dataState = dataState;
    }

    /**获取创建人ID*/
    public String getCreateEmpId() {
        return createEmpId;
    }

    /**设置创建人ID*/
    public void setCreateEmpId(String createEmpId) {
        this.createEmpId = createEmpId == null ? null : createEmpId.trim();
    }

    /**获取创建人*/
    public String getCreateEmpName() {
        return createEmpName;
    }

    /**设置创建人*/
    public void setCreateEmpName(String createEmpName) {
        this.createEmpName = createEmpName == null ? null : createEmpName.trim();
    }

    /**获取创建时间*/
    public Date getCreateDate() {
        return createDate;
    }

    /**设置创建时间*/
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**获取修改人ID*/
    public String getModfiyEmpId() {
        return modfiyEmpId;
    }

    /**设置修改人ID*/
    public void setModfiyEmpId(String modfiyEmpId) {
        this.modfiyEmpId = modfiyEmpId == null ? null : modfiyEmpId.trim();
    }

    /**获取修改人*/
    public String getModfiyEmpName() {
        return modfiyEmpName;
    }

    /**设置修改人*/
    public void setModfiyEmpName(String modfiyEmpName) {
        this.modfiyEmpName = modfiyEmpName == null ? null : modfiyEmpName.trim();
    }

    /**获取修改时间*/
    public Date getModfiyDate() {
        return modfiyDate;
    }

    /**设置修改时间*/
    public void setModfiyDate(Date modfiyDate) {
        this.modfiyDate = modfiyDate;
    }

    /**获取平账类型  -1:帐未平, 0:未开始平账 1:账已平*/
    public Integer getQeualType() {
        return qeualType;
    }

    /**设置平账类型  -1:帐未平, 0:未开始平账 1:账已平*/
    public void setQeualType(Integer qeualType) {
        this.qeualType = qeualType;
    }

    /**获取与支付单差异类型：-1：优惠差异,-2:实收差异，-3：应收差异，-4：优惠、实收、应收都有差异，-5：优惠、实收差异、-6：优惠、应收、差异，-7：实收、应收有差异 0：无差异*/
    public Integer getDiffType() {
        return diffType;
    }

    /**设置与支付单差异类型：-1：优惠差异,-2:实收差异，-3：应收差异，-4：优惠、实收、应收都有差异，-5：优惠、实收差异、-6：优惠、应收、差异，-7：实收、应收有差异 0：无差异*/
    public void setDiffType(Integer diffType) {
        this.diffType = diffType;
    }

    /**获取差异描述*/
    public String getDiffRemark() {
        return diffRemark;
    }

    /**设置差异描述*/
    public void setDiffRemark(String diffRemark) {
        this.diffRemark = diffRemark == null ? null : diffRemark.trim();
    }

    /**获取与支付单比对时间*/
    public Date getDiffCompareDate() {
        return diffCompareDate;
    }

    /**设置与支付单比对时间*/
    public void setDiffCompareDate(Date diffCompareDate) {
        this.diffCompareDate = diffCompareDate;
    }

    /**获取交易服务费 单位:分*/
    public Long getTradeServiceFee() {
        return tradeServiceFee;
    }

    /**设置交易服务费 单位:分*/
    public void setTradeServiceFee(Long tradeServiceFee) {
        this.tradeServiceFee = tradeServiceFee;
    }
}