package com.zteits.job.dao.park.impl;

import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.clouds.common.cache.park.ParkingLotCacheUtil;
import com.google.common.collect.Lists;
import com.zteits.clouds.api.apibase.constants.DataStatusEnum;
import com.zteits.clouds.api.dto.park.dto.ParkingLotDTO;
import com.zteits.job.dao.park.ParkingLotDao;
import com.zteits.job.domain.ParkingLot;
import com.zteits.job.domain.ParkingLotExample;
import com.zteits.job.mapper.ParkingLotMapper;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.List;

@Component
public class ParkingLotDaoImpl implements ParkingLotDao {
    @Autowired
    private ParkingLotMapper parkingLotMapper;
    @Override
    public List<ParkingLot> selectByExample(ParkingLotExample example) {
        return parkingLotMapper.selectByExample(example);
    }

    @Override
    public ParkingLot selectByPlNo(String plNo) {
        ParkingLotExample example = new ParkingLotExample();
        example.createCriteria().andDataStatusEqualTo(DataStatusEnum.DATA_STATUS_VALID.value())
                .andPlNoEqualTo(plNo);
        List<ParkingLot> parkingLots = parkingLotMapper.selectByExample(example);
        if(CollectionUtils.isEmpty(parkingLots)){
            return null;
        }
        return parkingLots.get(0);
    }

    @Override
    public int updateTotalBerths(String plNo, Integer plBerthsNum) {
        ParkingLot record = new ParkingLot();
        record.setPlNo(plNo);
        record.setPlBerthNum(plBerthsNum);
        record.setModifyTime(new Date());

        ParkingLotExample example = new ParkingLotExample();
        example.createCriteria().andPlNoEqualTo(plNo);
        int upNum =  parkingLotMapper.updateByExampleSelective(record,example);
        if(upNum>0){
            //修改缓存
            ParkingLotDTO parkingLotDTO = ParkingLotCacheUtil.getParkLotByPlNo(plNo);
            parkingLotDTO.setPlBerthNum(plBerthsNum);
            parkingLotDTO.setBerthNum(plBerthsNum);
            ParkingLotCacheUtil.setParkLotByPlNo(plNo, parkingLotDTO);
        }
        return upNum;
    }

    @Override
    public ParkingLotDTO queryParkingLotInfoByPlOutNo(String plOutNo) {
        //查询缓存
        ParkingLotDTO dto = ParkingLotCacheUtil.getParkLotByPlOutNo(plOutNo);
        if (dto == null) {
            dto = new ParkingLotDTO();
            //查询数据库
            ParkingLot parkingLot = new ParkingLot();
            List<String> plOutNos = Lists.newArrayList();
            plOutNos.add(plOutNo);
            List<ParkingLot> parkingLots = this.queryParkingLotByPlOutNos(plOutNos);
            parkingLot = org.springframework.util.CollectionUtils.isEmpty(parkingLots) ? null : parkingLots.get(0);

            if (parkingLot != null) {
                BeanUtils.copyProperties(parkingLot, dto);
                //放入缓存
                ParkingLotCacheUtil.setParkLotByPlOutNo(plOutNo, dto);
            }
        }
        return dto;
    }

    private List<ParkingLot> queryParkingLotByPlOutNos(List<String> plOutNos) {
        ParkingLotExample record = new ParkingLotExample();
        record.createCriteria().andPlOutNoIn(plOutNos).andDataStatusEqualTo(DataStatusEnum.DATA_STATUS_VALID.value());
        //查询停车场泊位信息
        List<ParkingLot> parkinglots = parkingLotMapper.selectByExample(record);
        return parkinglots;
    }

}
