package com.zteits.job.dao.park.impl;

import com.zteits.clouds.api.apibase.constants.DataStatusEnum;
import com.zteits.job.dao.park.FreeBerthStatisticRuleDao;
import com.zteits.job.domain.TpPFreeberthStatisticRule;
import com.zteits.job.domain.TpPFreeberthStatisticRuleExample;
import com.zteits.job.mapper.TpPFreeberthStatisticRuleMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
@Component
public class FreeBerthStatisticRuleDaoImpl implements FreeBerthStatisticRuleDao {

	@Autowired
	private TpPFreeberthStatisticRuleMapper statisticRuleMapper;
	@Override
	public List<TpPFreeberthStatisticRule> getFreeStatisticRule(String plNo) {
		TpPFreeberthStatisticRuleExample example = new TpPFreeberthStatisticRuleExample();
		example.createCriteria()
		.andDataStateEqualTo(DataStatusEnum.DATA_STATUS_VALID.value())
		.andPlNoEqualTo(plNo);
		return statisticRuleMapper.selectByExampleWithBLOBs(example );
	}

}
