package com.zteits.job.dao.park.impl;

import com.alibaba.dubbo.common.utils.StringUtils;
import com.zteits.clouds.api.apibase.constants.DataStatusEnum;
import com.zteits.job.constant.EqpConstant;
import com.zteits.job.dao.park.EqpDao;
import com.zteits.job.domain.TpPEqp;
import com.zteits.job.domain.TpPEqpExample;
import com.zteits.job.mapper.TpPEqpMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.List;

@Component
public class EqpDaoImpl implements EqpDao {
    @Autowired
    private TpPEqpMapper tpPEqpMapper;
    @Override
    public Integer batchUpdateEqpStateForFault(String plNo,Integer eqpType) {
        if(StringUtils.isBlank(plNo)){
            return 0;
        }
        TpPEqpExample example = new TpPEqpExample();
        example.createCriteria().andPlNoEqualTo(plNo)
                .andEqpTypeEqualTo(eqpType)
                .andDataStateEqualTo(DataStatusEnum.DATA_STATUS_VALID.value());
        TpPEqp record = new TpPEqp();
        record.setEqpIsOnline(EqpConstant.IS_ONLINE.OFF_LINE);
        record.setModifyTime(new Date());
        return tpPEqpMapper.updateByExampleSelective(record, example);
    }

    @Override
    public int updateEqpStatusByBerthsNo(String eqpIsOnline, List<String> berthNos, String plNo,
                                         Integer eqpType) {
        TpPEqpExample example = new TpPEqpExample();
        TpPEqpExample.Criteria sql = example.createCriteria();
        sql.andBerthNoIn(berthNos)
                .andPlNoEqualTo(plNo)
                .andEqpTypeEqualTo(eqpType);
        sql.andDataStateEqualTo(DataStatusEnum.DATA_STATUS_VALID.value());

        TpPEqp record = new TpPEqp();
        record.setEqpIsOnline(eqpIsOnline);
        record.setHeartbeatTime(new Date());
        record.setModifyTime(new Date());
        return tpPEqpMapper.updateByExampleSelective(record, example);
    }
}
