package com.zteits.job.dao.park.impl;

import com.alibaba.dubbo.common.utils.StringUtils;
import com.zteits.clouds.api.apibase.constants.DataStatusEnum;
import com.zteits.job.constant.BerthConstant;
import com.zteits.job.dao.park.BerthsDao;
import com.zteits.job.domain.TpPBerths;
import com.zteits.job.domain.TpPBerthsExample;
import com.zteits.job.mapper.TpPBerthsMapper;
import com.zteits.job.mapper.smapper.TpPBerthsSMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;

@Component
public class BerthsDaoImpl implements BerthsDao {
    @Autowired
    private TpPBerthsMapper tpPBerthsMapper;
    @Autowired
    private TpPBerthsSMapper tpPBerthsSMapper;
    @Override
    @Deprecated
    public Integer batchUpdateBerthStateForFree(String plNo, String parkAreaCode) {
        if(StringUtils.isBlank(plNo) && StringUtils.isBlank(parkAreaCode)){
            return 0;
        }
        TpPBerthsExample example = new TpPBerthsExample();
        TpPBerthsExample.Criteria sql = example.createCriteria();
        sql.andPlNoEqualTo(plNo);
        if(!StringUtils.isBlank(parkAreaCode)){
            sql.andParkAreaCodeEqualTo(parkAreaCode);
        }
        TpPBerths record = new TpPBerths();
        record.setIsOccupy(BerthConstant.isOccupy.NO_CAR);
        record.setModifyTime(new Date());
        return tpPBerthsMapper.updateByExampleSelective(record , example );
    }

    @Override
    public int updateBerthInfoByBerthNoAndPlNo(TpPBerths tpPBerths) {
        if(StringUtils.isBlank(tpPBerths.getPlNo()) || StringUtils.isBlank(tpPBerths.getBerthNo())){
            return 0;
        }
        TpPBerthsExample example = new TpPBerthsExample();
        example.createCriteria().andBerthNoEqualTo(tpPBerths.getBerthNo())
                .andPlNoEqualTo(tpPBerths.getPlNo())
                .andDataStateEqualTo(DataStatusEnum.DATA_STATUS_VALID.value());
        return tpPBerthsMapper.updateByExampleSelective(tpPBerths, example);
    }

    @Override
    public Long queryFreeBerthNum(String plNo,String where) {
        return tpPBerthsSMapper.queryFreeBerthNum(plNo, where);
    }
}
