package com.zteits.job.dao.park;

import com.zteits.clouds.api.dto.park.dto.ParkingLotDTO;
import com.zteits.job.domain.ParkingLot;
import com.zteits.job.domain.ParkingLotExample;
import org.apache.ibatis.annotations.Param;

import java.util.List;

public interface ParkingLotDao {
    List<ParkingLot> selectByExample(ParkingLotExample example);

    /**
     * 根据停车场编号查询停车场
     * @param plNo
     * @return
     */
    ParkingLot selectByPlNo(String plNo);

    /**
     * 更新总车位数
     * @param plNo
     * @param plBerthsNum
     * @return
     */
    int updateTotalBerths(String plNo, Integer plBerthsNum);

    /**
     * 通过给定的外部停车场编号查询停车场信息
     * @param plOutNo
     * @return
     * 2017年6月8日 zhaowg
     */
    ParkingLotDTO queryParkingLotInfoByPlOutNo(String plOutNo);

}
