package com.zteits.job.config.datasource;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class DataSourceAspect {
    private static final Logger logger = LoggerFactory.getLogger(DataSourceAspect.class);
    /**
     * 使用空方法定义切点表达式
     */
    @Pointcut("execution(* com.zteits.job.dao.**.**.*(..))")
    public void declareJointPointExpression() {
    }

    @Before("declareJointPointExpression()")
    public void setDataSourceKey(JoinPoint point){
        //根据包名，判断切换的数据源
        String className = point.getTarget().getClass().getName();
        if(className.startsWith("com.zteits.job.dao.park")) {
            logger.debug("切换到数据源:"+DatabaseType.park);
            DatabaseContextHolder.setDatabaseType(DatabaseType.park);
        } else if(className.startsWith("com.zteits.job.dao.order")) {
            logger.debug("切换到数据源:"+DatabaseType.order);
            DatabaseContextHolder.setDatabaseType(DatabaseType.order);
        } else if(className.startsWith("com.zteits.job.dao.sys")){
            logger.debug("切换到数据源:"+DatabaseType.sys);
            DatabaseContextHolder.setDatabaseType(DatabaseType.sys);
        }
    }
}