package com.zteits.job;

import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceTransactionManagerAutoConfiguration;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.ImportResource;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;

@EnableScheduling
@EnableAsync
@MapperScan({"com.zteits.job.mapper"})
@SpringBootApplication(scanBasePackages = {"com.zteits.job","com.clouds.common.redis"}, exclude = {DataSourceAutoConfiguration.class})
public class JobApplication {


    public static void main(String[] args) {

        SpringApplication.run(JobApplication.class, args);
    }
}
