/*
 * Decompiled with CFR 0.152.
 */
package com.zteits.nbiot.decoder;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.zteits.nbiot.decoder.CRC16Util;
import com.zteits.nbiot.decoder.Utilty;
import java.util.Date;

public class ZteitsCmdProcess {
    private String msgType = "cloudRsp";
    private String serviceId = "VehicleDetectorInfo";
    private String cmd = "SET_DEVICE_LEVEL";
    private int hasMore = 0;
    private int errcode = 0;
    private int mid = 0;
    private byte[] requests;
    private JsonNode paras;

    public ZteitsCmdProcess() {
    }

    public ZteitsCmdProcess(ObjectNode input) {
        try {
            this.msgType = input.get("msgType").asText();
            if (this.msgType.equals("cloudRsp")) {
                this.requests = input.get("request").binaryValue();
                this.errcode = input.get("errcode").asInt();
                this.hasMore = input.get("hasMore").asInt();
            }
        }
        catch (Exception e) {
            this.errcode = 1;
            e.printStackTrace();
        }
    }

    public byte[] toByte() {
        try {
            if (this.msgType.equals("cloudRsp")) {
                byte[] ack = new byte[28];
                ack[0] = 119;
                ack[1] = 0;
                if (this.errcode == 0) {
                    ack[2] = 112;
                } else if (this.errcode == 1) {
                    ack[2] = 48;
                }
                ack[3] = this.requests[18];
                ack[4] = this.requests[19];
                ack[5] = this.requests[22];
                ack[6] = this.requests[23];
                ack[7] = this.requests[24];
                ack[8] = this.requests[25];
                ack[9] = 0;
                ack[10] = 0;
                ack[11] = 0;
                ack[12] = 0;
                ack[13] = 0;
                ack[14] = 0;
                Long time = new Date().getTime() / 1000L;
                byte[] timeByte = Utilty.int2Bytes(time.intValue(), 4);
                ack[15] = timeByte[0];
                ack[16] = timeByte[1];
                ack[17] = timeByte[2];
                ack[18] = timeByte[3];
                ack[19] = 0;
                ack[20] = 0;
                ack[21] = 0;
                ack[22] = 0;
                ack[23] = 0;
                ack[24] = 0;
                ack[25] = 0;
                return CRC16Util.appendCrc16(ack);
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

