/*
 * Decompiled with CFR 0.152.
 */
package com.fh.party;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ReportProcess {
    private byte cmdid = 1;
    private int pid;
    private int tid;
    private int eventcnt;
    private int verno;
    private byte eventstate;
    private String factoryCode = "fh";
    private String model = "fh";
    private int reportType;
    private int reportTime;
    private int state;
    private int packCount;
    private int voltage;
    private int magId;
    private int rssi;
    private int version;

    public ReportProcess(byte[] binaryData) throws ParseException {
        this.pid = binaryData[1];
        this.tid = binaryData[2];
        this.eventcnt = binaryData[3];
        this.verno = binaryData[4];
        this.eventstate = binaryData[5];
        if ((this.eventstate & 1) == 1) {
            this.reportType = 33;
        }
        if ((this.eventstate & 2) == 2) {
            this.reportType = 32;
        }
        if ((this.eventstate & 3) == 3) {
            this.reportType = 32;
        }
        this.magId = this.tid;
        this.reportTime = ReportProcess.calLastedTime();
        this.state = (this.eventstate & 0x20) == 32 ? 1 : 0;
    }

    public ObjectNode toJsonNode() {
        try {
            ObjectMapper mapper = new ObjectMapper();
            ObjectNode root = mapper.createObjectNode();
            root.put("factoryCode", this.factoryCode);
            root.put("model", this.model);
            root.put("reportType", this.reportType);
            root.put("reportTime", this.reportTime);
            root.put("state", this.state);
            root.put("magId", this.magId);
            return root;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int calLastedTime() throws ParseException {
        long a = new Date().getTime();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date startDate = dateFormat.parse("1970-01-01");
        long b = startDate.getTime();
        return (int)((a - b) / 1000L);
    }

    public static byte[] byteToArray(byte b) {
        byte[] array = new byte[8];
        for (int i = 7; i >= 0; --i) {
            array[i] = (byte)(b & 1);
            b = (byte)(b >> 1);
        }
        return array;
    }

    public static String byteToBit(byte b) {
        return "" + (byte)(b >> 7 & 1) + (byte)(b >> 6 & 1) + (byte)(b >> 5 & 1) + (byte)(b >> 4 & 1) + (byte)(b >> 3 & 1) + (byte)(b >> 2 & 1) + (byte)(b >> 1 & 1) + (byte)(b >> 0 & 1);
    }

    public static void main(String[] args) throws ParseException {
    }
}

