/*
 *
 *  Copyright 2015 the original author or authors.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 *
 */
package com.zteits.irain.portal.swagger;

import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.get;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

import java.io.BufferedWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;

import org.apache.commons.lang3.StringUtils;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.MediaType;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.MvcResult;

import com.zteits.irain.portal.ParkPortalApplication;
import com.zteits.tool.swagger.config.Swagger2AutoConfiguration;

import springfox.documentation.staticdocs.Swagger2MarkupResultHandler;


/**
 * 通过Swagger生成asciidoc文档<br>
 * 两种方式：<br>
 * 1.先生成swagger.json，然后将swagger.json生成asciidoc文档。<br>
 * 2.直接生成asciidoc文档。
 * 目前使用第二种
 * 
 * Copyright: Copyright (c) 2017  zteits
 * 
 * @ClassName: Swagger2MarkupTest.java
 * @Description: 
 * @version: v1.0.0
 * @author: zhaowg
 * @date: 2017年4月25日   下午2:18:51 
 * Modification History:
 * Date             Author          Version            Description
 *---------------------------------------------------------*
 * 2017年4月25日      zhaowg           v1.0.0               创建
 */
@WebAppConfiguration
@RunWith(SpringJUnit4ClassRunner.class)
@SpringBootTest(classes = {ParkPortalApplication.class, Swagger2AutoConfiguration.class})
@AutoConfigureMockMvc
public class Swagger2MarkupTest {

    private static final Logger log = LoggerFactory.getLogger(Swagger2MarkupTest.class);

    @Autowired
    private MockMvc mockMvc;
    /**
     * 生成swagger.json文件,然后使用pom.xml中的convertSwagger2markup任务，生成asciidoc文档。<br>
     * 缺点：
     * 如果没有swagger.json文件，mvn执行打包任务时报错。<br>
     * 使用mvn打包时一般忽略test，导致报错。
     * @throws Exception
     */
    //@Test
    public void createSpringfoxSwaggerJson() throws Exception {
    	log.debug("生成swagger.json文件");
        String outputDir = System.getProperty("io.springfox.staticdocs.outputDir");
        if(StringUtils.isBlank(outputDir)){
        	outputDir = "target/swagger";
        }
        MvcResult mvcResult = this.mockMvc.perform(get("/v2/api-docs?group=zteitsApi")
                .accept(MediaType.APPLICATION_JSON))
                .andExpect(status().isOk())
                .andReturn();

        MockHttpServletResponse response = mvcResult.getResponse();
        String swaggerJson = response.getContentAsString();
        Files.createDirectories(Paths.get(outputDir));
        try (BufferedWriter writer = Files.newBufferedWriter(Paths.get(outputDir, "swagger.json"), StandardCharsets.UTF_8)){
            writer.write(swaggerJson);
        }
    }
    /**
     * 直接生成AsciiDoc文件，需要将pom.xml文档中的convertSwagger2markup注释掉。
     * @throws Exception
     */
    @Test
    public void convertSwaggerToAsciiDoc() throws Exception {
        this.mockMvc.perform(get("/v2/api-docs?group=zteitsApi")
                .accept(MediaType.APPLICATION_JSON))
                .andDo(Swagger2MarkupResultHandler
                    .outputDirectory("target/asciidoc/generated").build())
                .andExpect(status().isOk());
    }
}
