package com.zteits.irain.portal.web.run;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.alibaba.fastjson.JSONObject;

import com.clouds.common.log.LogSelf;
import com.clouds.common.utils.LogSelfFactory;
import com.clouds.common.utils.ResultUtils;
import com.clouds.common.web.vo.BizResultVO;
import com.zteits.clouds.api.apibase.bean.BizResult;
import com.zteits.clouds.api.apibase.constants.ErrorType;
import com.zteits.clouds.api.apibase.exception.BizException;
import com.zteits.clouds.api.dto.park.dto.TabParkinglotDTO;
import com.zteits.clouds.api.dto.run.dto.ParkFreeQueryDTO;
import com.zteits.clouds.api.dto.run.dto.ParkFreeResDTO;
import com.zteits.clouds.api.dto.run.dto.ParkSpaceStateDTO;
import com.zteits.clouds.api.dto.run.param.FreeNumParklogByParkNosQueryRequest;
import com.zteits.clouds.api.dto.run.param.FreePakingSpaceQueryRequest;
import com.zteits.clouds.api.service.run.IParkService;
import com.zteits.irain.portal.service.interfaces.induction.InductionService;
import com.zteits.irain.portal.service.interfaces.induction.param.DoLevelTwoAndThreeInductionReleaseBatchRequest;
import com.zteits.irain.portal.service.interfaces.induction.param.InductionRelease;
import com.zteits.irain.portal.service.interfaces.parklotidleberths.ParkLotIdleBerthsService;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * Copyright: Copyright (c) 2017  zteits
 *
 * @ClassName: com.zteits.irain.portal.web.run.controller
 * @Description:
 * @version: v1.0.0
 * @author: atao
 * @date: 2017/5/25   下午12:27
 * Modification History:
 * Date         Author          Version      Description
 * ---------------------------------------------------------*
 * 2017/5/25      atao          v1.0.0          创建
 */
@Api("获取空余车位信息")
@RestController
@RequestMapping("/runParklot")
public class RunParklotController {

    LogSelf log = LogSelfFactory.getLogSelf(RunParklotController.class);


    @Autowired
    private IParkService parkService;

    @Autowired
    private ParkLotIdleBerthsService parkLotIdleBerthsService;

    @Autowired
    private InductionService inductionService;

    /**
     * 根据停车场编号查询空余车位信息
     *
     * @return
     */
    @PostMapping("/queryParklotFreeInfo")
    public BizResultVO<ParkFreeResDTO> queryParklotFreeNumByParkNos(
        @RequestBody FreeNumParklogByParkNosQueryRequest request) {
        BizResultVO<ParkFreeResDTO> bizResultVO = new BizResultVO<>();
        ParkFreeResDTO parkFreeResDTO = new ParkFreeResDTO();
        List<ParkSpaceStateDTO> parkDatas = new ArrayList<>();
        List<ParkFreeQueryDTO> queryDTOS = request.getQueryDTOList();

        List<String> dubboNos = new ArrayList<>();
        List<String> redisNos = new ArrayList<>();

        for (ParkFreeQueryDTO dto : queryDTOS) {
            if ("1".equals(dto.getType())) {
                //1是路侧停车场
                dubboNos.add(dto.getParkNo());
            } else {
                //2是室内停车场
                redisNos.add(dto.getParkNo());
            }
        }

        //调用室内
        if(!CollectionUtils.isEmpty(redisNos)){
        	Map<String, TabParkinglotDTO> redisData = parkLotIdleBerthsService.getIdleBerthFromRedisByParkNos(redisNos);
        	ParkSpaceStateDTO parkSpaceStateDTO = null;
        	for (String key : redisData.keySet()) {
        		TabParkinglotDTO tabParkinglotDTO = redisData.get(key);
        		if (null != tabParkinglotDTO) {
        			parkSpaceStateDTO = new ParkSpaceStateDTO();
        			parkSpaceStateDTO.setParkNo(key);
        			parkSpaceStateDTO.setParkName(tabParkinglotDTO.getPklName());
        			parkSpaceStateDTO.setFreeNum(String
        					.valueOf(tabParkinglotDTO.getIdleberths() == null ? 0 : tabParkinglotDTO.getIdleberths() + 10000)
        					.substring(1));
        			parkDatas.add(parkSpaceStateDTO);
        		}
        		
        	}
        }
        
        //调用路测
        if(!CollectionUtils.isEmpty(dubboNos)){
        	FreePakingSpaceQueryRequest request1 = new FreePakingSpaceQueryRequest();

            request1.setSysCode(request.getSysCode());
            request1.setParkNos(dubboNos);

            BizResult<List<ParkSpaceStateDTO>> dubboData = parkService.queryParkSpaceFreeNum(request1);

            if (!ResultUtils.isSuccess(dubboData)) {
                throw new BizException(dubboData.getErrCode());
            }

            List<ParkSpaceStateDTO> parkSpaceStateDTOS = dubboData.getData();

            if (!CollectionUtils.isEmpty(parkSpaceStateDTOS)) {
                parkDatas.addAll(parkSpaceStateDTOS);
            }
        }
        parkFreeResDTO.setParkDatas(parkDatas);
        parkFreeResDTO.setTotal(getTotlaFreeNum(parkDatas));
        bizResultVO.setCode(ErrorType.BIZ_SUCCESS.getCode());
        bizResultVO.setMsg(ErrorType.BIZ_SUCCESS.getMsg());
        bizResultVO.setData(parkFreeResDTO);

        try {
            //传固定值
            DoLevelTwoAndThreeInductionReleaseBatchRequest releaseBatchRequest
                = new DoLevelTwoAndThreeInductionReleaseBatchRequest();
            List<InductionRelease> list = new ArrayList<>();
            InductionRelease inductionRelease = null;
            for (ParkSpaceStateDTO dto : parkDatas) {
                inductionRelease = new InductionRelease();
                inductionRelease.setBerth_left(dto.getFreeNum());
                inductionRelease.setOwner_code("1001");
                inductionRelease.setParking_code(dto.getParkNo());
                inductionRelease.setRange_code(dto.getParkNo());
                list.add(inductionRelease);
            }
            releaseBatchRequest.setJsonStr(list);

            BizResultVO<?> bizResultVO1 = inductionService.doLevelTwoAndThreeInductionReleaseBatch(releaseBatchRequest);
            log.info("二三级诱导批量发布返回数据为:" + JSONObject.toJSONString(bizResultVO1));
        } catch (Exception e) {
            e.printStackTrace();
            log.error("二三级诱导发布捕获异常", e);
        }

        return bizResultVO;
    }

    private String getTotlaFreeNum(List<ParkSpaceStateDTO> list) {
        int i = 0;
        for (ParkSpaceStateDTO dto : list) {
            i += Integer.valueOf(dto.getFreeNum());
        }
        return String.valueOf(10000 + i).substring(1);
    }

    public static void main(String[] args) {
        String i = "0111";
        System.out.println(Integer.valueOf(i));
    }

}
