/**
 * 
 */
package com.zteits.irain.portal.web.qingdao;


import java.math.BigDecimal;
import java.util.Date;

import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.clouds.common.utils.DateUtil;
import com.clouds.common.utils.ExceptionUtil;
import com.clouds.common.web.BizController;
import com.zteits.clouds.api.apibase.bean.BaseInfo;
import com.zteits.clouds.api.apibase.constants.ErrorType;
import com.zteits.clouds.api.apibase.exception.BizException;
import com.zteits.clouds.api.dto.park.param.InParkingRequest;
import com.zteits.clouds.api.dto.park.param.InterfaceLogSaveRequest;
import com.zteits.clouds.api.dto.park.param.OutParkingRequest;
import com.zteits.clouds.api.service.park.InterfaceLogService;
import com.zteits.irain.portal.constant.ParkConstant;
import com.zteits.irain.portal.constant.ParkConstant.InterfaceLog;
import com.zteits.irain.portal.service.interfaces.inoutparklot.InOutParkLotReportService;
import com.zteits.irain.portal.service.interfaces.inoutparklot.param.RecordInParkLotRequest;
import com.zteits.irain.portal.service.interfaces.inoutparklot.param.RecordOutParkLotRequest;
import com.zteits.irain.portal.vo.qingdao.RespondMessage;
import com.zteits.irain.portal.vo.qingdao.inoutpark.QDInOutParkReq;

import io.swagger.annotations.Api;

/**
 * 青岛进出场上报
 * 
 * Copyright: Copyright (c) 2017  zteits
 * 
 * @ClassName: QDInOutController.java
 * @Description: 
 * @version: v1.0.0
 * @author: zhaowg
 * @date: 2017年6月22日   下午2:29:28 
 * Modification History: 
 * Date             Author          Version            Description
 *---------------------------------------------------------*
 * 2017年6月22日      hxz              v1.0.0               创建
 */
@Api("青岛  进车上报、出车上报")
@RestController
@RequestMapping("/qd")
public class QDInOutController extends BizController {
	private static final Logger logger = LoggerFactory.getLogger(QDInOutController.class);

	@Value("${project.syscode}")
	private String sysCode;
	@Autowired
	private InterfaceLogService interfaceLogService;
	@Autowired
	private InOutParkLotReportService inOutParkLotReportService;
	
	@PostMapping("/inout")
	public RespondMessage HandleReceivedData(@RequestBody String jsonOrder) {
		BaseInfo baseInfo = new BaseInfo();
		String requestId = baseInfo.getRequestId();
		logger.info("[RequestId:" + requestId + "]QD 进车上报内容:" + jsonOrder);
		//记录日志
		InterfaceLogSaveRequest logSaveRequest = new InterfaceLogSaveRequest(sysCode, 
				baseInfo,null, jsonOrder,InterfaceLog.FromType.QINGDAO);
		logSaveRequest.setEncryptParam(jsonOrder);
		logSaveRequest.setSyncStatus(1);
		QDInOutParkReq qdinoutParkReq = null;
		RespondMessage respondMessage = new RespondMessage();
		try {
			if(StringUtils.isBlank(jsonOrder)){
				throw new BizException(ErrorType.PARAMM_NULL, "请求报文");
			}
			//转换对象
			qdinoutParkReq = JSON.parseObject(jsonOrder, QDInOutParkReq.class);	
			//记录日志主键
			Long outId = null;
			
			if (qdinoutParkReq.getInOut().equals(ParkConstant.QDInOutParkLot.InOutType.INPARKLOT)) {
				//进场
				logSaveRequest.setType(ParkConstant.InterfaceLog.Type.TYPE_IN_PARKING);
				outId = inParkLotSave(qdinoutParkReq,logSaveRequest);
			}else if(qdinoutParkReq.getInOut().equals(ParkConstant.QDInOutParkLot.InOutType.OUTPARKLOT_ESCAPE) 
					|| qdinoutParkReq.getInOut().equals(ParkConstant.QDInOutParkLot.InOutType.OUTPARKLOT_NOMAL)){
				//出场
				logSaveRequest.setType(ParkConstant.InterfaceLog.Type.TYPE_OUT_PARKING);
				outId = outParkLotSave(qdinoutParkReq,logSaveRequest);
			}
			
			//记录外部主键
			logSaveRequest.setOutId(outId);
			logSaveRequest.setStatus(InterfaceLog.Status.SUCCESS);
			
			respondMessage.setErrorCode("null");
			respondMessage.setStatus("success");
			
		} catch (Exception e) {
			e.printStackTrace();
			logSaveRequest.setMessage(ExceptionUtil.getTrace(e));
			logSaveRequest.setStatus(InterfaceLog.Status.FAIL);
			
			respondMessage.setStatus("fail");
			respondMessage.setErrorCode("100006");
		} finally {
			logSaveRequest.setResponseBody(JSONObject.toJSONString(respondMessage));
			logSaveRequest.setResponseTime(new Date());
			//保存日志
			try{
				interfaceLogService.SaveInterfaceLog(logSaveRequest);
			}catch(Exception e){
				e.printStackTrace();
			}
		}
		return respondMessage;
	}
	
	/**
	 * 出场操作记录
	 * @param qdinoutParkReq
	 * @return
	 * @throws Exception
	 * 2017年6月22日 zhaowg
	 */
	private Long outParkLotSave(QDInOutParkReq qdinoutParkReq,InterfaceLogSaveRequest logSaveRequest) throws Exception {
		// Initialize objects.
		RecordOutParkLotRequest request = new RecordOutParkLotRequest();
		request.setFromType(InterfaceLog.FromType.QINGDAO);
		request.setSourceType(InterfaceLog.SourceType.GEO);
		request.setSysCode(sysCode);
		// Object used for accepting data from parking lot. 
		OutParkingRequest acceptObject = new OutParkingRequest();
		
		// Set Object info.
		acceptObject.setSysCode(sysCode);
		acceptObject.setParkCode(qdinoutParkReq.getParkinglotNo());
		acceptObject.setRecordId(qdinoutParkReq.getOrderNo());
		acceptObject.setVplNumber(qdinoutParkReq.getVehicleNo());
		acceptObject.setPayType(qdinoutParkReq.getPayType()==null?"":qdinoutParkReq.getPayType().toString());
		if (null != qdinoutParkReq.getOutTime()) {
			acceptObject.setOutTime(DateUtil.to_date(qdinoutParkReq.getOutTime(), DateUtil.DATETIME_FORMAT));
		}
		if (qdinoutParkReq.getInOut().equals(ParkConstant.QDInOutParkLot.InOutType.OUTPARKLOT_NOMAL)) {
			// 订单记录状态 已支付，正常离开
			acceptObject.setOrderStatus(5); //暂时默认处理，需与青岛共同商定状态规则，未考虑预订
			if (0 < qdinoutParkReq.getRecAmount()) {
				logger.info("need to pay: " + qdinoutParkReq.getRecAmount().toString());
				acceptObject.setCalcCharge(BigDecimal.valueOf(qdinoutParkReq.getRecAmount()));
			}
			if (0 < qdinoutParkReq.getAmount()) {
				logger.info("Paid: " +  qdinoutParkReq.getAmount());
				acceptObject.setParkingCharge(BigDecimal.valueOf(qdinoutParkReq.getAmount()));
			}
			acceptObject.setFromType(InterfaceLog.FromType.QINGDAO);
		}
		
		if (qdinoutParkReq.getInOut().equals(ParkConstant.QDInOutParkLot.InOutType.OUTPARKLOT_ESCAPE)) {
			// 订单记录状态 逃逸
			acceptObject.setOrderStatus(6); //暂时默认处理，需与青岛共同商定状态规则，未考虑预订
			if (0 < qdinoutParkReq.getRecAmount()) {
				logger.info("need to pay: " + qdinoutParkReq.getRecAmount().toString());
				acceptObject.setCalcCharge(BigDecimal.valueOf(qdinoutParkReq.getRecAmount()));
			}
		}
		
		acceptObject.setParkingPlaceCode(qdinoutParkReq.getParkingNo());
		acceptObject.setParkingPlaceStatus(0); //暂时默认处理，需与青岛共同商定状态规则，未考虑预订
		acceptObject.setFreeBerths(qdinoutParkReq.getFree());
		request.setOutParkLotReq(acceptObject);
		//保存转化之后的请求数据
		logSaveRequest.setRequestConversionBody(JSON.toJSONString(acceptObject));
		
		// 调用出车服务
		Long outId = inOutParkLotReportService.OutParkLotRecord(request);
		return outId;
	}
	
	/**
	 * 进场操作记录
	 * @param qdinoutParkReq
	 * @return
	 * @throws Exception
	 * 2017年6月22日 zhaowg
	 */
	private Long inParkLotSave(QDInOutParkReq qdinoutParkReq,InterfaceLogSaveRequest logSaveRequest) throws Exception {
		RecordInParkLotRequest request = new RecordInParkLotRequest();
		request.setFromType(InterfaceLog.FromType.QINGDAO);
		request.setSourceType(InterfaceLog.SourceType.GEO);
		request.setSysCode(sysCode);
		// Object used for accepting data from parking lot. 
		InParkingRequest acceptObject = new InParkingRequest();
		
		// Set Object info.
		acceptObject.setSysCode(sysCode);
		acceptObject.setParkCode(qdinoutParkReq.getParkinglotNo());
		acceptObject.setRecordId(qdinoutParkReq.getOrderNo());
		acceptObject.setVplNumber(qdinoutParkReq.getVehicleNo());
		if (null != qdinoutParkReq.getInTime()) {
			acceptObject.setInTime(DateUtil.to_date(qdinoutParkReq.getInTime(),DateUtil.DATETIME_FORMAT));
		}
		logger.info("in time:" + acceptObject.getInTime());
		acceptObject.setOrderStatus(4); //暂时默认处理，需与青岛共同商定状态规则，未考虑预订
		acceptObject.setParkingPlaceCode(qdinoutParkReq.getParkingNo());
		acceptObject.setParkingPlaceStatus(1); //暂时默认处理，需与青岛共同商定状态规则，未考虑预订
		acceptObject.setFreeBerths(qdinoutParkReq.getFree());
		acceptObject.setFromType(InterfaceLog.FromType.QINGDAO);
		request.setInParkLotReq(acceptObject);
		//保存转化之后的请求数据
		logSaveRequest.setRequestConversionBody(JSON.toJSONString(acceptObject));
		//调用进车服务
		Long outId = inOutParkLotReportService.InParkLotRecord(request);
		return outId;
	}
}
