package com.zteits.irain.portal.web.qingdao;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSON;
import com.clouds.common.cache.park.EqpAndPosStatusSyncCacheUtil;
import com.clouds.common.web.vo.BizResultVO;
import com.zteits.irain.portal.vo.qingdao.eqppossync.GeoTotalNumSyncReq;
import com.zteits.irain.portal.vo.qingdao.eqppossync.PosTotalNumSyncReq;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * 设备和POST状态同步
 * 
 * Copyright: Copyright (c) 2017  zteits
 * 
 * @ClassName: EqpAndPosStatusSyncController.java
 * @Description: 
 * @version: v1.0.0
 * @author: zhaowg
 * @date: 2017年7月26日   下午4:19:10 
 * Modification History: 
 * Date             Author          Version            Description
 *---------------------------------------------------------*
 * 2017年7月26日      zhaowg              v1.0.0               创建
 */
@Api(description="设备和POS机状态同步")
@RestController
@RequestMapping("eqpAndPosStatusSync")
public class EqpAndPosStatusSyncController {
	
	private static final Logger logger = LoggerFactory.getLogger(EqpAndPosStatusSyncController.class);
	
	@ApiOperation("POS机总数统计同步接口")
	@PostMapping("syncPosTotalNum")
	public BizResultVO<Boolean>  syncPosTotalNum(@RequestBody PosTotalNumSyncReq totalNumSyncReq){
		logger.info("POS机总数统计同步接口 请求参数："+JSON.toJSONString(totalNumSyncReq));
		EqpAndPosStatusSyncCacheUtil.setPosTotalNum(totalNumSyncReq.getNuminuse(), totalNumSyncReq.getNumunused());
		return new BizResultVO<Boolean>().setData(true);
	}
	
	@ApiOperation("地磁总数统计同步接口")
	@PostMapping("syncGeoTotalNum")
	public BizResultVO<Boolean>  syncGeoTotalNum(@RequestBody GeoTotalNumSyncReq totalNumSyncReq){
		logger.info("地磁总数统计同步接口 请求参数："+JSON.toJSONString(totalNumSyncReq));
		EqpAndPosStatusSyncCacheUtil.setGeoTotalNum(totalNumSyncReq.getNumonline(), totalNumSyncReq.getNumoffline());
		return new BizResultVO<Boolean>().setData(true);
	}
	
}
