/**
 * 
 */
package com.zteits.irain.portal.web.parkinglotcloudplatform.datastatistic;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.clouds.common.utils.AmountUtils;
import com.clouds.common.utils.DateUtil;
import com.clouds.common.utils.ExceptionUtil;
import com.clouds.common.utils.excle.ExcelUtil;
import com.clouds.common.utils.excle.ExcleFillDateManager;
import com.clouds.common.utils.excle.Layouter;
import com.clouds.common.web.BizController;
import com.clouds.common.web.vo.BizResultVO;
import com.zteits.clouds.api.apibase.bean.BaseInfo;
import com.zteits.clouds.api.apibase.bean.BizResult;
import com.zteits.clouds.api.apibase.bean.PageBean;
import com.zteits.clouds.api.apibase.constants.ErrorType;
import com.zteits.clouds.api.apibase.exception.BizException;
import com.zteits.clouds.api.dto.clouds.dto.OrderTransDTO;
import com.zteits.clouds.api.dto.clouds.dto.OrderTransDetailDTO;
import com.zteits.clouds.api.dto.clouds.dto.OrderTransFoldLineDTO;
import com.zteits.clouds.api.dto.clouds.param.OrderTransactionQueryRequest;
import com.zteits.clouds.api.dto.park.param.InterfaceLogSaveRequest;
import com.zteits.clouds.api.dto.pay.TdBOrderDTO;
import com.zteits.clouds.api.dto.pay.param.TdBOrderRequest;
import com.zteits.clouds.api.service.clouds.OrderTransactionService;
import com.zteits.clouds.api.service.park.InterfaceLogService;
import com.zteits.clouds.api.service.pay.TdBOrderService;
import com.zteits.irain.portal.constant.ParkConstant.InterfaceLog;
//import com.zteits.irain.portal.vo.parkinglotcloudplatform.datastatistic.OrderTransactionDetails;
//import com.zteits.irain.portal.vo.parkinglotcloudplatform.datastatistic.TransactionRecord;
//import com.zteits.irain.portal.vo.parkinglotcloudplatform.datastatistic.TransactionRequestObject;
//import com.zteits.irain.portal.vo.parkinglotcloudplatform.datastatistic.TransactionStatisticSummary;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * Unification object used for responding request from web front .
 * @author hxz
 *
 */
class TransactionStatisticRespondObject <T, D> {
	//private List<TransactionRecord> transactionRecordList; 
	//private TransactionStatisticSummary tranStcSummary;
	private List<T> transactionRecordList;
	private D tranStcSummary;
	
	/**
	 * @return the transactionRecordList
	 */
	public List<T> getTransactionRecordList() {
		return transactionRecordList;
	}
	/**
	 * @param transactionRecordList the transactionRecordList to set
	 */
	public void setTransactionRecordList(List<T> transactionRecordList) {
		this.transactionRecordList = transactionRecordList;
	}
	/**
	 * @return the tranStcSummary
	 */
	public D getTranStcSummary() {
		return tranStcSummary;
	}
	/**
	 * @param tranStcSummary the tranStcSummary to set
	 */
	public void setTranStcSummary(D tranStcSummary) {
		this.tranStcSummary = tranStcSummary;
	}
}

/**
 * @author hxz
 *
 */
@Api("停车场云平台 数据统计 交易管理")
@RestController
@RequestMapping("/transaction")
public class TransactionStatisticController extends BizController {
	private static final Logger logger = LoggerFactory.getLogger(TransactionStatisticController.class);

	@Value("${project.syscode}")
	private String sysCode;
	
	@Autowired
	private InterfaceLogService interfaceLogService;
	
	@Autowired
	private OrderTransactionService orderTransactionService;
	
	@Autowired
	private TdBOrderService tdborderservice;
	
	/**
	 * 
	 * @param ID, 订单ID
	 * @return
	 * @throws Exception 
	 */
	@ApiOperation("获取交易详情")
	@PostMapping("getordertrancdetails")
	public Object GetOrderTrancDetails (@RequestBody TdBOrderRequest request) throws Exception {
		logger.info("[{}]获取交易详情请求参数",request.getOrderId());
		BizResult<TdBOrderDTO> bizResult = tdborderservice.queryOrderByOrderId(request);
		logger.info("[{}]获取交易详情结果",bizResult);
		return new BizResultVO<>(bizResult);
	}

	@ApiOperation("停车收入统计-->收入汇总查询")
	@PostMapping("/gettransactionstatisticsummary")
	public Object GetTransactionStatisticSummary (@RequestBody OrderTransactionQueryRequest requestObject) throws Exception{
		logger.info("[{}]--begin调用后场,停车收入统计-->收入汇总查询,入参={}",requestObject.getBaseRequest().getRequestId(),JSONObject.toJSON(requestObject));
		BizResult<OrderTransDTO> respondObject = orderTransactionService.queryOrderTransaction(requestObject);
		logger.info("[{}]--end调用后场,停车收入统计-->收入汇总查询.");
		return new BizResultVO<>(respondObject);
	}
	
	@ApiOperation("停车收入统计-->明细数据")
	@PostMapping("/gettransactionstatisticlist")
	public Object GetTransactionStatisticList (@RequestBody OrderTransactionQueryRequest requestObject) throws Exception{
		
		BizResult<PageBean<OrderTransDetailDTO>> respondObject = orderTransactionService.queryOrderTransactionDetail(requestObject);
		
		return returnJqGridData(respondObject, OrderTransDetailDTO.class);
	}
	
	@ApiOperation("停车收入统计-->折线图")
	@PostMapping("/getOrderTransactionFoldLine")
    public BizResultVO<List<OrderTransFoldLineDTO>> getOrderTransactionFoldLine(@RequestBody OrderTransactionQueryRequest requestObject) throws Exception{
		
		logger.info("[{}]--begin调用后场,停车收入统计-->折线图,入参={}",requestObject.getBaseRequest().getRequestId(),JSONObject.toJSON(requestObject));
		BizResult<List<OrderTransFoldLineDTO>> result = orderTransactionService.queryOrderTransactionFoldLine(requestObject);
		logger.info("[{}]--end调用后场,停车收入统计-->折线图.",requestObject.getBaseRequest().getRequestId());
		return new BizResultVO<List<OrderTransFoldLineDTO>>(result);
	}

	/**
	 * Unification interface used for responding web front request.
	 * @param reqjsonstr
	 * @return
	 */
	@ApiOperation("获取交易相关统计数据 统一接口处理 ")
	@RequestMapping("/gettransactionstatistic")
	public Object GetTransactionStatistic(@RequestBody String reqjsonstr) {
		BaseInfo baseInfo = new BaseInfo();
		String requestId = baseInfo.getRequestId();

		logger.info("[RequestId:" + requestId + "]停车场云平台数据统计交易管理请求参数:" + reqjsonstr);
		
		// Write log
		InterfaceLogSaveRequest logSaveRequest = new InterfaceLogSaveRequest(sysCode, 
				baseInfo, -1, reqjsonstr, -1);
		
		// Object responding web front request.
		// TransactionStatisticRespondObject<TransactionStatisticSummary, TransactionRecord> respondObject
		TransactionStatisticRespondObject<OrderTransDetailDTO, OrderTransDTO> respondObject 
			= new TransactionStatisticRespondObject<OrderTransDetailDTO, OrderTransDTO>();
		
		try {
			if (StringUtils.isBlank(reqjsonstr)) {
				throw new BizException(ErrorType.PARAMM_NULL, "请求报文");
			}

			// Request Object from web front.
			//TransactionRequestObject tro = JSON.parseObject(reqjsonstr, TransactionRequestObject.class);
			OrderTransactionQueryRequest requestObject = JSON.parseObject(reqjsonstr, OrderTransactionQueryRequest.class);
			
			// Get the "TransactionStatisticSummary" object through interface from 王富生.
			//TransactionStatisticSummary tss = null;
			BizResult<OrderTransDTO> tranStcSummary = orderTransactionService.queryOrderTransaction(requestObject);
			respondObject.setTranStcSummary(tranStcSummary.getData());
			
			// Get the list of "TransactionRecord"  through interface from 王富生.
			BizResult<PageBean<OrderTransDetailDTO>> tranRecordList = orderTransactionService.queryOrderTransactionDetail(requestObject);
			List<OrderTransDetailDTO> transactionRecordList = tranRecordList.getData().getDataList();
			respondObject.setTransactionRecordList(transactionRecordList);
			
			// Set log foreign key.
			// logSaveRequest.setOutId();
			logSaveRequest.setStatus(InterfaceLog.Status.SUCCESS);
		} catch (Exception e) {
			logSaveRequest.setMessage(ExceptionUtil.getTrace(e));
			logSaveRequest.setStatus(InterfaceLog.Status.FAIL);
			logger.info(e.toString());
		} finally {
			logSaveRequest.setResponseBody(JSONObject.toJSONString(respondObject));
			logSaveRequest.setResponseTime(new Date());
			//保存日志
			try{
				interfaceLogService.SaveInterfaceLog(logSaveRequest);
			}catch(Exception e){
				e.printStackTrace();
			}
		}
		
		return respondObject;
	}
	
	
	
	
	@ApiOperation("导出交易管理数据统计excel")
	@GetMapping("exportTransactionStatisticExcel")
	public void excelParkingLotUseStatistic(@RequestParam String beginTime,
			@RequestParam String endTime, @RequestParam List plNos,
			Integer recType,
			HttpServletRequest  requests,
			HttpServletResponse response) throws Exception{
		
		OrderTransactionQueryRequest request=new OrderTransactionQueryRequest(); 
		request.setSysCode(sysCode);
		request.setBeginTime(DateUtil.to_date(beginTime, DateUtil.DATETIME_FORMAT));
		request.setEndTime(DateUtil.to_date(endTime, DateUtil.DATETIME_FORMAT));
//		List<String> plNoslist=new ArrayList<>();
//		plNoslist.add(plNos);
		request.setParkIds(plNos);
		request.setRecType(recType);
		request.setBaseRequest(new BaseInfo(1, 0));
		BizResult<PageBean<OrderTransDetailDTO>> bizResult=orderTransactionService.queryOrderTransactionDetail(request);
		SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		SimpleDateFormat format2 = new SimpleDateFormat("yyyy-MM-dd");
		String[] title = new String[]{"交易时间","缴费状态","停车场名称","车牌号","订单号","停车类型","支付方式","金额","免费理由"};
		
		String sheetName="交易管理";
		String fileName = "交易管理"+format2.format(new Date()); 
		// 1.创建excel信息
		XSSFSheet workSheet = ExcelUtil.createExcel(sheetName);
		// 2.设置excel表头和表体
		Layouter.buildReport(workSheet,title,0, 0);
		//3.填充数据
		List<Object[]> contentList=new ArrayList<Object[]>();
		List<OrderTransDetailDTO> list =new ArrayList<>();
		if(CollectionUtils.isNotEmpty(bizResult.getData().getDataList())){
			list= bizResult.getData().getDataList();
		}
		for (OrderTransDetailDTO e: list) {
			 Object[] obj=new Object[title.length];
			 int index=0;
			 obj[index++]=e.getCreateTime() != null ? format.format(e.getCreateTime()) : "";
			 if(e.getOrderState() != null){
				 obj[index++]=(e.getOrderState() == 5 ? "异常缴费" :"正常缴费");
			 }else{
				 obj[index++]="-"; 
			 }
			 obj[index++]=e.getParkName();
			 obj[index++]=e.getCarNum();
			 obj[index++]=e.getOrderNo();
			 if(1==e.getPayType()){
				 obj[index++]="免费停车";
			 }else if(2==e.getPayType()){
				 obj[index++]="收费停车";
        	 }else{
        		 obj[index++]="-";
        	 }
			 if(e.getPayType() != null){
				 switch (e.getPayType()) {
				case 1:
					obj[index++]="支付宝";
					break;
				case 2:
					obj[index++]="微信";
					break;
				case 3:
					obj[index++]="银联";
					break;
				case 4:
					obj[index++]="微信";
					break;
				default:
					obj[index++]="现金";
					break;
				}
			 }else{
				 obj[index++]="";
			 }
			 obj[index++]=(e.getOrderTotalFee() != null ? AmountUtils.changeF2Y(e.getOrderTotalFee().longValue()) : "");
			 
			 if(e.getFreeReason() != null){
				 switch (e.getFreeReason()) {
				case 0:
					obj[index++]="短时停车免费";
					break;
				case 7:
					obj[index++]="授权车免费";
					break;
				case 8:
					obj[index++]="手动免费开闸";
					break;
				default:
					obj[index++]="-";
					break;
				}
			 }else{
				 obj[index++]="-"; 
			 }
			 contentList.add(obj);
		}
		ExcleFillDateManager fillUserManager=new ExcleFillDateManager();
		fillUserManager.fillSalesOrga(workSheet,title,contentList,2);
		// 4.excel输出配置
		ExcelUtil.write(response, workSheet, fileName);
	}
	
}
