/**
 * 
 */
package com.zteits.irain.portal.web.parkinglotcloudplatform.datastatistic;

import java.io.IOException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.clouds.common.constants.SessionEnum;
import com.clouds.common.entity.UserInfo;
import com.clouds.common.utils.AmountUtils;
import com.clouds.common.utils.DateUtil;
import com.clouds.common.utils.ResultUtils;
import com.clouds.common.utils.excle.ExcelUtil;
import com.clouds.common.utils.excle.ExcleFillDateManager;
import com.clouds.common.utils.excle.Layouter;
import com.clouds.common.web.BizController;
import com.clouds.common.web.SessionCommUtil;
import com.clouds.common.web.vo.BizResultVO;
import com.clouds.common.web.vo.EasyUIDataGridVO;
import com.zteits.clouds.api.apibase.bean.BaseInfo;
import com.zteits.clouds.api.apibase.bean.BizResult;
import com.zteits.clouds.api.apibase.bean.PageBean;
import com.zteits.clouds.api.apibase.constants.ErrorType;
import com.zteits.clouds.api.apibase.exception.BizException;
import com.zteits.clouds.api.dto.clouds.dto.BillManageDTO;
import com.zteits.clouds.api.dto.clouds.dto.BillManageDetailDTO;
import com.zteits.clouds.api.dto.clouds.dto.BillManageDetailForMonthDTO;
import com.zteits.clouds.api.dto.clouds.dto.BillManageForMonthDTO;
import com.zteits.clouds.api.dto.clouds.dto.BillManageForMonthDetailDTO;
import com.zteits.clouds.api.dto.clouds.dto.MonthBillMngtStatisticByParkinglotDTO;
import com.zteits.clouds.api.dto.clouds.dto.MonthBillMngtStatisticDTO;
import com.zteits.clouds.api.dto.clouds.dto.MonthBillSummaryStatisticDTO;
import com.zteits.clouds.api.dto.clouds.dto.YearMonthCardStatisticDTO;
import com.zteits.clouds.api.dto.clouds.param.BillQueryRequest;
import com.zteits.clouds.api.dto.clouds.param.MonthBillRequest;
import com.zteits.clouds.api.dto.pay.param.TdCompanyParkQueryRequest;
import com.zteits.clouds.api.dto.pay.param.YearMonthCardStatisticRequest;
import com.zteits.clouds.api.service.clouds.MonthBillManagementService;
import com.zteits.clouds.api.service.clouds.YearMonthCardStatisticService;
import com.zteits.clouds.api.service.pay.TdCustCompanyService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * @author hxz
 *
 */
@Api(value = "结算管理 账单管理 月账单管理", description = "停车场云平台 月账单管理")
@Controller
@RequestMapping("/monthbill")
public class MonthBillManagementController extends BizController {/*
	private static final Logger logger = LoggerFactory.getLogger(MonthBillManagementController.class);

	@Autowired
	private MonthBillManagementService monthBillManagementService;
	@Autowired
	private YearMonthCardStatisticService yearMonthCardStatisticService;

	@Autowired
	private TdCustCompanyService tdCustCompanyService;
	@Autowired
	private HttpSession session;
	@Autowired
	private SessionCommUtil sessionCommUtil;
	@Value("${project.syscode}")
	private String sysCode;

	@ApiOperation("月账单查询汇总统计")
	@PostMapping("/summaryStatistic")
	@ResponseBody
	public BizResultVO<MonthBillSummaryStatisticDTO> getMonthBillSummaryStatistic(
			@RequestBody MonthBillRequest request) {
		logger.info("月账单查询汇总统计请求对象 req={}", JSONObject.toJSONString(request));
		BizResult<MonthBillSummaryStatisticDTO> respondResult = monthBillManagementService
				.getMonthBillSummaryStatistic(request);
		logger.info("月账单查询汇总统计响应结果 respondResult={}", JSONObject.toJSONString(respondResult));
		return new BizResultVO<>(respondResult);
	}

	*//**
	 * 临停收费, 按支付方式汇总统计，tp表示临停
	 * 
	 * @param request
	 *//*
	@ApiOperation("临停收费, 按支付方式汇总统计，tp表示临停")
	@PostMapping("/tpStatistic")
	@ResponseBody
	public BizResultVO<MonthBillMngtStatisticDTO> getMonthBillMngtTPStatistic(@RequestBody MonthBillRequest request) {
		logger.info("临停收费, 按支付方式汇总统计 req={}", JSONObject.toJSONString(request));
		BizResult<MonthBillMngtStatisticDTO> respondResult = monthBillManagementService
				.getMonthBillMngtTPStatistic(request);
		logger.info("临停收费, 按支付方式汇总统计 respondResult={}", JSONObject.toJSONString(respondResult));
		return new BizResultVO<>(respondResult);
	}

	*//**
	 * <!-- 临停收费，按照停车场分组后，按支付方式分类统计 TP ByParkinglot-->
	 * 
	 * @param request
	 * @return
	 *//*
	@ApiOperation("临停收费, 按照停车场分组后，按支付方式分类统计，tp表示临停，Pklt表示停车场")
	@PostMapping("/tpPkltStatistic")
	@ResponseBody
	BizResultVO<List<MonthBillMngtStatisticByParkinglotDTO>> getMonthBillMngtTPStatisticByParkinglot(
			@RequestBody MonthBillRequest request) {
		logger.info("临停收费, 停车场分组，按支付方式分类 req={}", JSONObject.toJSONString(request));
		BizResult<List<MonthBillMngtStatisticByParkinglotDTO>> respondResult = monthBillManagementService
				.getMonthBillMngtTPStatisticByParkinglot(request);
		logger.info("临停收费, 停车场分组，按支付方式分类respondResult={}", JSONObject.toJSONString(respondResult));
		return new BizResultVO<>(respondResult);
	}

	*//**
	 * <!-- 月卡、年卡, 按支付方式汇总统计 CardMY-->
	 * 
	 * @param request
	 * @return
	 *//*
	@ApiOperation("月卡、年卡, 按支付方式汇总统计")
	@PostMapping("/cardStatistic")
	@ResponseBody
	BizResultVO<MonthBillMngtStatisticDTO> getMonthBillMngtCardMYStatistic(@RequestBody MonthBillRequest request) {
		logger.info("月卡、年卡, 按支付方式分类 req={}", JSONObject.toJSONString(request));
		BizResult<MonthBillMngtStatisticDTO> respondResult = monthBillManagementService
				.getMonthBillMngtCardMYStatistic(request);
		logger.info("月卡、年卡, 按支付方式分类respondResult={}", JSONObject.toJSONString(respondResult));
		return new BizResultVO<>(respondResult);
	}

	*//**
	 * <!-- 月卡、年卡，按照停车场分组后，按支付方式分类统计CardMY ByParkinglot-->
	 * 
	 * @param request
	 * @return
	 *//*
	@ApiOperation("月卡、年卡, 按支付方式汇总统计，Pklt表示停车场")
	@PostMapping("/cardPkltStatistic")
	@ResponseBody
	BizResultVO<List<MonthBillMngtStatisticByParkinglotDTO>> getMonthBillMngtCardMYStatisticByParkinglot(
			@RequestBody MonthBillRequest request) {
		logger.info("月卡、年卡,  停车场分组，按支付方式分类 req={}", JSONObject.toJSONString(request));
		BizResult<List<MonthBillMngtStatisticByParkinglotDTO>> respondResult = monthBillManagementService
				.getMonthBillMngtCardMYStatisticByParkinglot(request);
		logger.info("月卡、年卡,  停车场分组，按支付方式分类respondResult={}", JSONObject.toJSONString(respondResult));
		return new BizResultVO<>(respondResult);
	}

	// ----------------------------------------------------2017-8-1新添加-----------------------------------------------

	*//**
	 * 
	 * @param request
	 * @return
	 * @throws Exception
	 *//*
	@ApiOperation("月账单管理统计列表")
	@PostMapping("/queryBillforMonthList")
	@ResponseBody
	public BizResultVO<EasyUIDataGridVO<BillManageForMonthDTO>> queryBillforMonthList(
			@RequestBody BillQueryRequest billQueryRequest, HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		// 2.调用接口查询当前登录人管辖的停车场名称
		UserInfo userInfo = sessionCommUtil.getUserInfo();
		List<String> plNos = new ArrayList<>();
		if (userInfo != null) {
			TdCompanyParkQueryRequest tdCompanyParkQueryRequest = new TdCompanyParkQueryRequest();
			tdCompanyParkQueryRequest.setCustIdList(userInfo.getOrgIds());
			tdCompanyParkQueryRequest.setSessionId(session.getId());
			tdCompanyParkQueryRequest.setSysCode(sysCode);
			BizResult<List<String>> bizResult = tdCustCompanyService.queryParkNoByCustIds(tdCompanyParkQueryRequest);
			// 拥有的停车场编号
			plNos = ResultUtils.getBizResultData(bizResult);
		}
//		if (CollectionUtils.isEmpty(plNos)) {
//			throw new BizException(ErrorType.PARK_LOT_NOT_EXISTS, "停车场plnos不存在");
//		}
		billQueryRequest.setParkIdList(plNos);
		logger.info("月账单管理统计列表 req={}", JSONObject.toJSONString(billQueryRequest));
		BizResult<List<BillManageForMonthDTO>> respondResult = monthBillManagementService
				.queryBillforMonthList(billQueryRequest);
		logger.info("月账单管理统计列表 respondResult={}", JSONObject.toJSONString(respondResult));
		return returnJqGridDataByList(respondResult, BillManageForMonthDTO.class);
	}

	*//**
	 * 
	 * @param request
	 * @return
	 *//*
	@ApiOperation("月账单管理对账单统计明细")
	@PostMapping("/queryBillforMonthDetail")
	@ResponseBody
	public BizResultVO<EasyUIDataGridVO<BillManageForMonthDetailDTO>> queryBillforMonthDetail(
			@RequestBody BillQueryRequest billQueryRequest, HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		// 2.调用接口查询当前登录人管辖的停车场名称
		UserInfo userInfo = sessionCommUtil.getUserInfo();
		List<String> plNos = new ArrayList<>();
		if (userInfo != null) {
			TdCompanyParkQueryRequest tdCompanyParkQueryRequest = new TdCompanyParkQueryRequest();
			tdCompanyParkQueryRequest.setCustIdList(userInfo.getOrgIds());
			tdCompanyParkQueryRequest.setSessionId(session.getId());
			tdCompanyParkQueryRequest.setSysCode(sysCode);
			BizResult<List<String>> bizResult = tdCustCompanyService.queryParkNoByCustIds(tdCompanyParkQueryRequest);
			// 拥有的停车场编号
			plNos = ResultUtils.getBizResultData(bizResult);
		}
//		if (CollectionUtils.isEmpty(plNos)) {
//			throw new BizException(ErrorType.PARK_LOT_NOT_EXISTS, "停车场plnos不存在");
//		}
		billQueryRequest.setParkIdList(plNos);
		logger.info("月账单管理对账单统计明细 req={}", JSONObject.toJSONString(billQueryRequest));
		
		BizResult<List<BillManageForMonthDetailDTO>> respondResult = monthBillManagementService
				.queryBillforMonthDetail(billQueryRequest);
		logger.info("月账单管理对账单统计明细 respondResult={}", JSONObject.toJSONString(respondResult));
		return returnJqGridDataByList(respondResult, BillManageForMonthDetailDTO.class);
	}

	*//**
	 * 月账单临停导出.<br/>
	 * 
	 * @param request
	 * @param response
	 *//*
	@ApiOperation("月账单临停导出")
	@GetMapping("/exportToExcleForBillForMonthTmp")
	public void exportToExcleForBillForMonthTmp(@RequestParam List<String> parkIdList,
			@RequestParam List<Integer> orderTypeList,@RequestParam String beginTime,
			@RequestParam String endTime, HttpServletRequest request, HttpServletResponse response) {
		logger.info("---begin--日账单导出调用后场dubbo服务,入参 beginTime={},endTime={}", beginTime, endTime);
		BizResult<PageBean<BillManageDetailForMonthDTO>> result = new BizResult<PageBean<BillManageDetailForMonthDTO>>();
		try {
			BillQueryRequest billQueryRequest = new BillQueryRequest();
			if (null == beginTime || null == endTime) {
				throw new BizException(ErrorType.PARAMM_NULL, "开始时间和结束时间");
			}

			billQueryRequest.setSysCode(sysCode);
			billQueryRequest.setBeginTime(DateUtil.to_date(beginTime, DateUtil.DATETIME_FORMAT));
			billQueryRequest.setEndTime(DateUtil.to_date(endTime, DateUtil.DATETIME_FORMAT));
			billQueryRequest.setParkIdList(parkIdList);
			billQueryRequest.setOrderTypeList(orderTypeList);
			billQueryRequest.setBaseRequest(new BaseInfo(1, 0));
			*//** 查询月账单. *//*
			result = monthBillManagementService.queryBillforMonthDetailForList(billQueryRequest);
			SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
			SimpleDateFormat format2 = new SimpleDateFormat("yyyy-MM-dd");
			String[] title = new String[] { "流水号", "时间", "车主车牌号", "进场时间", "出场时间", "停车时长", "收费规则", "支付方式", "应收金额", "优惠券",
					"红包", "实收金额", "共计" };
			String sheetName = "月账单";
			String fileName = "月账单管理" + format2.format(new Date());

			// 1.创建excel信息
			XSSFSheet workSheet = ExcelUtil.createExcel(sheetName);
			// 2.设置excel表头和表体
			Layouter.buildReport(workSheet, title, 0, 0);
			// 3.填充数据
			List<Object[]> contentList = new ArrayList<Object[]>();

			List<BillManageDetailForMonthDTO> list = new ArrayList<BillManageDetailForMonthDTO>();
			if (CollectionUtils.isNotEmpty(result.getData().getDataList())) {
				list = result.getData().getDataList();
			}
			for (BillManageDetailForMonthDTO e : list) {
				Object[] obj = new Object[title.length];
				int index = 0;
				obj[index++] = StringUtils.isNotEmpty(e.getPayOrderNo()) ? e.getPayOrderNo() : "";
				obj[index++] = e.getPayFinishTime() != null
						? DateUtil.getDateString(e.getPayFinishTime(), DateUtil.DATETIME_FORMAT) : "";
				obj[index++] = StringUtils.isNotEmpty(e.getCarNum()) ? e.getCarNum() : "";
				obj[index++] = e.getParkInTime() != null
						? DateUtil.getDateString(e.getParkInTime(), DateUtil.DATETIME_FORMAT) : "";
				obj[index++] = e.getParkOutTime() != null
						? DateUtil.getDateString(e.getParkOutTime(), DateUtil.DATETIME_FORMAT) : "";
				obj[index++] = e.getParkingDuration() != null ? e.getParkingDuration() : DateUtil.secondToTime(0);
				obj[index++] = "";
				if (e.getPayType() != null) {
					switch (e.getPayType()) {
					case 1:
						obj[index++] = "支付宝";
						break;
					case 2:
						obj[index++] = "微信";
						break;
					case 3:
						obj[index++] = "银联";
						break;
					case 4:
						obj[index++] = "微信";
						break;
					default:
						obj[index++] = "现金";
						break;
					}
				} else {
					obj[index++] = "";
				}
				obj[index++] = e.getAmountDueTotal() != null ? AmountUtils.changeF2Y(e.getAmountDueTotal().longValue())
						: "0.00";
				obj[index++] = "0.00";
				obj[index++] = "0.00";
				obj[index++] = e.getPayedTotalAmount() != null
						? AmountUtils.changeF2Y(e.getPayedTotalAmount().longValue()) : "0.00";
				obj[index++] = e.getAmountDueTotal() != null ? AmountUtils.changeF2Y(e.getAmountDueTotal().longValue())
						: "0.00";
				contentList.add(obj);
			}
			
			ExcleFillDateManager fillUserManager = new ExcleFillDateManager();
			fillUserManager.fillSalesOrga(workSheet, title, contentList, 2);
			// 4.excel输出配置
			ExcelUtil.write(response, workSheet, fileName);
		} catch (Exception e) {
			result.setErrorInfo(ErrorType.BIZ_ERROR, "系统错误!");
			e.printStackTrace();
		}

	}

	*//**
	 * 月账单年卡月卡导出.<br/>
	 * 
	 * @param request
	 * @param response
	 *//*
	@ApiOperation("月账单年卡月卡导出")
	@GetMapping("/exportToExcleForBillForYearOrMonth")
	public void exportToExcleForBillForYearOrMonth(@RequestParam List<String> parkIdList,
			@RequestParam String beginTime,@RequestParam String endTime,
			HttpServletRequest request, HttpServletResponse response) {
		logger.info("---begin--月账单年卡月卡导出调用后场dubbo服务,入参 beginTime={},endTime={}", beginTime, endTime);
		BizResult<PageBean<YearMonthCardStatisticDTO>> result = new BizResult<PageBean<YearMonthCardStatisticDTO>>();
		try {
			YearMonthCardStatisticRequest yearMonthCardStatisticRequest = new YearMonthCardStatisticRequest();
			if (null == beginTime || null == endTime) {
				throw new BizException(ErrorType.PARAMM_NULL, "开始时间和结束时间");
			}

			yearMonthCardStatisticRequest.setSysCode(sysCode);
			yearMonthCardStatisticRequest.setBeginTime(DateUtil.to_date(beginTime, DateUtil.DATETIME_FORMAT));
			yearMonthCardStatisticRequest.setEndTime(DateUtil.to_date(endTime, DateUtil.DATETIME_FORMAT));
			yearMonthCardStatisticRequest.setParkIdList(parkIdList);
			yearMonthCardStatisticRequest.setBaseRequest(new BaseInfo(1, 0));
			*//** 查询月账单年卡月卡. *//*
			result = yearMonthCardStatisticService.queryYearMonthCardStatistic(yearMonthCardStatisticRequest);

			SimpleDateFormat format2 = new SimpleDateFormat("yyyy-MM-dd");
			String[] title = new String[] { "交易单号", "交易时间", "种类", "卡名称", "车牌号", "支付金额", "有效期" };
			String sheetName = "月账单";
			String fileName = "月账单管理" + format2.format(new Date());

			// 1.创建excel信息
			XSSFSheet workSheet = ExcelUtil.createExcel(sheetName);
			// 2.设置excel表头和表体
			Layouter.buildReport(workSheet, title, 0, 0);
			// 3.填充数据
			List<Object[]> contentList = new ArrayList<Object[]>();

			List<YearMonthCardStatisticDTO> list = new ArrayList<YearMonthCardStatisticDTO>();
			
			if (CollectionUtils.isNotEmpty(result.getData().getDataList())) {
				list = result.getData().getDataList();
			}
			for (YearMonthCardStatisticDTO e : list) {
				Object[] obj = new Object[title.length];
				int index = 0;
				obj[index++] = StringUtils.isNotEmpty(e.getOrderId()) ? e.getOrderId() : "";
				obj[index++] = e.getPayFinishTime() != null
						? DateUtil.getDateString(e.getPayFinishTime(), DateUtil.DATETIME_FORMAT) : "";
				String yearOrMonthCard = "";
				if (null != e.getOrderType()) {
					if (2 == e.getOrderType()) {
						yearOrMonthCard = "年卡";
						obj[index++] = yearOrMonthCard;
					} else if (3 == e.getOrderType()) {
						yearOrMonthCard = "月卡";
						obj[index++] = yearOrMonthCard;
					}
				} else {
					obj[index++] = "";
				}
				obj[index++] = StringUtils.isNotEmpty(e.getParkName()) ? e.getParkName() + yearOrMonthCard : "";

				obj[index++] = StringUtils.isNotEmpty(e.getCarNumber()) ? e.getCarNumber() : "";

				obj[index++] = e.getAmount() != null ? AmountUtils.changeF2Y(e.getAmount().longValue()) : "0.00";
				String effDate = "";
				String expDate = "";
				SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
				if (null != e.getEffDate()) {
					effDate = format.format(e.getEffDate());
				}
				if (null != e.getExpDate()) {
					expDate = format.format(e.getExpDate());
				}

				obj[index++] = effDate + " - " + expDate;

				contentList.add(obj);
			}
			
			ExcleFillDateManager fillUserManager = new ExcleFillDateManager();
			fillUserManager.fillSalesOrga(workSheet, title, contentList, 2);
			// 4.excel输出配置
			ExcelUtil.write(response, workSheet, fileName);
		} catch (Exception e) {
			result.setErrorInfo(ErrorType.BIZ_ERROR, "系统错误!");
			e.printStackTrace();
		}

	}
	
	
	
	
	*//**
	 * 月账单所有导出.<br/>
	 * 
	 * @param request
	 * @param response
	 *//*
	@ApiOperation("月账单所有导出")
	@GetMapping("/exportToExcleForBillForAll")
	public void exportToExcleForBillForAll(
			@RequestParam String beginTime,
			@RequestParam String endTime, HttpServletRequest request, HttpServletResponse response) {
		BizResult<List<BillManageForMonthDetailDTO>> respondResult= new BizResult<List<BillManageForMonthDetailDTO>>();
		try {
			BillQueryRequest billQueryRequest=new BillQueryRequest();
			if (null == beginTime || null == endTime) {
				throw new BizException(ErrorType.PARAMM_NULL, "开始时间和结束时间");
			}

			billQueryRequest.setSysCode(sysCode);
			billQueryRequest.setBeginTime(DateUtil.to_date(beginTime, DateUtil.DATETIME_FORMAT));
			billQueryRequest.setEndTime(DateUtil.to_date(endTime, DateUtil.DATETIME_FORMAT));
			billQueryRequest.setBaseRequest(new BaseInfo(1, 0));
			// 2.调用接口查询当前登录人管辖的停车场名称
			UserInfo userInfo = sessionCommUtil.getUserInfo();
			List<String> plNos = new ArrayList<>();
			if (userInfo != null) {
				TdCompanyParkQueryRequest tdCompanyParkQueryRequest = new TdCompanyParkQueryRequest();
				tdCompanyParkQueryRequest.setCustIdList(userInfo.getOrgIds());
				tdCompanyParkQueryRequest.setSessionId(session.getId());
				tdCompanyParkQueryRequest.setSysCode(sysCode);
				BizResult<List<String>> bizResult = tdCustCompanyService.queryParkNoByCustIds(tdCompanyParkQueryRequest);
				// 拥有的停车场编号
				plNos = ResultUtils.getBizResultData(bizResult);
			}
			billQueryRequest.setParkIdList(plNos);
			logger.info("月账单导出所有 req={}", JSONObject.toJSONString(billQueryRequest));
			respondResult = monthBillManagementService
					.queryBillforMonthDetail(billQueryRequest);
			logger.info("月账单导出所有  respondResult={}", JSONObject.toJSONString(respondResult));
			
			SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
			SimpleDateFormat format2 = new SimpleDateFormat("yyyy-MM-dd");
			String[] title = new String[] { "停车场名称", "现金", "微信", "支付宝", "合计"};
			String[] sheetName = new String[]{"临停收费","年卡月卡收费"};
			String fileName = "月账单管理" + format2.format(new Date());

			// 1.创建excel信息,多个sheet页
			XSSFWorkbook workbook = new XSSFWorkbook();
			XSSFSheet workSheetTmp = workbook.createSheet(sheetName[0]);
			XSSFSheet workSheetYearOrMonth = workbook.createSheet(sheetName[1]);
			XSSFSheet[] worksheet= new XSSFSheet[]{workSheetTmp,workSheetYearOrMonth};
			// 2.设置excel表头和表体
			Layouter.buildReport(workSheetTmp, title, 0, 0);
			Layouter.buildReport(workSheetYearOrMonth, title, 0, 0);
			// 3.填充数据
			List<Object[]> contentYearOrMonthList = new ArrayList<Object[]>();
			List<Object[]> contentTmpList = new ArrayList<Object[]>();
			List<BillManageForMonthDetailDTO> list = new ArrayList<BillManageForMonthDetailDTO>();
			if (CollectionUtils.isNotEmpty(respondResult.getData())) {
				list = respondResult.getData();
			}
			for (BillManageForMonthDetailDTO e : list) {
				Object[] obj = new Object[title.length];
				int index = 0;
				obj[index++] = StringUtils.isNotEmpty(e.getParkName()) ? e.getParkName() : "";
				obj[index++] = e.getTmpCashAmount() != null
						? AmountUtils.changeF2Y(e.getTmpCashAmount().longValue()) : "0.00";
				obj[index++] = e.getTmpWeChatAmount() != null ? AmountUtils.changeF2Y(e.getTmpWeChatAmount().longValue())
								: "0.00";
				obj[index++] = e.getTmpAlipayAmount() != null ? AmountUtils.changeF2Y(e.getTmpAlipayAmount().longValue())
						: "0.00";
				obj[index++] = e.getTmpAll() != null ? AmountUtils.changeF2Y(e.getTmpAll().longValue())
						: "0.00";
				contentTmpList.add(obj);
			}
			for (BillManageForMonthDetailDTO e : list) {
				Object[] obj = new Object[title.length];
				int index = 0;
				obj[index++] = StringUtils.isNotEmpty(e.getParkName()) ? e.getParkName() : "";
				obj[index++] = e.getYearMontCashAmount() != null
						? AmountUtils.changeF2Y(e.getYearMontCashAmount().longValue()) : "0.00";
				obj[index++] = e.getYearMonthWeChatAmount() != null ? AmountUtils.changeF2Y(e.getYearMonthWeChatAmount().longValue())
								: "0.00";
				obj[index++] = e.getYearMonthAlipayAmount() != null ? AmountUtils.changeF2Y(e.getYearMonthAlipayAmount().longValue())
						: "0.00";
				obj[index++] = e.getYearMonthAll() != null ? AmountUtils.changeF2Y(e.getYearMonthAll().longValue())
						: "0.00";
				contentYearOrMonthList.add(obj);
			}
			
			ExcleFillDateManager fillUserManager = new ExcleFillDateManager();
			fillUserManager.fillSalesOrga(workSheetTmp, title, contentTmpList, 2);
			ExcleFillDateManager fillUserManagerYearOrMonth = new ExcleFillDateManager();
			fillUserManagerYearOrMonth.fillSalesOrga(workSheetYearOrMonth, title, contentYearOrMonthList, 2);
			// 4.excel输出配置
			ExcelUtil.write(response, worksheet, fileName);
			
		} catch (Exception e) {
			respondResult.setErrorInfo(ErrorType.BIZ_ERROR, "系统错误!");
			e.printStackTrace();
		}

	}
	
	
	
	
	
	
	

	*//**
	 * 通过session信息获取停车场编码.<br/>
	 * 
	 * @param billQueryRequest
	 * @param userInfo
	 * @return
	 * @throws Exception
	 *//*
	private List<String> queryParkNoByCustIds(TdCompanyParkQueryRequest tdCompanyParkQueryRequest) throws Exception {
		*//** 查询停车场编码. *//*
		BizResult<List<String>> parkNoResult = tdCustCompanyService.queryParkNoByCustIds(tdCompanyParkQueryRequest);
		if (parkNoResult.isSuccess() && parkNoResult != null && parkNoResult.getData() != null) {
			logger.info("根据登录获取到对应的停车场编码=" + JSONArray.toJSONString(parkNoResult.getData()));
			return parkNoResult.getData();
		} else {
			logger.info("根据登录用户没有获取到对应的停车场编码");
			return null;
		}

	}
	
	
	
*/}
