package com.zteits.irain.portal.web.parkinglotcloudplatform.datastatistic;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import javax.validation.Valid;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.clouds.common.cache.park.ParkingLotCacheUtil;
import com.clouds.common.utils.DateUtil;
import com.clouds.common.utils.ResultUtils;
import com.clouds.common.web.BizController;
import com.clouds.common.web.vo.BizResultVO;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.zteits.clouds.api.apibase.bean.BaseInfo;
import com.zteits.clouds.api.apibase.bean.BizResult;
import com.zteits.clouds.api.apibase.bean.PageBean;
import com.zteits.clouds.api.dto.clouds.dto.CustIncomeForPayTypeDTO;
import com.zteits.clouds.api.dto.clouds.dto.CustIncomeTotalDTO;
import com.zteits.clouds.api.dto.clouds.dto.CustIncomeTotalParkDTO;
import com.zteits.clouds.api.dto.clouds.param.CustIncomeTotalQueryRequset;
import com.zteits.clouds.api.dto.park.dto.ParkingLotDTO;
import com.zteits.clouds.api.dto.park.dto.ParkingLotUseStatisticDTO;
import com.zteits.clouds.api.dto.park.param.ParkingLotUseStatisticForPageRequest;
import com.zteits.clouds.api.dto.park.param.RealTimeVehicleFlowQueryRequest;
import com.zteits.clouds.api.service.clouds.CustIncomeService;
import com.zteits.clouds.api.service.park.IInOutParkingService;
import com.zteits.clouds.api.service.park.ParkingLotUseStatisticService;
import com.zteits.irain.portal.constant.ParkConstant;
import com.zteits.irain.portal.vo.parkinglotcloudplatform.datastatistic.BerthsAndFlowLineChartVO;
import com.zteits.irain.portal.vo.parkinglotcloudplatform.datastatistic.CustIncomeForPayTypeResVO;
import com.zteits.irain.portal.vo.parkinglotcloudplatform.datastatistic.CustIncomeTotalParkVO;
import com.zteits.irain.portal.vo.parkinglotcloudplatform.datastatistic.CustIncomeTotalVO;
import com.zteits.irain.portal.vo.parkinglotcloudplatform.datastatistic.LineChartVO;
import com.zteits.irain.portal.vo.parkinglotcloudplatform.datastatistic.LineChartVO.SerieVO;

import io.swagger.annotations.ApiOperation;

/**
 * Copyright: Copyright (c) 2017  zteits
 *
 * @ClassName: com.zteits.irain.portal.web.parkinglotcloudplatform.datastatistic
 * @Description:
 * @version: v1.0.0
 * @author: atao
 * @date: 2017/6/19   下午5:11
 * Modification History:
 * Date         Author          Version      Description
 * ---------------------------------------------------------*
 * 2017/6/19      atao          v1.0.0          创建
 */
@RestController
@RequestMapping("/index")
public class IndexPageStatisticController extends BizController {

    private Logger logger = LoggerFactory.getLogger(IndexPageStatisticController.class);

    @Autowired
    private CustIncomeService cusIncomeService;
    /**
     * 进出场记录
     */
    @Autowired
    private IInOutParkingService iInOutParkingService;
    @Autowired
    private ParkingLotUseStatisticService parkingLotStatisticService;
    
    /**
     * 云平台首页－>企业客户负责所有的停车场汇总.<br/>
     *
     * @return
     * @throws Exception
     */
    @ApiOperation("企业客户负责所有的停车场汇总")
    @PostMapping("/queryCustIncomeTotal")
    public BizResultVO<CustIncomeTotalVO> queryCustIncomeTotal(
        @RequestBody CustIncomeTotalQueryRequset custIncomeTotalQueryRequset)
        throws Exception {

        BizResultVO<CustIncomeTotalVO> bizResultVO = new BizResultVO<>();

        BizResult<CustIncomeTotalDTO> result = cusIncomeService.queryCustIncomeTotal(custIncomeTotalQueryRequset);

        if (ResultUtils.isError(result)) {
            //如果失败
            bizResultVO.setCode(result.getErrCode().getCode());
            bizResultVO.setMsg(result.getErrMsg());
            return bizResultVO;
        }
        CustIncomeTotalVO vo = new CustIncomeTotalVO();
        vo.setAmountDueTotal(result.getData().getAmountDueTotal().setScale(2, BigDecimal.ROUND_HALF_UP).toString());
        vo.setEscapeAmount(result.getData().getEscapeAmount().setScale(2, BigDecimal.ROUND_HALF_UP).toString());
        vo.setPayedTotalAmount(result.getData().getPayedTotalAmount().setScale(2, BigDecimal.ROUND_HALF_UP).toString());

        bizResultVO.setData(vo);

        return bizResultVO;
    }

    /**
     * 云平台首页－>企业客户负责某个停车收入情况.<br/>
     *
     * @return
     * @throws Exception
     */
    @ApiOperation("企业客户负责某个停车收入情况")
    @PostMapping("/queryCustIncomeTotalForPark")
    public BizResultVO<CustIncomeTotalParkVO> queryCustIncomeTotalForPark(
        @RequestBody CustIncomeTotalQueryRequset custIncomeTotalQueryRequset) throws Exception {

        logger.info("企业客户负责某个停车收入情况  入参为: req={}", JSONObject.toJSONString(custIncomeTotalQueryRequset));

        BizResultVO bizResultVO = new BizResultVO();
        BizResult<CustIncomeTotalParkDTO> result = cusIncomeService.queryCustIncomeTotalForPark(
            custIncomeTotalQueryRequset);
        logger.info("企业客户负责某个停车收入情况  调用Dubbo接口响应为: result={}", JSONObject.toJSONString(result));
        if (ResultUtils.isError(result)) {
            //如果失败
            bizResultVO.setCode(result.getErrCode().getCode());
            bizResultVO.setMsg(result.getErrMsg());
            return bizResultVO;
        }
        CustIncomeTotalParkDTO dto = result.getData();
        BigDecimal amountDueTotal = dto.getAmountDueTotal();
        BigDecimal escapeAmount = dto.getEscapeAmount();
        BigDecimal payedTotalAmount = dto.getPayedTotalAmount();



        CustIncomeTotalParkVO vo = new CustIncomeTotalParkVO();

        //金额为分
        vo.setAmountDueTotal(amountDueTotal.setScale(2, BigDecimal.ROUND_HALF_UP).toString());
        vo.setEscapeAmount(escapeAmount.setScale(2, BigDecimal.ROUND_HALF_UP).toString());
        vo.setPayedTotalAmount(payedTotalAmount.setScale(2, BigDecimal.ROUND_HALF_UP).toString());
        //占比乘以100取两位小数
        //应收
        if (null == amountDueTotal || amountDueTotal.doubleValue()==0) {
            vo.setLoopData(1, "00.00");
            vo.setLoopData(2, "00.00");

        } else {
            //实收
            vo.setLoopData(1, payedTotalAmount.divide(amountDueTotal, 4, BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal("100.00"))
                .setScale(2, BigDecimal.ROUND_HALF_UP).toString());
            //逃逸
            vo.setLoopData(2, escapeAmount.divide(amountDueTotal, 4, BigDecimal.ROUND_HALF_UP).multiply(
                new BigDecimal("100.00"))
                .setScale(2, BigDecimal.ROUND_HALF_UP).toString());
        }

        bizResultVO.setData(vo);
        return bizResultVO;
    }

    /**
     * 云平台首页－>企业客户负责某个停车不同的支付方式收入情况.<br/>
     *
     * @return
     * @throws Exception
     */
    @ApiOperation("企业客户负责某个停车不同的支付方式收入情况")
    @PostMapping("/queryCustIncomeForPayType")
    public BizResultVO<CustIncomeForPayTypeResVO> queryCustIncomeForPayType(
        @RequestBody CustIncomeTotalQueryRequset custIncomeTotalQueryRequset) throws Exception {
        logger.info("调用后场dubbo服务,入参为: request={}", JSONObject.toJSONString(custIncomeTotalQueryRequset));
        BizResult<List<CustIncomeForPayTypeDTO>> result = cusIncomeService.queryCustIncomeForPayType(
            custIncomeTotalQueryRequset);

        logger.info("调用后场dubbo服务,响应为: result={}", JSONObject.toJSONString(result));
        //如果不成功
        if (!ResultUtils.isSuccess(result)) {
            return new BizResultVO<>(result.getErrCode(), result.getErrMsg());
        }
        List<CustIncomeForPayTypeDTO> data = result.getData();

        CustIncomeForPayTypeResVO res = new CustIncomeForPayTypeResVO();
        res.addLegendData("费用", "占比");

        BigDecimal total = BigDecimal.ZERO;
        List<String> amount = new ArrayList<>();
        for (CustIncomeForPayTypeDTO dto : data) {
            //添加X轴数据
            res.addXAxisData(dto.getPayTypeName());
            total = total.add(dto.getPayedTotalAmount());
            logger.info("返回的类型 和 数据为: payTypeName={},payedTotalAmount={},total={}", dto.getPayTypeName(),
                dto.getPayedTotalAmount().toString(), total.toString());
            amount.add(dto.getPayedTotalAmount().setScale(2, BigDecimal.ROUND_HALF_UP)
                .doubleValue() + "");
        }
        //计算占比
        List<String> zb = new ArrayList<>();
        for (CustIncomeForPayTypeDTO dto : data) {
            logger.info("计算占比 total={}", total.toString());
            if (BigDecimal.ZERO.equals(total) || total.doubleValue() == 0.00) {
                zb.add("0.00");
            } else {
                zb.add(dto.getPayedTotalAmount().divide(total, 4, RoundingMode.HALF_UP)
                    .multiply(new BigDecimal("100.00")).doubleValue() + "");
            }

        }
        res.addChildData("费用", amount);
        res.addChildData("占比", zb);
        BizResultVO<CustIncomeForPayTypeResVO> resResult = new BizResultVO<>();
        resResult.setData(res);
        logger.info("返回到前台的数据为: res={}", JSONObject.toJSONString(res));
        return resResult;
    }

    /**
     * 根据停车场编号，获取该停车场今日车流量（当天0:00到操作时间的车流量） 折线图
     *
     * @param request
     * @return 2017年6月19日 zhaowg
     */
    @ApiOperation("根据停车场编号获取该停车场今日车流量和车位折线图")
    @PostMapping("getTodayVehicleFlowForLineChart")
    public BizResultVO<BerthsAndFlowLineChartVO> getTodayVehicleFlowForLineChart(
        @RequestBody @Valid ParkingLotUseStatisticForPageRequest request) {
    	logger.info("根据停车场编号获取该停车场今日车流量和车位折线图");
        //开始时间 今日0点开始
        Calendar beginTime = Calendar.getInstance();
        beginTime.set(Calendar.HOUR_OF_DAY, 0);
        beginTime.set(Calendar.MINUTE, 0);
        beginTime.set(Calendar.SECOND, 0);

        //获取当前时间
        Calendar curTime = Calendar.getInstance();
        int curMinute = curTime.get(Calendar.MINUTE);
        if (curMinute >= 0 && curMinute < 20) {
            //统计到当前时间点
            curTime.add(Calendar.MINUTE, 0);
        } else if (curMinute >= 20 && curMinute < 40) {
            //统计到当前小时的20分钟
            curTime.add(Calendar.MINUTE, 20);
        } else if (curMinute >= 40 && curMinute <= 59) {
            //统计到当前小时的40分钟
            curTime.add(Calendar.MINUTE, 40);
        }
        curTime.set(Calendar.SECOND, 0);

        //20分钟为一个时间戳
        List<String> xAxisData = Lists.newArrayList();
        int totaltimestampCount = curTime.get(Calendar.HOUR_OF_DAY) * 3 + curMinute / 20;
        for (int i = 0; i < totaltimestampCount; i++) {
            String hour = String.format("%02d", (i / 3));
            String minute = String.format("%02d", (i % 3) * 20);
            xAxisData.add(hour + ":" + minute);
        }

        //调用后场服务
        request.setBeginTime(beginTime.getTime());
        request.setEndTime(curTime.getTime());
        //每20分钟统计一次
        request.setQueryKind(ParkConstant.ParkingLotUseStatistic.StatisticType.PER20MINUTE);
        request.setBaseRequest(new BaseInfo(1, 0));
        logger.info("调用DUBBO服务入参："+JSON.toJSONString(request));
        BizResult<PageBean<ParkingLotUseStatisticDTO>> bizResult = parkingLotStatisticService
            .queryParkingLotUseStatisticForPage(request);
        PageBean<ParkingLotUseStatisticDTO> pageBean = ResultUtils.getBizResultData(bizResult);
        List<ParkingLotUseStatisticDTO> useStatisticDTOs = Lists.newArrayList();
        if (pageBean != null) {
            useStatisticDTOs = pageBean.getDataList();
        }

        //保存固定车流量，时间戳和车流量对应关系
        Map<String, Integer> fixVehicleFlowMap = Maps.newHashMap();
        //保存临时车流量，时间戳和车流量对应关系
        Map<String, Integer> tmpVehicleFlowMap = Maps.newHashMap();
        //停车场编号和名称对应关系
        Map<String, String> parkNameMap = Maps.newHashMap();
        //通过停车场,和统计时间分组
        Map<String, Map<String, Double>> parkLotMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty(useStatisticDTOs)) {
            for (ParkingLotUseStatisticDTO statisticDTO : useStatisticDTOs) {
                String key = statisticDTO.getPlNo();
                parkNameMap.put(key, statisticDTO.getPlName());
                String statisBeginTime = DateUtil.getDateString(statisticDTO.getStatisticBeginTime(), "HH:mm");
                //保存空置率
                if (!parkLotMap.containsKey(key)) {
                    Map<String, Double> timeAndVal = Maps.newHashMap();
                    timeAndVal.put(statisBeginTime, statisticDTO.getFreeRatio() * 100);
                    parkLotMap.put(key, timeAndVal);
                } else {
                    parkLotMap.get(key).put(statisBeginTime, statisticDTO.getFreeRatio() * 100);
                }

                //保存固定车流量和临时车流量
                fixVehicleFlowMap.put(statisBeginTime, (fixVehicleFlowMap.get(statisBeginTime)==null?0:fixVehicleFlowMap.get(statisBeginTime))+statisticDTO.getFixVehicleFlow());
                tmpVehicleFlowMap.put(statisBeginTime, (tmpVehicleFlowMap.get(statisBeginTime)==null?0:tmpVehicleFlowMap.get(statisBeginTime))+statisticDTO.getTmpVehicleFlow());
            }
		}
      //判断是否包含所有待查询的停车场信息
        if(request.getPlNos().size()>parkLotMap.size()){
        	for (String plNo:request.getPlNos()) {
        		if(!parkLotMap.containsKey(plNo)){
        			ParkingLotDTO parkingLotDTO=ParkingLotCacheUtil.getParkLotByPlNo(plNo);
        			parkNameMap.put(plNo, parkingLotDTO.getPlName());
        			parkLotMap.put(plNo, Maps.newHashMap());
        		}
        	}
        }
        //封装车位统计信息
        LineChartVO freeBerthRatios = new LineChartVO();
        List<String> freeBerthRatios_legendData = Lists.newArrayList();
        freeBerthRatios_legendData.addAll(parkNameMap.values());
        freeBerthRatios.setLegendData(freeBerthRatios_legendData);
        freeBerthRatios.setxAxisData(xAxisData);
        List<SerieVO> series = Lists.newArrayList();

        if (parkLotMap != null && !parkLotMap.isEmpty()) {
            for (Entry<String, Map<String, Double>> parkLotEntry : parkLotMap.entrySet()) {
                SerieVO serieVO = new SerieVO();
                //获取停车场名称
                String name = parkNameMap.get(parkLotEntry.getKey());
                serieVO.setName(name);
                //设置每个时间戳对应的空置率
                Map<String, Double> freeRatioMaps = parkLotEntry.getValue();
                //保存上一次的空置率，当某个时间点没有数据时，则保持和上次一致
                Integer lastFreeRatio = 0;
                List<Integer> freeRations = Lists.newArrayList();
                for (String timestamp : xAxisData) {
                    if (freeRatioMaps.containsKey(timestamp)) {
                        lastFreeRatio = freeRatioMaps.get(timestamp).intValue();
                    }else{
                    	lastFreeRatio = 0;
                    }
                    freeRations.add(lastFreeRatio);
                }
                serieVO.setData(freeRations);
                series.add(serieVO);
            }
        }
        freeBerthRatios.setSeries(series);

        //封装车流量统计
        LineChartVO vehicleFlows = new LineChartVO();
        List<String> vehicleFlows_legendData = Lists.newArrayList();
        vehicleFlows_legendData.add("临时车");
        vehicleFlows_legendData.add("固定车");
        vehicleFlows.setLegendData(vehicleFlows_legendData);
        vehicleFlows.setxAxisData(xAxisData);
        List<SerieVO> vehicleSeries = Lists.newArrayList();
        //固定车
        SerieVO fixSerieVo = new SerieVO();
        fixSerieVo.setName("固定车");
        List<Integer> fixSerieVoData = Lists.newArrayList();
        //临时车
        SerieVO tmpSerieVo = new SerieVO();
        tmpSerieVo.setName("临时车");
        List<Integer> tmpSerieVoData = Lists.newArrayList();
        //保存上一次的临时车值，当某个时间点没有数据时，则保持和上次一致
        Integer lastfixFlow = 0;
        Integer lasttmpFlow = 0;
        for (String timestamp : xAxisData) {
            if (fixVehicleFlowMap.containsKey(timestamp)) {
                lastfixFlow = fixVehicleFlowMap.get(timestamp).intValue();
            }else{
            	lastfixFlow = 0;
            }
            fixSerieVoData.add(lastfixFlow);

            if (tmpVehicleFlowMap.containsKey(timestamp)) {
                lasttmpFlow = tmpVehicleFlowMap.get(timestamp).intValue();
            }else{
            	lasttmpFlow = 0;
            }
            tmpSerieVoData.add(lasttmpFlow);
        }
        fixSerieVo.setData(fixSerieVoData);
        vehicleSeries.add(fixSerieVo);
        tmpSerieVo.setData(tmpSerieVoData);
        vehicleSeries.add(tmpSerieVo);

        vehicleFlows.setSeries(vehicleSeries);

        BerthsAndFlowLineChartVO chartVO = new BerthsAndFlowLineChartVO();
        chartVO.setFreeBerthRatios(freeBerthRatios);
        chartVO.setVehicleFlows(vehicleFlows);
        return new BizResultVO<BerthsAndFlowLineChartVO>().setData(chartVO);
    }

    //实时查询当前总车流量
    //	@MessageMapping("/realtimeGetCurVehicleFlow")
    //    @SendTo("/topic/curVehicleFlow")
    @ApiOperation("实时查询当前总车流量")
    @PostMapping("/realtimeGetCurVehicleFlow")
    public BizResultVO<Long> realtimeVehicleFlowByWebSocket(@RequestBody RealTimeVehicleFlowQueryRequest request) {
        BizResult<Long> bizResult = iInOutParkingService.QueryRealTimeVehicleFlow(request);
        return new BizResultVO<Long>(bizResult);
    }

    /**
     * 实时查询今日空置率<br>
     * 今日空置率：当天0:00到操作时间的每个时间戳的空置率做加权算法，<br>
     * 0:00-7:00加权10%，7:00-9:00加权40%，9:00-17:00加权15%，17:00-21:00加权25%,21:00-24:00加权10%，加权后的空置率之和除以时间戳数，得到“今日空置率”
     *
     * @return 2017年6月19日 zhaowg
     */
    //	@MessageMapping("/realtimeGetCurFreeRatio")
    //    @SendTo("/topic/curFreeRatio")
    @ApiOperation("实时查询今日空置率")
    @PostMapping("realtimeGetCurFreeRatio")
    public BizResultVO<String> realtimeFreeRatio(@RequestBody ParkingLotUseStatisticForPageRequest request) {
        //开始时间 今日0点开始
        Calendar beginTime = Calendar.getInstance();
        beginTime.set(Calendar.HOUR_OF_DAY, 0);
        beginTime.set(Calendar.MINUTE, 0);
        beginTime.set(Calendar.SECOND, 0);
        request.setBeginTime(beginTime.getTime());
        Calendar endTime = Calendar.getInstance();
        request.setEndTime(endTime.getTime());
        request.setQueryKind(ParkConstant.ParkingLotUseStatistic.StatisticType.PER20MINUTE);
        request.setBaseRequest(new BaseInfo(1, 0));//不分页;
        BizResult<PageBean<ParkingLotUseStatisticDTO>> bizResult = parkingLotStatisticService
            .queryParkingLotUseStatisticForPage(request);
        PageBean<ParkingLotUseStatisticDTO> pageBean = ResultUtils.getBizResultData(bizResult);
        if (pageBean == null || pageBean.getDataList() == null) {
            return new BizResultVO<String>().setData("0");
        }
        Double totalfreeRatio = 0.00;
        for (ParkingLotUseStatisticDTO statisticDTO : pageBean.getDataList()) {
            totalfreeRatio += this.weightForFreeRation(statisticDTO.getStatisticBeginTime(),
                statisticDTO.getFreeRatio(), statisticDTO.getPlNo());
        }
        logger.info("加权后的空置率之和：" + totalfreeRatio + " 时间戳个数：" + pageBean.getDataList().size());
        Double avgFreeRation = totalfreeRatio / pageBean.getDataList().size();
        String result = String.format("%.2f", avgFreeRation);
        return new BizResultVO<String>().setData(result);
    }

    /**
     * 根据时间段 给空置率加权<br>
     * 0:00-7:00加权10%，7:00-9:00加权40%，9:00-17:00加权15%，17:00-21:00加权25%,21:00-24:00加权10%，加权后的空置率之和除以时间戳数，得到“今日空置率”
     *
     * @param statisticBeginTime
     * @param freeRatio          2017年6月19日 zhaowg
     */
    private Double weightForFreeRation(Date statisticBeginTime, Double freeRatio, String plNo) {
        freeRatio = freeRatio * 100;//转换为百分比形式
        /*logger.info(
            "停车场编号：" + plNo + " 统计时间：" + DateUtil.getDateString(statisticBeginTime, DateUtil.DATETIME_FORMAT) + " 空置率："
                + freeRatio);*/
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(statisticBeginTime);
        int hour = calendar.get(Calendar.HOUR_OF_DAY);
        if (hour <= 7) {
            return freeRatio * 0.1;
        } else if (hour <= 9) {
            return freeRatio * 0.4;
        } else if (hour <= 17) {
            return freeRatio * 0.15;
        } else if (hour <= 21) {
            return freeRatio * 0.25;
        } else {
            return freeRatio * 0.1;
        }
    }

    public static void main(String[] args) {
        BigDecimal m = BigDecimal.ZERO;
        BigDecimal n = m.add(BigDecimal.TEN);
        System.out.println(new BigDecimal("00.0").doubleValue() == 0);
    }

}
