package com.zteits.irain.portal.web.parkinglotcloudplatform.datastatistic;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.config.authentication.UserServiceBeanDefinitionParser;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.fastjson.JSON;
import com.clouds.common.entity.UserInfo;
import com.clouds.common.utils.AmountUtils;
import com.clouds.common.utils.DateUtil;
import com.clouds.common.utils.ResultUtils;
import com.clouds.common.utils.excle.ExcelUtil;
import com.clouds.common.utils.excle.ExcleFillDateManager;
import com.clouds.common.utils.excle.Layouter;
import com.clouds.common.web.BizController;
import com.clouds.common.web.SessionCommUtil;
import com.clouds.common.web.vo.BizResultVO;
import com.clouds.common.web.vo.EasyUIDataGridVO;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.zteits.clouds.api.apibase.bean.BaseInfo;
import com.zteits.clouds.api.apibase.bean.BizResult;
import com.zteits.clouds.api.apibase.bean.PageBean;
import com.zteits.clouds.api.apibase.constants.ErrorType;
import com.zteits.clouds.api.apibase.exception.BizException;
import com.zteits.clouds.api.dto.clouds.dto.BillManageDTO;
import com.zteits.clouds.api.dto.park.dto.InOutParkDTO;
import com.zteits.clouds.api.dto.park.dto.ParkingLotUseStatisticDTO;
import com.zteits.clouds.api.dto.park.dto.ParkingLotUseStatisticSumDTO;
import com.zteits.clouds.api.dto.park.param.InOutParkRequest;
import com.zteits.clouds.api.dto.park.param.ParkingLotUseStatisticForPageRequest;
import com.zteits.clouds.api.dto.pay.param.TdCompanyParkQueryRequest;
import com.zteits.clouds.api.service.clouds.InOutParkStatisticService;
import com.zteits.clouds.api.service.park.ParkingLotUseStatisticService;
import com.zteits.clouds.api.service.pay.TdCustCompanyService;
import com.zteits.irain.portal.constant.ParkConstant;
import com.zteits.irain.portal.vo.parkinglotcloudplatform.datastatistic.LineChartVO;
import com.zteits.irain.portal.vo.parkinglotcloudplatform.datastatistic.LineChartVO.SerieVO;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * 企业云平台->数据统计->进出场上报。
 * 
 * Copyright: Copyright (c) 2017  zteits
 * 
 * @ClassName: InOutParkStatisticController.java
 * @Description: 
 * @version: v1.0.0
 * @author: langlw
 * @date: 2017年7月26日   上午11:30:04 
 * Modification History:
 * Date             Author          Version            Description
 *---------------------------------------------------------*
 * 2017年7月26日      langlw          v1.0.0               创建
 */
@Api(value = "企业云平台->数据统计->进出场上报数据统计", description = "企业云平台->数据统计->进出场上报数据统计")
@Controller
@RequestMapping(value = "/inOutParkStatistic")
public class InOutParkStatisticController extends BizController {
	private static final Logger logger = LoggerFactory.getLogger(InOutParkStatisticController.class);

	@Value("${project.syscode}")
	private String sysCode;
	@Autowired
	private ParkingLotUseStatisticService parkingLotStatisticService;
	@Autowired
	private InOutParkStatisticService inOutParkStatisticService;
	
	
	@ApiOperation("数据统计进出场上报")
	@PostMapping("queryInOutParkForList")
	@ResponseBody
	public BizResultVO<EasyUIDataGridVO<InOutParkDTO>> queryInOutParkForList(
			@RequestBody InOutParkRequest request) throws Exception {
		logger.info("调用DUBBO服务入参：" + JSON.toJSONString(request));
		if (null == request.getBeginTime() || null==request.getEndTime()) {
            throw new BizException(ErrorType.PARAMM_NULL, "开始时间和结束时间");
        }
		BizResult<PageBean<InOutParkDTO>> bizResult = inOutParkStatisticService.queryInOutParkForList(request);
		return returnJqGridData(bizResult, InOutParkDTO.class);
	}
	
	@ApiOperation("数据统计进出场上报折线图")
	@PostMapping("queryInOutParkForChart")
	@ResponseBody
	public BizResultVO<LineChartVO> queryInOutParkForChart(
			@RequestBody InOutParkRequest request) throws Exception {
		if (null == request.getBeginTime() || null==request.getEndTime() || null == request.getPlNos()) {
            throw new BizException(ErrorType.PARAMM_NULL, "开始时间和结束时间、停车场编号集合");
        }
		
		ParkingLotUseStatisticForPageRequest UseStatisticRequest=new ParkingLotUseStatisticForPageRequest();
		UseStatisticRequest.setPlNos(request.getPlNos());
		UseStatisticRequest.setBeginTime(request.getBeginTime());
		UseStatisticRequest.setEndTime(request.getEndTime());
		UseStatisticRequest.setBaseRequest(new BaseInfo(1, 0));
		UseStatisticRequest.setSysCode(sysCode);

		Calendar beginTime = Calendar.getInstance();
		beginTime.setTime(request.getBeginTime());

		Calendar endTime = Calendar.getInstance();
		endTime.setTime(request.getEndTime());

		Long dayDifference = DateUtil.getTimeDifference(new Timestamp(request.getEndTime().getTime()),
				new Timestamp(request.getBeginTime().getTime()));
		List<String> xAxisData = Lists.newArrayList();
		String dateType="";
		
		if (dayDifference == 0L) {
			//同一天
			// 20分钟为一个时间戳
			UseStatisticRequest.setQueryKind(ParkConstant.ParkingLotUseStatistic.StatisticType.PER20MINUTE);
			int totaltimestampCount = (endTime.get(Calendar.HOUR_OF_DAY)-beginTime.get(Calendar.HOUR_OF_DAY))*3;
			for (int i = 0; i < totaltimestampCount; i++) {
				int hour1 = beginTime.get(Calendar.HOUR_OF_DAY)+i/3;
				String hour = String.format("%02d", hour1);
				String minute = String.format("%02d", (i % 3) * 20);
				xAxisData.add(hour + ":" + minute);
			}
			dateType="HH:mm";
			LineChartVO vehicleFlows=getVehicleFlows(UseStatisticRequest, xAxisData, dateType);
			return new BizResultVO<LineChartVO>().setData(vehicleFlows);

		} else if (dayDifference <= 3L) {
			// 1小时为一个时间戳
			UseStatisticRequest.setQueryKind(ParkConstant.ParkingLotUseStatistic.StatisticType.PER1HOUR);
			int totaltimestampCount = endTime.get(Calendar.HOUR_OF_DAY);
			String day = "";
			String month = "";
			for (int i = 0; i < dayDifference.intValue(); i++) {
				int beginMonth = beginTime.get(Calendar.MONTH) + 1;
				int beginDay = beginTime.get(Calendar.DAY_OF_MONTH);
				month = String.format("%02d", (beginMonth));
				day = String.format("%02d", (beginDay));
				int endDay = endTime.get(Calendar.DAY_OF_MONTH);
				if(beginDay != endDay){
					totaltimestampCount = 24;
				}
				for (int j = 0; j < totaltimestampCount; j++) {
					String hour = String.format("%02d", (j));
					xAxisData.add(month + "-" + day + " " + hour);
				}
				beginTime.add(Calendar.DAY_OF_MONTH, 1);
			}
			dateType="MM-dd HH";
			LineChartVO vehicleFlows=getVehicleFlows(UseStatisticRequest, xAxisData, dateType);
			return new BizResultVO<LineChartVO>().setData(vehicleFlows);

		} else {
			// 1天为一个时间戳
			UseStatisticRequest.setQueryKind(ParkConstant.ParkingLotUseStatistic.StatisticType.PER1DAY);
			for (int i = 0; i < dayDifference.intValue()+1; i++) {
				int beginMonth = beginTime.get(Calendar.MONTH) + 1;
				int beginDay = beginTime.get(Calendar.DAY_OF_MONTH);
				String month = String.format("%02d", (beginMonth));
				String day = String.format("%02d", (beginDay));
				xAxisData.add(month + "-" + day);
				beginTime.add(Calendar.DAY_OF_MONTH, 1);

			}
			dateType="MM-dd";
			LineChartVO vehicleFlows=getVehicleFlows(UseStatisticRequest, xAxisData, dateType);
			return new BizResultVO<LineChartVO>().setData(vehicleFlows);

		}
	}

	
	/**
	 * 进出场折线图
	 * @param request
	 * @param xAxisData
	 * @param dateType
	 * @return
	 * 2017年7月28日 zhaowg
	 */
	private  LineChartVO  getVehicleFlows(ParkingLotUseStatisticForPageRequest request,
			List<String> xAxisData,String dateType){
		// 调用后场服务
		logger.info("调用DUBBO服务入参：" + JSON.toJSONString(request));
		BizResult<PageBean<ParkingLotUseStatisticDTO>> bizResult = parkingLotStatisticService
				.queryParkingLotUseStatisticForPage(request);
		PageBean<ParkingLotUseStatisticDTO> pageBean = ResultUtils.getBizResultData(bizResult);
		List<ParkingLotUseStatisticDTO> useStatisticDTOs = Lists.newArrayList();
		if (pageBean != null) {
			useStatisticDTOs = pageBean.getDataList();
		}

		// 保存进场次数，时间戳和进场次数对应关系
		Map<String, Integer> inParkMap = Maps.newHashMap();
		// 保存出场次数，时间戳和出场次数对应关系
		Map<String, Integer> outParkMap = Maps.newHashMap();
		// 停车场编号和名称对应关系
		Map<String, String> parkNameMap = Maps.newHashMap();
		if (!CollectionUtils.isEmpty(useStatisticDTOs)) {
			for (ParkingLotUseStatisticDTO statisticDTO : useStatisticDTOs) {
				String key = statisticDTO.getPlNo();
				parkNameMap.put(key, statisticDTO.getPlName());
				String statisBeginTime = DateUtil.getDateString(statisticDTO.getStatisticBeginTime(), dateType);
				//保存进场车流量和出场车流量
				inParkMap.put(statisBeginTime, (inParkMap.get(statisBeginTime)==null?0:inParkMap.get(statisBeginTime))+statisticDTO.getTmpVehicleFlow());
				outParkMap.put(statisBeginTime, (outParkMap.get(statisBeginTime)==null?0:outParkMap.get(statisBeginTime))+statisticDTO.getOutParkCount());
			}
		}

		// 封装进出场上报统计
		LineChartVO vehicleFlows = new LineChartVO();
		List<String> vehicleFlows_legendData = Lists.newArrayList();
		vehicleFlows_legendData.add("进场");
		vehicleFlows_legendData.add("出场");
		vehicleFlows.setLegendData(vehicleFlows_legendData);
		vehicleFlows.setxAxisData(xAxisData);
		List<SerieVO> vehicleSeries = Lists.newArrayList();
		// 进场
		SerieVO inParkSerieVo = new SerieVO();
		inParkSerieVo.setName("进场");
		List<Integer> inParkSerieVoData = Lists.newArrayList();
		// 出场
		SerieVO outParkSerieVo = new SerieVO();
		outParkSerieVo.setName("出场");
		List<Integer> outParkSerieVoData = Lists.newArrayList();
		// 保存上一次的进出场车值，当某个时间点没有数据时，则保持和上次一致
		Integer lastfixFlow = 0;
		Integer lasttmpFlow = 0;
		for (String timestamp : xAxisData) {

			if (inParkMap.containsKey(timestamp)) {
				lastfixFlow = inParkMap.get(timestamp).intValue();
			}else{
				lastfixFlow =0;
			}
			inParkSerieVoData.add(lastfixFlow);

			if (outParkMap.containsKey(timestamp)) {
				lasttmpFlow = outParkMap.get(timestamp).intValue();
			}else{
				lasttmpFlow = 0;
			}
			outParkSerieVoData.add(lasttmpFlow);
		}
		inParkSerieVo.setData(inParkSerieVoData);
		vehicleSeries.add(inParkSerieVo);
		outParkSerieVo.setData(outParkSerieVoData);
		vehicleSeries.add(outParkSerieVo);

		vehicleFlows.setSeries(vehicleSeries);
		return vehicleFlows;
	}
	
	
	
	@ApiOperation("导出进出场统计excel")
	@GetMapping("exportInOutParkStatisticExcel")
	public void exportInOutParkStatisticExcel(@RequestParam String beginTime, @RequestParam String endTime,
			@RequestParam List<String> plNos,@RequestParam String parkNames,
			Integer inOutStatus,Integer parkType,
			HttpServletRequest requests, HttpServletResponse response) throws Exception {
		ParkingLotUseStatisticForPageRequest request = new ParkingLotUseStatisticForPageRequest();
		request.setSysCode(sysCode);
		request.setBeginTime(DateUtil.to_date(beginTime, DateUtil.DATETIME_FORMAT));
		request.setEndTime(DateUtil.to_date(endTime, DateUtil.DATETIME_FORMAT));
		request.setPlNos(plNos);
		request.setBaseRequest(new BaseInfo(1, 0));
		request.setQueryKind(ParkConstant.ParkingLotUseStatistic.StatisticType.PER20MINUTE);
		BizResult<ParkingLotUseStatisticSumDTO> bizResultSum = parkingLotStatisticService.QueryInOutParkStatisticSum(request);
		
		InOutParkRequest inOutParkRequest =new InOutParkRequest();
		inOutParkRequest.setBaseRequest(new BaseInfo(1, 0));
		inOutParkRequest.setSysCode(sysCode);
		inOutParkRequest.setBeginTime(DateUtil.to_date(beginTime, DateUtil.DATETIME_FORMAT));
		inOutParkRequest.setEndTime(DateUtil.to_date(endTime, DateUtil.DATETIME_FORMAT));
		inOutParkRequest.setPlNos(plNos);
		inOutParkRequest.setInOutStatus(inOutStatus);
		inOutParkRequest.setParkType(parkType);
		BizResult<PageBean<InOutParkDTO>> bizResult = inOutParkStatisticService.queryInOutParkForList(inOutParkRequest);
		
		
		
		SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		SimpleDateFormat format2 = new SimpleDateFormat("yyyy-MM-dd");
		String[] title = new String[] { "停车场", "车牌号", "车辆类型", "进出场状态","进场时间","出场时间","停车时长" };
		String sheetName = "车辆进出场统计";
		String fileName = "车辆进出场统计" + format2.format(new Date());
		
		String[] billTitle = new String[8];
		if (bizResultSum != null && bizResultSum.getData() != null) {
			ParkingLotUseStatisticSumDTO dto = bizResultSum.getData();

			billTitle[0] = "车辆进出场统计";
			billTitle[1] = "汇总";
			billTitle[2] = "停车场:  " +parkNames;
			billTitle[3] = "进场时间:  " + beginTime;
			billTitle[4] = "出场时间:" + endTime;
			billTitle[5] = "进场车辆总数:  " + (dto.getInParkSum() != null ? dto.getInParkSum() : 0);
			billTitle[6] = "出场车辆总数:  " + (dto.getOutParkSum() != null ? dto.getOutParkSum() : 0);
			billTitle[7] = "具体明细";
		} else {
			billTitle[0] = "车辆进出场统计";
			billTitle[1] = "汇总";
			billTitle[2] = "停车场:";
			billTitle[3] = "进场时间:" ;
			billTitle[4] = "出场时间:" ;
			billTitle[5] = "进场车辆总数:";
			billTitle[6] = "出场车辆总数:";
			billTitle[7] = "具体明细";
		}
		
		
		
		
		// 1.创建excel信息
		XSSFSheet workSheet = ExcelUtil.createExcel(sheetName);
		// 2.设置excel表头和表体
		Layouter.buildReportBillForDay(workSheet, title, 0, 0, billTitle);
		// 3.填充数据
		List<Object[]> contentList = new ArrayList<Object[]>();
		List<InOutParkDTO> list = new ArrayList<>();
		if (CollectionUtils.isNotEmpty(bizResult.getData().getDataList())) {
			list = bizResult.getData().getDataList();
		}
		for (InOutParkDTO e : list) {
			Object[] obj = new Object[title.length];
			int index = 0;
			obj[index++] = e.getParkName();
			obj[index++] = e.getCarNumber();
			//TODO 
			if(null!=e.getParkType()){
				if(1==e.getParkType()){
					obj[index++] ="固定停车";
				}else{
					obj[index++] ="临时停车";
				}
			}else{
				obj[index++] ="临时停车";
			}
			
			if(null !=e.getInOutState()){
				if(1==e.getInOutState() || 2==e.getInOutState() || 3==e.getInOutState()){
					obj[index++] ="在场";
				}else{
					obj[index++] ="出场";
				}
			}else{
				obj[index++] ="出场";
			}
			obj[index++] = format.format(e.getInTime());
			obj[index++] = e.getOutTime() != null? format.format(e.getOutTime()) : "";
			obj[index++] = e.getParkingDuration() != null? DateUtil.secondToTime(e.getParkingDuration())  : "";
			contentList.add(obj);
		}
		ExcleFillDateManager fillUserManager = new ExcleFillDateManager();
		fillUserManager.fillSalesOrga(workSheet, title, contentList, 9);
		// 4.excel输出配置
		ExcelUtil.write(response, workSheet, fileName);
	}
	
}
