/**
 * 
 */
package com.zteits.irain.portal.web.parkinglotcloudplatform.datastatistic;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.alibaba.fastjson.JSON;
import com.clouds.common.cache.park.ParkingLotCacheUtil;
import com.clouds.common.redis.RedisCacheUtil;
import com.clouds.common.utils.DateUtil;
import com.clouds.common.utils.ResultUtils;
import com.clouds.common.utils.excle.ExcelUtil;
import com.clouds.common.utils.excle.ExcleFillDateManager;
import com.clouds.common.utils.excle.Layouter;
import com.clouds.common.web.BizController;
import com.clouds.common.web.vo.BizResultVO;
import com.clouds.common.web.vo.EasyUIDataGridVO;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.zteits.clouds.api.apibase.bean.BaseInfo;
import com.zteits.clouds.api.apibase.bean.BizResult;
import com.zteits.clouds.api.apibase.bean.PageBean;
import com.zteits.clouds.api.apibase.constants.ErrorType;
import com.zteits.clouds.api.apibase.exception.BizException;
import com.zteits.clouds.api.dto.park.dto.ParkingLotDTO;
import com.zteits.clouds.api.dto.park.dto.ParkingLotUseStatisticDTO;
import com.zteits.clouds.api.dto.park.dto.ParkingLotUseStatisticMaxAndMinDTO;
import com.zteits.clouds.api.dto.park.param.ParkingLotUseStatisticForPageRequest;
import com.zteits.clouds.api.service.park.ParkingLotUseStatisticService;
import com.zteits.irain.portal.constant.ParkConstant;
import com.zteits.irain.portal.vo.parkinglotcloudplatform.datastatistic.LineChartVO;
import com.zteits.irain.portal.vo.parkinglotcloudplatform.datastatistic.LineChartVO.SerieVO;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * @author hxz
 *
 */
@Api("停车场云平台 数据统计 车位使用管理")
@Controller
@RequestMapping("/parking")
public class BerthsStatisticController extends BizController {
	private static final Logger logger = LoggerFactory.getLogger(BerthsStatisticController.class);
	@Value("${project.syscode}")
	private String sysCode;
	@Autowired
	private ParkingLotUseStatisticService parkingLotStatisticService;

	/**
	 * 
	 * @param requestObject
	 * @return
	 */
	@ApiOperation("统计摘要")
	@PostMapping("getstatisticsummary")
	@ResponseBody
	public BizResultVO<ParkingLotUseStatisticMaxAndMinDTO> GetStatisticSummary(
			@RequestBody ParkingLotUseStatisticForPageRequest requestObject) {
		Calendar beginc = Calendar.getInstance();
		beginc.setTime(requestObject.getBeginTime());
		int beginYear = beginc.get(Calendar.YEAR);
		int beginMonth = beginc.get(Calendar.MONTH) + 1;
		int beginDay = beginc.get(Calendar.DAY_OF_MONTH);

		Calendar endc = Calendar.getInstance();
		endc.setTime(requestObject.getEndTime());
		int endYear = endc.get(Calendar.YEAR);
		int endMonth = endc.get(Calendar.MONTH) + 1;
		int endDay = endc.get(Calendar.DAY_OF_MONTH);

		if (beginYear == endYear && beginMonth == endMonth && beginDay == endDay) {
			// 2表示按每小时统计
			requestObject.setQueryKind(ParkConstant.ParkingLotUseStatistic.StatisticType.PER1HOUR);
		} else {
			// 3表示按每天统计
			requestObject.setQueryKind(ParkConstant.ParkingLotUseStatistic.StatisticType.PER1DAY);
		}
		BizResult<ParkingLotUseStatisticMaxAndMinDTO> respondObject = parkingLotStatisticService
				.QueryBerthUseStatisticMaxAndMin(requestObject);
		return new BizResultVO<>(respondObject);
	}

	@ApiOperation("获取车位使用情况统计列表")
	@PostMapping("getstatisticlist")
	@ResponseBody
	public BizResultVO<EasyUIDataGridVO<ParkingLotUseStatisticDTO>> GetParkingPlaceStatistic(
			@RequestBody ParkingLotUseStatisticForPageRequest requestObject)
			throws InstantiationException, IllegalAccessException {
		if (null == requestObject.getBeginTime() || null==requestObject.getEndTime()) {
            throw new BizException(ErrorType.PARAMM_NULL, "开始时间和结束时间");
        }
		
		Calendar beginc = Calendar.getInstance();
		beginc.setTime(requestObject.getBeginTime());
		int beginYear = beginc.get(Calendar.YEAR);
		int beginMonth = beginc.get(Calendar.MONTH) + 1;
		int beginDay = beginc.get(Calendar.DAY_OF_MONTH);

		Calendar endc = Calendar.getInstance();
		endc.setTime(requestObject.getEndTime());
		int endYear = endc.get(Calendar.YEAR);
		int endMonth = endc.get(Calendar.MONTH) + 1;
		int endDay = endc.get(Calendar.DAY_OF_MONTH);

		if (beginYear == endYear && beginMonth == endMonth && beginDay == endDay) {
			// 2表示按每小时统计
			requestObject.setQueryKind(ParkConstant.ParkingLotUseStatistic.StatisticType.PER1HOUR);
		} else {
			// 3表示按每天统计
			requestObject.setQueryKind(ParkConstant.ParkingLotUseStatistic.StatisticType.PER1DAY);
		}
		BizResult<PageBean<ParkingLotUseStatisticDTO>> respondObject = parkingLotStatisticService
				.queryParkingLotUseStatisticForPage(requestObject);
		return returnJqGridData(respondObject, ParkingLotUseStatisticDTO.class);
	}

	@ApiOperation("导出车流量数据统计excel")
	@GetMapping("exportBerthStatisticExcel")
	public void excelParkingLotUseStatistic(@RequestParam String beginTime, @RequestParam String endTime,
			@RequestParam String plNos, HttpServletRequest requests, HttpServletResponse response) {
		ParkingLotUseStatisticForPageRequest request = new ParkingLotUseStatisticForPageRequest();
		request.setSysCode(sysCode);
		request.setBeginTime(DateUtil.to_date(beginTime, DateUtil.DATETIME_FORMAT));
		request.setEndTime(DateUtil.to_date(endTime, DateUtil.DATETIME_FORMAT));
		List<String> plNoslist = new ArrayList<>();
		plNoslist.add(plNos);
		request.setPlNos(plNoslist);
		request.setBaseRequest(new BaseInfo(1, 0));
		
		Calendar beginc = Calendar.getInstance();
		beginc.setTime(request.getBeginTime());
		int beginYear = beginc.get(Calendar.YEAR);
		int beginMonth = beginc.get(Calendar.MONTH) + 1;
		int beginDay = beginc.get(Calendar.DAY_OF_MONTH);

		Calendar endc = Calendar.getInstance();
		endc.setTime(request.getEndTime());
		int endYear = endc.get(Calendar.YEAR);
		int endMonth = endc.get(Calendar.MONTH) + 1;
		int endDay = endc.get(Calendar.DAY_OF_MONTH);

		if (beginYear == endYear && beginMonth == endMonth && beginDay == endDay) {
			// 2表示按每小时统计
			request.setQueryKind(ParkConstant.ParkingLotUseStatistic.StatisticType.PER1HOUR);
		} else {
			// 3表示按每天统计
			request.setQueryKind(ParkConstant.ParkingLotUseStatistic.StatisticType.PER1DAY);
		}
		BizResult<PageBean<ParkingLotUseStatisticDTO>> bizResult = parkingLotStatisticService
				.queryParkingLotUseStatisticForPage(request);
		SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		SimpleDateFormat format2 = new SimpleDateFormat("yyyy-MM-dd");
		String[] title = new String[] { "时间", "空置率", "周转率" };
		String sheetName = "车位管理";
		String fileName = "车位管理" + format2.format(new Date());
		// 1.创建excel信息
		XSSFSheet workSheet = ExcelUtil.createExcel(sheetName);
		// 2.设置excel表头和表体
		Layouter.buildReport(workSheet, title, 0, 0);
		// 3.填充数据
		List<Object[]> contentList = new ArrayList<Object[]>();
		List<ParkingLotUseStatisticDTO> list = new ArrayList<>();
		if (CollectionUtils.isNotEmpty(bizResult.getData().getDataList())) {
			list = bizResult.getData().getDataList();
		}
		for (ParkingLotUseStatisticDTO e : list) {
			Object[] obj = new Object[title.length];
			int index = 0;
			obj[index++] = format.format(e.getStatisticBeginTime());
			obj[index++] = e.getFreeRatio() *100 +"%";
			obj[index++] = e.getTurnoverRatio();
			contentList.add(obj);
		}
		ExcleFillDateManager fillUserManager = new ExcleFillDateManager();
		fillUserManager.fillSalesOrga(workSheet, title, contentList, 2);
		// 4.excel输出配置
		ExcelUtil.write(response, workSheet, fileName);
	}

	/**
	 * 根据时间获取车位空置率折线图
	 *
	 * @param request
	 * @return
	 */
	@ApiOperation("根据时间获取车位空置率折线图")
	@PostMapping("getFreeRatioBerthForLineChart")
	@ResponseBody
	public BizResultVO<LineChartVO> getFreeRatioBerthForLineChart(
			@RequestBody ParkingLotUseStatisticForPageRequest request) {
		//根据权限获取停车场列表
		if (null == request.getBeginTime() || null==request.getEndTime()) {
            throw new BizException(ErrorType.PARAMM_NULL, "开始时间和结束时间");
        }
		logger.info("根据停车场编号获取该停车场车位空置率折线图");
		Calendar beginTime = Calendar.getInstance();
		beginTime.setTime(request.getBeginTime());

		Calendar endTime = Calendar.getInstance();
		endTime.setTime(request.getEndTime());

		Long dayDifference = DateUtil.getTimeDifference(new Timestamp(request.getEndTime().getTime()),
				new Timestamp(request.getBeginTime().getTime()));
		List<String> xAxisData = Lists.newArrayList();
		String dateType="";
		int berthRatio=ParkConstant.ParkingLotUseStatistic.BerthRatioType.FREE;
		if (dayDifference == 0L) {
			// 1个小时为一个时间戳
			request.setQueryKind(ParkConstant.ParkingLotUseStatistic.StatisticType.PER1HOUR);
			int totaltimestampCount = endTime.get(Calendar.HOUR_OF_DAY);
			for (int i = 0; i <= totaltimestampCount; i++) {
				String hour = String.format("%02d", i);
				xAxisData.add(hour + ":" + "00");
			}
			request.setBaseRequest(new BaseInfo(1, 0));
			dateType="HH:mm";
			LineChartVO freeBerthRatios=getFreeBerthRatios(request, xAxisData, dateType,berthRatio);
			return new BizResultVO<LineChartVO>().setData(freeBerthRatios);
		} else if (dayDifference <= 3L) {
			// 1小时为一个时间戳
			request.setQueryKind(ParkConstant.ParkingLotUseStatistic.StatisticType.PER1HOUR);
			int totaltimestampCount = endTime.get(Calendar.HOUR_OF_DAY);
			String day = "";
			String month = "";
			for (int i = 0; i < dayDifference.intValue(); i++) {
				beginTime.add(Calendar.DAY_OF_MONTH, 1);
				int beginMonth = beginTime.get(Calendar.MONTH) + 1;
				int beginDay = beginTime.get(Calendar.DAY_OF_MONTH);
				month = String.format("%02d", (beginMonth));
				day = String.format("%02d", (beginDay));
				for (int j = 0; j < totaltimestampCount; j++) {
					String hour = String.format("%02d", (j));
					xAxisData.add(month + "-" + day + " " + hour);
				}
			}
			request.setBaseRequest(new BaseInfo(1, 0));
			dateType="MM-dd HH";
			LineChartVO freeBerthRatios=getFreeBerthRatios(request, xAxisData, dateType,berthRatio);
			return new BizResultVO<LineChartVO>().setData(freeBerthRatios);
		} else {
			// 1天为一个时间戳
			request.setQueryKind(ParkConstant.ParkingLotUseStatistic.StatisticType.PER1DAY);
			for (int i = 0; i < dayDifference.intValue(); i++) {
				beginTime.add(Calendar.DAY_OF_MONTH, 1);
				int beginMonth = beginTime.get(Calendar.MONTH) + 1;
				int beginDay = beginTime.get(Calendar.DAY_OF_MONTH);
				String month = String.format("%02d", (beginMonth));
				String day = String.format("%02d", (beginDay));
				xAxisData.add(month + "-" + day);
			}
		}
		request.setBaseRequest(new BaseInfo(1, 0));
		dateType="MM-dd";
		LineChartVO freeBerthRatios=getFreeBerthRatios(request, xAxisData, dateType,berthRatio);
		return new BizResultVO<LineChartVO>().setData(freeBerthRatios);

	}

	/**
	 * 根据时间获取车位周转率折线图
	 *
	 * @param request
	 * @return
	 */
	@ApiOperation("根据时间获取车位周转率折线图")
	@PostMapping("getTurnOverBerthForLineChart")
	@ResponseBody
	public BizResultVO<LineChartVO> getTurnOverBerthForLineChart(
			@RequestBody ParkingLotUseStatisticForPageRequest request) {

		logger.info("根据停车场编号获取该停车场车位周转率折线图");
		if (null == request.getBeginTime() || null==request.getEndTime()) {
            throw new BizException(ErrorType.PARAMM_NULL, "开始时间和结束时间");
        }
		Calendar beginTime = Calendar.getInstance();
		beginTime.setTime(request.getBeginTime());

		Calendar endTime = Calendar.getInstance();
		endTime.setTime(request.getEndTime());

		Long dayDifference = DateUtil.getTimeDifference(new Timestamp(request.getEndTime().getTime()),
				new Timestamp(request.getBeginTime().getTime()));
		List<String> xAxisData = Lists.newArrayList();
		String dateType="";
		int berthRatio=ParkConstant.ParkingLotUseStatistic.BerthRatioType.TURNOVER;
		if (dayDifference == 0L) {
			//1个小时为一个时间戳
			request.setQueryKind(ParkConstant.ParkingLotUseStatistic.StatisticType.PER1HOUR);
			int totaltimestampCount = endTime.get(Calendar.HOUR_OF_DAY);
			for (int j = 0; j <= totaltimestampCount; j++) {
				String hour = String.format("%02d", (j));
				xAxisData.add(hour + ":" + "00");
			}
			
			request.setBaseRequest(new BaseInfo(1, 0));
			dateType="HH:mm";
			LineChartVO freeBerthRatios=getFreeBerthRatios(request, xAxisData, dateType,berthRatio);
			return new BizResultVO<LineChartVO>().setData(freeBerthRatios);
		} else if (dayDifference <= 3L) {
			// 1小时为一个时间戳
			request.setQueryKind(ParkConstant.ParkingLotUseStatistic.StatisticType.PER1HOUR);
			int totaltimestampCount = endTime.get(Calendar.HOUR_OF_DAY);
			String day = "";
			String month = "";
			for (int i = 0; i < dayDifference.intValue(); i++) {
				beginTime.add(Calendar.DAY_OF_MONTH, 1);
				int beginMonth = beginTime.get(Calendar.MONTH) + 1;
				int beginDay = beginTime.get(Calendar.DAY_OF_MONTH);
				month = String.format("%02d", (beginMonth));
				day = String.format("%02d", (beginDay));
				for (int j = 0; j < totaltimestampCount; j++) {
					String hour = String.format("%02d", (j));
					xAxisData.add(month + "-" + day + " " + hour);
				}
			}
			request.setBaseRequest(new BaseInfo(1, 0));
			dateType="MM-dd HH";
			LineChartVO freeBerthRatios=getFreeBerthRatios(request, xAxisData, dateType,berthRatio);
			return new BizResultVO<LineChartVO>().setData(freeBerthRatios);
		} else {
			// 1天为一个时间戳
			request.setQueryKind(ParkConstant.ParkingLotUseStatistic.StatisticType.PER1DAY);
			for (int i = 0; i < dayDifference.intValue(); i++) {
				beginTime.add(Calendar.DAY_OF_MONTH, 1);
				int beginMonth = beginTime.get(Calendar.MONTH) + 1;
				int beginDay = beginTime.get(Calendar.DAY_OF_MONTH);
				String month = String.format("%02d", (beginMonth));
				String day = String.format("%02d", (beginDay));
				xAxisData.add(month + "-" + day);
			}
			request.setBaseRequest(new BaseInfo(1, 0));
			dateType="MM-dd";
			LineChartVO freeBerthRatios=getFreeBerthRatios(request, xAxisData, dateType,berthRatio);
			return new BizResultVO<LineChartVO>().setData(freeBerthRatios);
		}

	}
	
	
	private LineChartVO getFreeBerthRatios(ParkingLotUseStatisticForPageRequest request,
			List<String> xAxisData,String dateType ,int berthRatio){
		logger.info("调用DUBBO服务入参：" + JSON.toJSONString(request));
		BizResult<PageBean<ParkingLotUseStatisticDTO>> bizResult = parkingLotStatisticService
				.queryParkingLotUseStatisticForPage(request);
		PageBean<ParkingLotUseStatisticDTO> pageBean = ResultUtils.getBizResultData(bizResult);
		List<ParkingLotUseStatisticDTO> useStatisticDTOs = Lists.newArrayList();
		if (pageBean != null) {
			useStatisticDTOs = pageBean.getDataList();
		}

		// 停车场编号和名称对应关系
		Map<String, String> parkNameMap = Maps.newHashMap();
		// 通过停车场,和统计时间分组
		Map<String, Map<String, Double>> parkLotMap = Maps.newHashMap();
		if (!CollectionUtils.isEmpty(useStatisticDTOs)) {
			for (ParkingLotUseStatisticDTO statisticDTO : useStatisticDTOs) {
				String key = statisticDTO.getPlNo();
				parkNameMap.put(key, statisticDTO.getPlName());
				String statisBeginTime = DateUtil.getDateString(statisticDTO.getStatisticBeginTime(), dateType);
				// 保存空置率
				if (!parkLotMap.containsKey(key)) {
					Map<String, Double> timeAndVal = Maps.newHashMap();
					if(ParkConstant.ParkingLotUseStatistic.BerthRatioType.FREE == berthRatio){
						timeAndVal.put(statisBeginTime, statisticDTO.getFreeRatio() * 100);
						parkLotMap.put(key, timeAndVal);
					}else if(ParkConstant.ParkingLotUseStatistic.BerthRatioType.TURNOVER == berthRatio){
						timeAndVal.put(statisBeginTime, statisticDTO.getTurnoverRatio() * 100);
						parkLotMap.put(key, timeAndVal);
					}
				} else {
					if(ParkConstant.ParkingLotUseStatistic.BerthRatioType.FREE == berthRatio){
						parkLotMap.get(key).put(statisBeginTime, statisticDTO.getFreeRatio() * 100);
					}else if(ParkConstant.ParkingLotUseStatistic.BerthRatioType.TURNOVER == berthRatio){
						parkLotMap.get(key).put(statisBeginTime, statisticDTO.getTurnoverRatio() * 100);
					}
				}

			}
		}
		//判断是否包含所有待查询的停车场信息
        if(request.getPlNos().size()>parkLotMap.size()){
        	for (String plNo:request.getPlNos()) {
        		if(!parkLotMap.containsKey(plNo)){
        			ParkingLotDTO parkingLotDTO=ParkingLotCacheUtil.getParkLotByPlNo(plNo);
        			parkNameMap.put(plNo, parkingLotDTO.getPlName());
        			parkLotMap.put(plNo, Maps.newHashMap());
        		}
        	}
        }

		// 封装车位统计信息
		LineChartVO freeBerthRatios = new LineChartVO();
		List<String> freeBerthRatios_legendData = Lists.newArrayList();
		freeBerthRatios_legendData.addAll(parkNameMap.values());
		freeBerthRatios.setLegendData(freeBerthRatios_legendData);
		freeBerthRatios.setxAxisData(xAxisData);
		List<SerieVO> series = Lists.newArrayList();

		if (parkLotMap != null && !parkLotMap.isEmpty()) {
			for (Entry<String, Map<String, Double>> parkLotEntry : parkLotMap.entrySet()) {
				SerieVO serieVO = new SerieVO();
				// 获取停车场名称
				String name = parkNameMap.get(parkLotEntry.getKey());
				serieVO.setName(name);
				// 设置每个时间戳对应的空置率
				Map<String, Double> freeRatioMaps = parkLotEntry.getValue();
				// 保存上一次的空置率，当某个时间点没有数据时，则保持和上次一致
				Integer lastFreeRatio = 0;
				List<Integer> freeRations = Lists.newArrayList();
				for (String timestamp : xAxisData) {
					if (freeRatioMaps.containsKey(timestamp)) {
						lastFreeRatio = freeRatioMaps.get(timestamp).intValue();
					}else{
						lastFreeRatio = 0;
					}
					freeRations.add(lastFreeRatio);
				}
				serieVO.setData(freeRations);
				series.add(serieVO);
			}
		}
		freeBerthRatios.setSeries(series);
		return freeBerthRatios;
	}

}
