package com.zteits.irain.portal.web.mobile;

import java.util.List;

import javax.validation.Valid;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSON;
import com.clouds.common.cache.park.ParkFreeBerthsCacheUtil;
import com.clouds.common.cache.park.ParkingLotGeoCacheUtil;
import com.google.common.collect.Lists;
import com.zteits.clouds.api.apibase.bean.BaseInfo;
import com.zteits.clouds.api.apibase.constants.LonLatTypeEnum;
import com.zteits.clouds.api.dto.park.dto.ParkinglotAndGeoInfoDTO;
import com.zteits.clouds.api.dto.park.param.GetParkLotRequest;
import com.zteits.clouds.api.service.park.ParkingLotQueryService;
import com.zteits.irain.portal.vo.mobile.BizResultMobileVO;
import com.zteits.irain.portal.vo.mobile.ParkingspotVO;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
/**
 * 停车场信息查询
 * 
 * Copyright: Copyright (c) 2017  zteits
 * 
 * @ClassName: ParkingLotController.java
 * @Description: 
 * @version: v1.0.0
 * @author: zhaowg
 * @date: 2017年6月6日   上午11:31:10 
 * Modification History: 
 * Date             Author          Version            Description
 *---------------------------------------------------------*
 * 2017年6月6日      zhaowg              v1.0.0               创建
 */
@Api(value = "停车场信息查询",description="停车场信息查询")
@RestController
@RequestMapping("/parklot")
public class ParkLotController {
	
	@Value("${project.syscode}")
	private String sysCode;
	
	private static final Logger logger = LoggerFactory.getLogger(ParkLotController.class);
	
	@Autowired
	private ParkingLotQueryService tabParkingLotService;
	
	@ApiOperation("查询停车场信息")
	@PostMapping("queryParkingLots")
	public BizResultMobileVO<List<ParkingspotVO>> queryParkingLots(@Valid @RequestBody GetParkLotRequest request){
		if(request.getBaseRequest()==null){
			request.setBaseRequest(new BaseInfo());
		}
		logger.info("["+request.getBaseRequest().getRequestId()+"]开始调用查询停车场信息："+JSON.toJSONString(request));
		List<ParkinglotAndGeoInfoDTO> dtos = Lists.newArrayList();
		if(request.getType().equals(GetParkLotRequest.TYPE_RECORD_COUNT)){
			dtos = ParkingLotGeoCacheUtil.queryParkLotsWithDistanceAndCoordinateByCountAsc
					(LonLatTypeEnum.LON_LAT_TYPE_3,Double.valueOf(request.getLongitude()), Double.valueOf(request.getLatitude()), Long.valueOf(request.getLimit()));
		}else if(request.getType().equals(GetParkLotRequest.TYPE_DISTANCE)){
			dtos = ParkingLotGeoCacheUtil.queryParkLotsWithDistanceAndCoordinateByAsc
					(LonLatTypeEnum.LON_LAT_TYPE_3,Double.valueOf(request.getLongitude()), Double.valueOf(request.getLatitude()), Double.valueOf(request.getLimit()), null);
		}
		List<ParkingspotVO> vos = Lists.newArrayList();
		if(!CollectionUtils.isEmpty(dtos)){
			for (ParkinglotAndGeoInfoDTO dto : dtos) {
				ParkingspotVO vo = new ParkingspotVO();
				vo.setAddress(dto.getPlAddress());
				vo.setChargeDetail(dto.getPlRate()==null?new String[]{}:dto.getPlRate().split("#"));
				vo.setDescription("");
				vo.setDistance(dto.getDistance());
				//获取空闲车位数
				Integer idleberths = ParkFreeBerthsCacheUtil.getFreeBerthsByPlNo(dto.getPlNo());
				vo.setIdleberths(idleberths);
				vo.setLatitude(dto.getLatId().doubleValue());
				vo.setLongitude(dto.getLonId().doubleValue());
				vo.setName(dto.getPlName());
				vo.setPhone(dto.getServiceTel());
				vo.setPklNo(dto.getPlNo());
				vo.setRatedescription("");
				vo.setTotalberths(dto.getPlBerthNum());
				vo.setType(dto.getPlType());
				vos.add(vo);
			}
		}
		BizResultMobileVO<List<ParkingspotVO>> bizResultVO = new BizResultMobileVO<List<ParkingspotVO>>();
		bizResultVO.setCode("0");
		bizResultVO.setSuccessful("true");
		bizResultVO.setTotal(vos.size()+"");
		bizResultVO.setData(vos);
		logger.info("["+request.getBaseRequest().getRequestId()+"]调用查询停车场信息成功："+JSON.toJSONString(bizResultVO));
		return bizResultVO;
	}
	
}
