package com.zteits.irain.portal.web.irain;

import java.util.List;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSONObject;
import com.clouds.common.cache.park.ParkingLotCacheUtil;
import com.clouds.common.cache.sys.SysCodeValueCacheUtil;
import com.clouds.common.constants.CodeValKindEnum;
import com.clouds.common.utils.ResultUtils;
import com.clouds.common.web.vo.BizResultVO;
import com.google.common.collect.Lists;
import com.zteits.clouds.api.apibase.bean.BizResult;
import com.zteits.clouds.api.apibase.constants.ErrorType;
import com.zteits.clouds.api.apibase.exception.BizException;
import com.zteits.clouds.api.dto.park.dto.ParkingLotDTO;
import com.zteits.clouds.api.dto.park.param.QueryParkLotInfoByPkOutNoRequest;
import com.zteits.clouds.api.dto.park.param.StatisticParkLotCountByCountryRequest;
import com.zteits.clouds.api.dto.park.param.UpdateFreeBerthRequest;
import com.zteits.clouds.api.service.park.ParkingLotQueryService;
import com.zteits.irain.portal.service.interfaces.parklotidleberths.ParkLotIdleBerthsService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
/**
 * 更新空闲车位
 * 被SQL触发器调用
 * Copyright: Copyright (c) 2017  zteits
 * 
 * @ClassName: UpdateFreeBerthController.java
 * @Description: 
 * @version: v1.0.0
 * @author: langlw
 * @date: 2017年7月18日   上午9:44:36 
 * Modification History:
 * Date             Author          Version            Description
 *---------------------------------------------------------*
 * 2017年7月18日      langlw          v1.0.0               创建
 */
@RestController
@Api(value="更新空闲车位",description="更新空闲车位")
@RequestMapping("/freeBerth")
public class UpdateFreeBerthController {
	private static final Logger logger = LoggerFactory.getLogger(UpdateFreeBerthController.class);
	
	@Value("${project.syscode}")
	private String sysCode;
	@Autowired
	private ParkLotIdleBerthsService parkLotIdleBerthsService;
	@Autowired
	private ParkingLotQueryService parkingLotQueryService;
	
	
	@ApiOperation("更新空闲车位总数")
	@GetMapping("updateFreeBerth")
	public BizResultVO<Boolean> getDisplayCountry(@RequestParam String plOutNo,
			@RequestParam Integer fromType,@RequestParam String freeBerth){
		//通过上报停车场编号查询对应的自己内部停车场编号
		logger.info("根据上报的停车场编号["+plOutNo+"]在缓存总没有查询到对应的停车场信息，开始查询数据库");
		QueryParkLotInfoByPkOutNoRequest request = new QueryParkLotInfoByPkOutNoRequest();
		request.setSysCode(sysCode);
		request.setPklOutNo(plOutNo);
		BizResult<ParkingLotDTO> bizResult = parkingLotQueryService.QueryParkingLotByPkOutNo(request );
		ParkingLotDTO parkingLotDTO = ResultUtils.getBizResultData(bizResult);
		String plNo = parkingLotDTO.getPlNo();
		//更新空闲车位数
		UpdateFreeBerthRequest updaterequest=new UpdateFreeBerthRequest();
		updaterequest.setFreeBerths(Integer.valueOf(freeBerth));
		updaterequest.setPlNo(plNo);
		updaterequest.setFromType(fromType);
		updaterequest.setSysCode(sysCode);
		logger.info("请求参数:"+JSONObject.toJSONString(request));
		int freeBerths = parkLotIdleBerthsService.updateAndGetIdleBerthByParkNo(updaterequest.getInoutTime(), updaterequest.getPlNo(), updaterequest.getType(), updaterequest.getFromType(), updaterequest.getFreeBerths());
		logger.info("调用后场服务:更新车位总数", freeBerths);
		return new BizResultVO<Boolean>().setData(true);
	}
	
	
}
