package com.zteits.irain.portal.web.irain;

import java.util.HashMap;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSONObject;
import com.clouds.common.utils.MD5Utils;
import com.zteits.irain.portal.common.HttpClientTutorial;

/**
 * 
 * Copyright: Copyright (c) 2017 ZTE-ITS
 * 
 * @ClassName: IRainQueryController.java
 * @Description: 查询艾润 控制器
 * @version: v1.0.0
 * @author: wangbiao
 * @date: 2017年4月20日 上午11:51:45 Modification History: Date Author Version
 *        Description ---------------------------------------------------------*
 *        2017年4月20日 wangbiao v1.0.0 创建
 */
@RestController
@RequestMapping("/query")
public class IRainQueryController {
	@Value("${irain.url}")
	private String irain_ur;
	@Value("${irain.appid}")
	private String irain_appid;
	@Value("${irain.appsecret}")
	private String irain_appsecret;
	@Value("${irain.park_code}")
	private String park_code;
	
	
	private static final Logger logger = LoggerFactory.getLogger(IRainQueryController.class);

	/**
	 * 订单支付  中兴智能交通——>艾润
	 * 
	 * @param param  (aes加密后的JSON字符串)
	 */
	 @RequestMapping(value = "/billQuery", method = RequestMethod.POST) 
	public String billQuery(String param) {
		/****  以下为模拟入参    实际入参 由app提供-------------------------------------*/
		
	    Long time = System.currentTimeMillis();
		String md5  = MD5Utils.enMD5(irain_appid+irain_appsecret+time);
		Map<String, Object> params = new HashMap<>();
		params.put("appid", irain_appid);
		params.put("sign", md5);
		params.put("timestamp", time);
		params.put("vpl_number", "蒙AS4321");
		params.put("park_code", "2a94dbdfb232b39f1a1309a13fa11e28");
		String rs  = "";
		try {
			logger.info("irain 查询停车费用入参:" + JSONObject.toJSONString(params));
			 rs = HttpClientTutorial.httpPostRequest(irain_ur+"/bill/Query", params);
			logger.info("irain 查询停车费用返回:" + JSONObject.toJSONString(rs));
		} catch (Exception e) {
			logger.info("irain 查询停车费用出错:" + e);
		}
		return JSONObject.toJSONString(rs);
	}
	 
	 @RequestMapping(value = "/test_billQuery", method = RequestMethod.POST) 
	public String testBillQuery(String vpl_number) {
		/****  以下为模拟入参    实际入参 由app提供-------------------------------------*/
		
	    Long time = System.currentTimeMillis();
		String md5  = MD5Utils.enMD5(irain_appid+irain_appsecret+time);
		Map<String, Object> params = new HashMap<>();
		params.put("appid", irain_appid);
		params.put("sign", md5);
		params.put("timestamp", time);
		params.put("vpl_number", vpl_number);
		params.put("park_code", park_code);
		String rs  = "";
		try {
			logger.info("irain 查询停车费用入参:" + JSONObject.toJSONString(params));
			 rs = HttpClientTutorial.httpPostRequest(irain_ur+"/bill/Query", params);
			logger.info("irain 查询停车费用返回:" + JSONObject.toJSONString(rs));
		} catch (Exception e) {
			logger.info("irain 查询停车费用出错:" + e);
		}
		return JSONObject.toJSONString(rs);
	}

}
