package com.zteits.irain.portal.web.irain;

import java.util.HashMap;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSONObject;
import com.clouds.common.utils.MD5Utils;
import com.zteits.irain.portal.common.HttpClientTutorial;

/**
 * 
 * Copyright: Copyright (c) 2017 ZTE-ITS
 * 
 * @ClassName: IRainPayController.java
 * @Description: 支付订单 同步给 艾润
 * @version: v1.0.0
 * @author: wangbiao
 * @date: 2017年4月20日 上午11:51:45 Modification History: Date Author Version
 *        Description ---------------------------------------------------------*
 *        2017年4月20日 wangbiao v1.0.0 创建
 */
@RestController
@RequestMapping("/pay")
public class IRainPayController {
	@Value("${irain.url}")
	private String irain_ur;
	@Value("${irain.appid}")
	private String irain_appid;
	@Value("${irain.appsecret}")
	private String irain_appsecret;
	@Value("${irain.park_code}")
	private String park_code;
	
	private static final Logger logger = LoggerFactory.getLogger(IRainPayController.class);

	/**
	 * 订单支付  中兴智能交通——>艾润
	 * 
	 * @param param  (aes加密后的JSON字符串)
	 */
	@RequestMapping(value  = "/issued",method = RequestMethod.POST)
	public String issued() {
		/****  以下为模拟入参    实际入参 由app提供-------------------------------------*/
		 Long time = System.currentTimeMillis();
			String md5  = MD5Utils.enMD5(irain_appid+irain_appsecret+time);
			Map<String, Object> params = new HashMap<>();
			params.put("appid", irain_appid);
			params.put("sign", md5);
			params.put("timestamp", time);
			params.put("vpl_number", "蒙AS4321");
			params.put("park_code", "734861a1e8656ffa51bdd90829941ca9");
			params.put("amount", 10000);
			String rs="";
		try {
			logger.info("irain 支付订单入参:" + JSONObject.toJSONString(params));
			rs = HttpClientTutorial.httpPostRequest(irain_ur+"/pay/Issued", params);
			logger.info("irain 支付订单返回:" + JSONObject.toJSONString(rs));
		} catch (Exception e) {
			logger.info("irain 支付订单出错:" + e);
		}
		return JSONObject.toJSONString(rs);
	}
	
	@RequestMapping(value  = "/test_issued",method = RequestMethod.POST)
	public String test_issued(String vpl_number,Integer amount) {
		/****  以下为模拟入参    实际入参 由app提供-------------------------------------*/
		 Long time = System.currentTimeMillis();
			String md5  = MD5Utils.enMD5(irain_appid+irain_appsecret+time);
			Map<String, Object> params = new HashMap<>();
			params.put("appid", irain_appid);
			params.put("sign", md5);
			params.put("timestamp", time);
			params.put("vpl_number", vpl_number);
			params.put("park_code", park_code);
			params.put("amount", amount);
			String rs="";
		try {
			logger.info("irain 支付订单入参:" + JSONObject.toJSONString(params));
			rs = HttpClientTutorial.httpPostRequest(irain_ur+"/pay/Issued", params);
			logger.info("irain 支付订单返回:" + JSONObject.toJSONString(rs));
		} catch (Exception e) {
			logger.info("irain 支付订单出错:" + e);
		}
		return JSONObject.toJSONString(rs);
	}

}
