package com.zteits.irain.portal.web.irain;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.clouds.common.utils.ExceptionUtil;
import com.clouds.common.web.BizController;
import com.zteits.clouds.api.apibase.bean.BaseInfo;
import com.zteits.clouds.api.apibase.constants.ErrorType;
import com.zteits.clouds.api.apibase.exception.BizException;
import com.zteits.clouds.api.dto.park.param.InParkingRequest;
import com.zteits.clouds.api.dto.park.param.OutParkingRequest;
import com.zteits.clouds.api.dto.park.param.InterfaceLogSaveRequest;
import com.zteits.clouds.api.service.park.InterfaceLogService;
import com.zteits.irain.portal.common.AESPlus;
import com.zteits.irain.portal.common.HttpClientTutorial;
import com.zteits.irain.portal.constant.IRainResultEnum;
import com.zteits.irain.portal.constant.ParkConstant.InterfaceLog;
import com.zteits.irain.portal.service.interfaces.inoutparklot.InOutParkLotReportService;
import com.zteits.irain.portal.service.interfaces.inoutparklot.param.RecordInParkLotRequest;
import com.zteits.irain.portal.service.interfaces.inoutparklot.param.RecordOutParkLotRequest;
import com.zteits.irain.portal.vo.irain.IRainResponseVO;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * Copyright: Copyright (c) 2017  ZTE-ITS
 * 
 * @ClassName: IRainParkingController.java
 * @Description:艾润 进出停车场
 * @version: v1.0.0
 * @author: wangbiao
 * @date: 2017年4月20日   上午11:51:45 
 * Modification History:
 * Date             Author          Version            Description
 *---------------------------------------------------------*
 * 2017年4月20日      wangbiao           v1.0.0               创建
 */
@Api(value="艾润  进车上报、出车上报控制",description="艾润  进车上报、出车上报")
@RestController
@RequestMapping("/parking")
public class IRainParkingController extends BizController{
	@Value("${irain.aes}")
	private String irain_aes;
	@Value("${project.syscode}")
	private String sysCode;
	@Value("${server.port}")
	private String serverPort;
	
	private static final Logger logger = LoggerFactory.getLogger(IRainParkingController.class);
	
	@Autowired
	private InterfaceLogService interfaceLogService;
	@Autowired
	private InOutParkLotReportService inOutParkLotReportService;
	
	@ApiOperation("进车上报")
	@RequestMapping(value = "/inParking",method = RequestMethod.POST)
	public IRainResponseVO inParking(@RequestParam(value = "param", required = true)  String param){
		BaseInfo baseInfo = new BaseInfo();
		String requestId = baseInfo.getRequestId();
		logger.info("[RequestId:"+requestId+"]irain 进车上报返回加密内容:"+param);
		IRainResponseVO iRainResponseVO = null;
		//记录日志
		InterfaceLogSaveRequest logSaveRequest = new InterfaceLogSaveRequest(sysCode,baseInfo,InterfaceLog.Type.TYPE_IN_PARKING, param,InterfaceLog.FromType.IRAIN);
		//设置未解密的字符串
		logSaveRequest.setEncryptParam(param);
		//设置未同步
		logSaveRequest.setSyncStatus(1);
		try {
			if(StringUtils.isBlank(param)){
				throw new BizException(ErrorType.PARAMM_NULL, "请求报文");
			}
			//解密
			String decryptAESparam = "";
			decryptAESparam = AESPlus.decrypt(irain_aes,param);
			logger.info("[RequestId:"+requestId+"]irain 进车上报返解密:"+decryptAESparam);
			logSaveRequest.setRequestBody(decryptAESparam);
			
			//TODO 临时调用
			this.tmpInvokeOldInOutController("inParking", decryptAESparam);
			
			//组织请求参数
			RecordInParkLotRequest request = new RecordInParkLotRequest();
			request.setFromType(InterfaceLog.FromType.IRAIN);
			request.setSourceType(InterfaceLog.SourceType.GATEWAY);
			request.setSysCode(sysCode);
			JSONObject humbObj = underlineObjConverHumpObj(decryptAESparam);
			InParkingRequest iRainInParkingRequest = JSON.parseObject(humbObj.toJSONString(), InParkingRequest.class);
			request.setInParkLotReq(iRainInParkingRequest);
			//调用进车服务
			Long outId = inOutParkLotReportService.InParkLotRecord(request );
			
			//保存转化之后的请求数据
			logSaveRequest.setRequestConversionBody(JSON.toJSONString(iRainInParkingRequest));
			
			//记录外部主键
			logSaveRequest.setOutId(outId);
			logSaveRequest.setStatus(InterfaceLog.Status.SUCCESS);
			iRainResponseVO = new IRainResponseVO(IRainResultEnum.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			logSaveRequest.setMessage(ExceptionUtil.getTrace(e));
			logSaveRequest.setStatus(InterfaceLog.Status.FAIL);
			iRainResponseVO = new IRainResponseVO(ErrorType.BIZ_ERROR);
		}finally{
			logSaveRequest.setResponseBody(JSONObject.toJSONString(iRainResponseVO));
			logSaveRequest.setResponseTime(new Date());
			//保存日志
			try{
				interfaceLogService.SaveInterfaceLog(logSaveRequest);
			}catch(Exception e){
				e.printStackTrace();
			}
		}
		logger.info("[RequestId:"+requestId+"]irain 进车上报 返回:"+JSONObject.toJSON(iRainResponseVO));
		return iRainResponseVO;
	}
	
	/**
	 *  出车上报
	 * @param param (aes加密后的JSON字符串)
	 */
	@ApiOperation("出车上报")
	@RequestMapping(value = "/outParking" ,method = RequestMethod.POST)
	public IRainResponseVO outParking(@RequestParam(value = "param", required = true) String param){
		BaseInfo baseInfo = new BaseInfo();
		String requestId = baseInfo.getRequestId();
		logger.info("[RequestId:"+requestId+"]irain 出车上报返回加密内容:"+param);
		IRainResponseVO iRainResponseVO = null;
		//记录日志
		InterfaceLogSaveRequest logSaveRequest = new InterfaceLogSaveRequest(sysCode, baseInfo, InterfaceLog.Type.TYPE_OUT_PARKING,
				param, InterfaceLog.FromType.IRAIN);
		//设置未解密的字符串
		logSaveRequest.setEncryptParam(param);
		//设置未同步
		logSaveRequest.setSyncStatus(1);
		try {
			//解密
			String decryptAESparam = "";
			decryptAESparam = AESPlus.decrypt(irain_aes,param);
			logger.info("[RequestId:"+requestId+"]irain 出车上报返解密:"+decryptAESparam);
			logSaveRequest.setRequestBody(decryptAESparam);
			
			//TODO 临时调用
			this.tmpInvokeOldInOutController("outParking", decryptAESparam);
			
			//组织请求参数
			RecordOutParkLotRequest request = new RecordOutParkLotRequest();
			request.setFromType(InterfaceLog.FromType.IRAIN);
			request.setSysCode(sysCode);
			request.setSourceType(InterfaceLog.SourceType.GATEWAY);
			//创建后场请求对象
			JSONObject humbObj = underlineObjConverHumpObj(decryptAESparam);
			OutParkingRequest iRainOutParkingRequest = JSON.parseObject(humbObj.toJSONString(), OutParkingRequest.class);
			
			if(iRainOutParkingRequest == null){
				throw new BizException(ErrorType.PARAMM_NULL,"请求对象");
			}
			request.setOutParkLotReq(iRainOutParkingRequest);
			
			logger.info("调用出车服务请求参数:"+JSON.toJSONString(request));
			Long outId = inOutParkLotReportService.OutParkLotRecord(request );
			
			//保存转化之后的请求数据
			logSaveRequest.setRequestConversionBody(JSON.toJSONString(iRainOutParkingRequest));
			
			//记录外部主键
			logSaveRequest.setOutId(outId);
			logSaveRequest.setStatus(InterfaceLog.Status.SUCCESS);
			iRainResponseVO = new IRainResponseVO(IRainResultEnum.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			logSaveRequest.setMessage(ExceptionUtil.getTrace(e));
			logSaveRequest.setStatus(InterfaceLog.Status.FAIL);
			iRainResponseVO = new IRainResponseVO(ErrorType.BIZ_ERROR);
		}finally{
			logSaveRequest.setResponseBody(JSONObject.toJSONString(iRainResponseVO));
			logSaveRequest.setResponseTime(new Date());
			//保存日志
			try{
				interfaceLogService.SaveInterfaceLog(logSaveRequest);
			}catch(Exception e){
				e.printStackTrace();
			}
			
		}
		logger.info("[RequestId:"+requestId+"]irain 进车上报 返回:"+JSONObject.toJSON(iRainResponseVO));
		return iRainResponseVO;
	}
	
	/**
	 * 下划线bean转驼峰bean
	 * @return
	 * 2017年5月5日 zhaowg
	 * @throws IllegalAccessException 
	 * @throws InstantiationException 
	 */
	private JSONObject underlineObjConverHumpObj(String param) throws InstantiationException, IllegalAccessException{
		JSONObject humpObj = new JSONObject();
		JSONObject underlineObj = JSON.parseObject(param);
		for (Entry<String, Object> entry : underlineObj.entrySet()) {
			//下划线key
			String humpName = underlineConverHump(entry.getKey());
			if(humpName.equals("chargeItems") && StringUtils.isNotEmpty((String)entry.getValue())){
				JSONArray chargeItem = JSON.parseArray((String)entry.getValue());
				JSONArray newChargeItems = new JSONArray();
				for (Object object : chargeItem) {
					JSONObject obj = this.underlineObjConverHumpObj(JSON.toJSONString(object));
					newChargeItems.add(obj);
				}
				humpObj.put(humpName,newChargeItems);
			}else if(humpName.equals("inTime") || humpName.equals("outTime") || humpName.equals("time")){
				String value = String.valueOf((Integer)entry.getValue());
				if(value.length()==10){//UNIX时间戳
					humpObj.put(humpName, ((Integer)entry.getValue())*1000L);
				}else{
					humpObj.put(humpName, entry.getValue());
				}
			}else{
				humpObj.put(humpName, entry.getValue());
			}
		}
		return humpObj;
	}
	/**
	 * 将下划线转换为驼峰：vpl_own——>vplOwn
	 * @param underlineName
	 * @return
	 * 2017年5月5日 zhaowg
	 */
	private String underlineConverHump(String underlineName){
		if(StringUtils.isBlank(underlineName)){
			return "";
		}
		String[] underlines = underlineName.split("_");
		StringBuilder humpName = new StringBuilder();
		for (int i = 0; i < underlines.length; i++) {
			String underline = underlines[i];
			if(i==0){
				humpName.append(underline);
			}else{
				humpName.append(underline.substring(0, 1).toUpperCase()+underline.substring(1));
			}
		}
		return humpName.toString();
	}
	/**
	 * 临时解决，调用旧的park-portal 进出场服务
	 * @param path
	 * @param params
	 * 2017年6月27日 zhaowg
	 */
	private void tmpInvokeOldInOutController(String path,String param){
		/*String url = "http://127.0.0.1:"+oldServerPort+"/parking/"+path;
		logger.info("开始调用艾润进出场上报旧的服务："+url);
		new Thread(new Runnable() {
			@Override
			public void run() {
				
				logger.info("开始调用艾润进出场上报旧的服务："+url);
				
				String decryptAESparam = "";
				try {
					logger.info("调用旧服务加密前："+param);
					decryptAESparam = AESPlus.encrypt(irain_aes,param);
					logger.info("调用旧服务加密后："+decryptAESparam);
				} catch (Exception e) {
					logger.info("irain 进车上报返解密异常:"+e);
				}
			    Map<String, Object> params = new HashMap<>();
				params.put("param", decryptAESparam);
				String rs ="";
				try {
					 rs = HttpClientTutorial.httpPostRequest(url, params);
					 logger.info("调用艾润进出场上报旧的服务完成："+rs);
				} catch (Exception e) {
					logger.error("调用艾润进出场上报旧的服务报错：",e);
				}
				
			}
		}).start();*/
	}
   @RequestMapping(value  = "/testIn",method = RequestMethod.POST) 
	public String billQuery(String param) {
	    String decryptAESparam = "";
		try {
			decryptAESparam = AESPlus.encrypt(irain_aes,param);
		} catch (Exception e) {
			logger.info("irain 进车上报返解密异常:"+e);
		}
	    Map<String, Object> params = new HashMap<>();
		params.put("param", decryptAESparam);
		String rs ="";
		try {
			 rs = HttpClientTutorial.httpPostRequest("http://127.0.0.1:"+serverPort+"/parking/inParking", params);
			logger.info("irain 查询停车费用返回:" + JSONObject.toJSONString(rs));
		} catch (Exception e) {
			logger.info("irain 查询停车费用出错:" + e);
		}
		return rs;
	}
   
   
   @RequestMapping(value = "/testOut",method = RequestMethod.POST) 
	public String billQuery1(String param) {
	   String decryptAESparam = "";
		try {
			decryptAESparam = AESPlus.encrypt(irain_aes,param);
		} catch (Exception e) {
			logger.info("irain 进车上报返解密异常:"+e);
		}
	    Map<String, Object> params = new HashMap<>();
		params.put("param", decryptAESparam);
		String rs ="";
		try {
			 rs = HttpClientTutorial.httpPostRequest("http://127.0.0.1:"+serverPort+"/parking/outParking", params);
			logger.info("irain 查询停车费用返回:" + JSONObject.toJSONString(rs));
		} catch (Exception e) {
			logger.info("irain 查询停车费用出错:" + e);
		}
		return rs;
	}
	 
}
