package com.zteits.irain.portal.web.govclouds;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSONObject;
import com.clouds.common.cache.sys.SysCodeValueCacheUtil;
import com.clouds.common.constants.CodeValKindEnum;
import com.clouds.common.web.vo.BizResultVO;
import com.google.common.collect.Lists;
import com.zteits.clouds.api.apibase.bean.BizResult;
import com.zteits.clouds.api.apibase.bean.PageBean;
import com.zteits.clouds.api.apibase.constants.ErrorType;
import com.zteits.clouds.api.apibase.exception.BizException;
import com.zteits.clouds.api.dto.park.param.StatisticParkLotCountByCountryRequest;
import com.zteits.clouds.api.dto.park.param.UpdateFreeBerthRequest;
import com.zteits.clouds.api.dto.sys.SysRoleDTO;
import com.zteits.clouds.api.dto.sys.TbAreaDTO;
import com.zteits.clouds.api.dto.sys.param.TbAreaQueryRequest;
import com.zteits.clouds.api.service.sys.TbAreaService;
import com.zteits.irain.portal.web.irain.UpdateFreeBerthController;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * 区域服务
 * 
 * Copyright: Copyright (c) 2017 zteits
 * 
 * @ClassName: TbAreaController.java
 * @Description:
 * @version: v1.0.0
 * @author: langlw
 * @date: 2017年7月18日 下午4:32:28 Modification History: Date Author Version
 *        Description ---------------------------------------------------------*
 *        2017年7月18日 langlw v1.0.0 创建
 */
@RestController
@Api(value = "区域服务", description = "区域服务")
@RequestMapping("/area")
public class TbAreaController {
	private static final Logger logger = LoggerFactory.getLogger(TbAreaController.class);

	@Value("${project.syscode}")
	private String sysCode;
	@Autowired
	private TbAreaService tbAreaService;

	@ApiOperation("查询区域下一级")
	@PostMapping("queryNextLowerLeverById")
	public BizResultVO<List<Map<String, String>>> queryNextLowerLeverById(@RequestBody StatisticParkLotCountByCountryRequest request) {

		if (null == request.getCityId()) {
			throw new BizException(ErrorType.PARAMM_NULL, "区域ID");
		}
		logger.info("请求参数:", JSONObject.toJSONString(request));
		Map<String, String> map = SysCodeValueCacheUtil.queryCodeValueAndNames(null, CodeValKindEnum.GOV_CLOUDS_LBS_AREA_, request.getCityId()+"");
		List<Map<String, String>> list=new ArrayList<>();
		map.entrySet().forEach(e->{
			Map<String,String> mapitem = new HashMap<>();
			mapitem.put(e.getKey(), e.getValue());
			list.add(mapitem);
		});
		logger.info("打印json结果:"+JSONObject.toJSONString(list));
		return new BizResultVO<List<Map<String, String>>>().setData(list);
	}

}
