/**
 * 
 */
package com.zteits.irain.portal.web.govclouds;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSON;
import com.clouds.common.cache.park.ParkFreeBerthsCacheUtil;
import com.clouds.common.cache.park.ParkingLotGeoCacheUtil;
import com.clouds.common.entity.UserArea;
import com.clouds.common.entity.UserInfo;
import com.clouds.common.web.SessionCommUtil;
import com.clouds.common.web.vo.BizResultVO;
import com.zteits.clouds.api.apibase.bean.BizResult;
import com.zteits.clouds.api.apibase.constants.LonLatTypeEnum;
import com.zteits.clouds.api.dto.govclouds.dto.BerthInfoDTO;
import com.zteits.clouds.api.dto.govclouds.dto.EscapesPaymentDataDTO;
import com.zteits.clouds.api.dto.govclouds.dto.WarningInfoDTO;
import com.zteits.clouds.api.dto.govclouds.dto.ZeroBerthParkingLotDTO;
import com.zteits.clouds.api.dto.govclouds.param.BerthExponentinfoRequest;
import com.zteits.clouds.api.dto.govclouds.param.EscapePaymentRequest;
import com.zteits.clouds.api.dto.govclouds.param.ParkingBerthInfoRequest;
import com.zteits.clouds.api.dto.govclouds.param.UserAreaInfo;
import com.zteits.clouds.api.dto.govclouds.param.WaringFreeBerthRequest;
import com.zteits.clouds.api.dto.govclouds.param.WarningInfoRequest;
import com.zteits.clouds.api.dto.park.dto.ParkinglotAndGeoInfoDTO;
import com.zteits.clouds.api.service.govclouds.RealtimeInfoService;
import com.zteits.clouds.api.service.park.ParkingLotBerthsService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * @author hxz
 *
 */
@Api(value="实时停车", description="实时停车")
@RestController
@RequestMapping("/rtinfo")
public class RealTimeInfoController {
	private static final Logger logger = LoggerFactory.getLogger(RealTimeInfoController.class);

	@Value("${project.syscode}")
	private String sysCode;
	@Autowired
	private SessionCommUtil sessionCommUtil;
	
	@Autowired
	private RealtimeInfoService rtInfoService;
	@Autowired
	private ParkingLotBerthsService plBerthsService;
	
	@ApiOperation("24小时逃逸补缴情况")
	@PostMapping("/escapePaymentInfo")
	public BizResultVO<EscapesPaymentDataDTO> getEscapePaymentInfoDuring24hs(@RequestBody EscapePaymentRequest request) {
		BizResult<EscapesPaymentDataDTO> result = null;
		try {
			result = rtInfoService.getEscapePaymentInfoDuring24hs(request);
		} catch (Exception e) {
			logger.error(e.toString());
			e.printStackTrace();
		}

        return new BizResultVO<EscapesPaymentDataDTO>(result);
	}
	
	@ApiOperation("停车指数，根据登录人所属市区id获取计算所需数据")
	@PostMapping("/berthinfo")
	public BizResultVO<BerthInfoDTO> getParkingBerthInfo(@RequestBody BerthExponentinfoRequest req) {
		ParkingBerthInfoRequest request = new ParkingBerthInfoRequest();
		request.setSysCode(req.getSysCode());
		
		UserInfo userInfo = sessionCommUtil.getUserInfo();
		List<UserArea> userAreaList = userInfo.getUserAreas();
		List<UserAreaInfo> userAreaInfoList = null;
		if (null != userAreaList && !CollectionUtils.isEmpty(userAreaList)) {
			userAreaInfoList = JSON.parseArray(JSON.toJSONString(userAreaList, false), UserAreaInfo.class);
		}
		request.setUserAreaInfoList(userAreaInfoList);
		
		BizResult<BerthInfoDTO> result = plBerthsService.getParkingBerthInfo(request);
		
		return new BizResultVO<BerthInfoDTO>(result);	
	}
	
	@ApiOperation("停车预警")
	@PostMapping("/warninginfo")
	public BizResultVO<List<WarningInfoDTO>> getPreWarningInfo(@RequestBody WaringFreeBerthRequest req) {
		logger.debug("getPreWarningInfo:" + req.getSysCode());
		
		WarningInfoRequest request = new WarningInfoRequest();
		request.setSysCode(req.getSysCode());
		//UserInfo userInfo = sessionCommUtil.getUserInfo();
		List<UserArea> userAreaList = new ArrayList<UserArea>();//userInfo.getUserAreas();
		// 权宜之策构造 begin
		UserArea userArea = new UserArea();
		userArea.setAreaId(req.getCityId());
		userAreaList.add(userArea);
		// 权宜之策构造 end
		List<UserAreaInfo> userAreaInfoList = null;
		if (null != userAreaList && !CollectionUtils.isEmpty(userAreaList)) {
			userAreaInfoList = JSON.parseArray(JSON.toJSONString(userAreaList, false), UserAreaInfo.class);
		}
		request.setUserAreaInfoList(userAreaInfoList);

		// 获取所有空闲车位为零的停车场信息列表
		List<ZeroBerthParkingLotDTO> zeroBerthplDTOList = plBerthsService.getZeroBerthParkinglotList(request);	
		List<WarningInfoDTO> warningInfoList  = new ArrayList<WarningInfoDTO>();
		if (null != zeroBerthplDTOList) {
			logger.debug("zeroBerthplDTOList---->" + JSON.toJSONString(zeroBerthplDTOList, false));
			
			for (ZeroBerthParkingLotDTO zeroBerthpl: zeroBerthplDTOList) {
	
				List<ParkinglotAndGeoInfoDTO> plgInfoList = ParkingLotGeoCacheUtil.queryParkLotsWithDistanceAndCoordinateByAsc(
						LonLatTypeEnum.LON_LAT_TYPE_1, zeroBerthpl.getLongitude(), zeroBerthpl.getLatitude(), 5000D, 50L);
				
				int notZeroBerthPlCount = 0;// 非零空闲泊位数的停车场个数
				if (null != plgInfoList && !CollectionUtils.isEmpty(plgInfoList)) {
					WarningInfoDTO warningInfoDTO = new WarningInfoDTO();
					for (ParkinglotAndGeoInfoDTO ParkinglotAndGeoInfoDTO: plgInfoList) {
						if (0 < ParkFreeBerthsCacheUtil.getFreeBerthsByPlNo(ParkinglotAndGeoInfoDTO.getPlNo()))
						{
							notZeroBerthPlCount += 1;
						}
					}
					
					if (0 < notZeroBerthPlCount) {
						warningInfoDTO.setParkingLotName(zeroBerthpl.getParkingLotName());
						warningInfoDTO.setPlCountHavingFreeBerth(notZeroBerthPlCount);
						
						warningInfoList.add(warningInfoDTO);
					}
				}
			}
		}
		return new BizResultVO<>(new BizResult<>(warningInfoList)) ;
	}
}
