package com.zteits.irain.portal.web.govclouds;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSONObject;
import com.clouds.common.web.vo.BizResultVO;
import com.xiaoleilu.hutool.util.CollectionUtil;
import com.zteits.clouds.api.apibase.bean.BizResult;
import com.zteits.clouds.api.apibase.bean.PageBean;
import com.zteits.clouds.api.apibase.constants.ErrorType;
import com.zteits.clouds.api.apibase.constants.LonLatTypeEnum;
import com.zteits.clouds.api.apibase.exception.BizException;
import com.zteits.clouds.api.dto.govclouds.dto.ParkinglotHeatmapDTO;
import com.zteits.clouds.api.dto.govclouds.dto.ParkinglotHeatmapDayDTO;
import com.zteits.clouds.api.dto.govclouds.dto.ParkinglotHeatmapHourDTO;
import com.zteits.clouds.api.dto.govclouds.param.QueryHeatmapByDateRequest;
import com.zteits.clouds.api.dto.park.dto.ParkingLotDTO;
import com.zteits.clouds.api.dto.park.param.ParkFreeBerthGetByPlnoRequest;
import com.zteits.clouds.api.dto.park.param.PlNoQueryBycountryAndParkNameRequest;
import com.zteits.clouds.api.dto.park.param.QueryParkLotInfoByPkNoRequest;
import com.zteits.clouds.api.dto.park.param.QueryParkingLotByCountryRequest;
import com.zteits.clouds.api.service.govclouds.ParkHeatmapService;
import com.zteits.clouds.api.service.park.ParkFreeBerthService;
import com.zteits.clouds.api.service.park.ParkingLotQueryService;
import com.zteits.irain.portal.constant.ParkConstant;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * 停车LBS，相关Controller.<br/>
 *
 * Copyright: Copyright (c) 2017  zteits
 *
 * @ClassName: ParkingLBSController
 * @Description:
 * @version: v1.0.0
 * @author: xiejianpeng
 * @date: 2017年7月7日 下午4:52:41
 * Modification History:
 * Date             Author          Version            Description
 * ---------------------------------------------------------*
 * 2017年7月7日      xiejianpeng           v1.0.0               创建
 */
@RestController
@Api(value = "数据中心-停车LBS", description = "数据中心-停车LBS")
@RequestMapping("/parkingLBS")
public class ParkingLBSController {

    private Logger logger = LoggerFactory.getLogger(ParkingLBSController.class);

    @Autowired
    private ParkingLotQueryService parkingLotQueryService;

    @Autowired
    private ParkHeatmapService parkHeatmapService;

    @Autowired
    private ParkFreeBerthService parkFreeBerthService;

    @ApiOperation(value = "停车场分页查询-根据市、区县id、停车场名称或地址")
    @PostMapping("/queryParkLotByCountryAndParkName")
    @ResponseBody
    public BizResultVO<PageBean<ParkingLotDTO>> queryParkLotByCountryAndParkName(
        @RequestBody QueryParkingLotByCountryRequest request) {
        logger.info("开始-根据市id、区县id和停车场名称或地址查询停车场信息  req={}", JSONObject.toJSONString(request));
        if(request.getLonLatType()==null){
        	//默认百度
        	request.setLonLatType(LonLatTypeEnum.LON_LAT_TYPE_1.value());
        }
        if(request.getGeoType()==null){
        	//默认停车场坐标
        	request.setGeoType(ParkConstant.ParkingLotGeo.GeoType.TYPE_PARKINGLOT);
        }
        BizResult<PageBean<ParkingLotDTO>> result = parkingLotQueryService.queryParkLotByCountryAndParkName(request);
        logger.info("开始-根据市id、区县id和停车场名称或地址查询停车场信息  result={}", JSONObject.toJSONString(result));
        return new BizResultVO<>(result);
    }

    @ApiOperation(value = "根据停车场编号查询停车场详细信息")
    @PostMapping("/queryParkingLotByPkNo")
    @ResponseBody
    public BizResultVO<ParkingLotDTO> queryParkingLotByPkNo(@RequestBody QueryParkLotInfoByPkNoRequest request) {
        logger.info("开始-根据停车场编号查询停车场详细信息  req={}", JSONObject.toJSONString(request));
        BizResult<ParkingLotDTO> result = parkingLotQueryService.QueryParkingLotByPkNo(request);
        logger.info("开始-根据停车场编号查询停车场详细信息  result={}", JSONObject.toJSONString(result));
        return new BizResultVO<>(result);
    }

    @ApiOperation(value = "根据区县id、停车场名称或地址查询停车场经纬度信息")
    @PostMapping("/queryParkingLotGeoByCountryAndParkName")
    @ResponseBody
    public BizResultVO<List<ParkingLotDTO>> queryParkingLotGeoByCountryAndParkName(@RequestBody
        PlNoQueryBycountryAndParkNameRequest request) {

        if (CollectionUtil.isEmpty(request.getCountryId())) {
            throw new BizException(ErrorType.PARAMM_NULL, "区县ID不能为空!");
        }
        if(request.getLonLatType()==null){
        	//默认百度
        	request.setLonLatType(LonLatTypeEnum.LON_LAT_TYPE_1.value());
        }
        if(request.getGeoType()==null){
        	//默认停车场坐标
        	request.setGeoType(ParkConstant.ParkingLotGeo.GeoType.TYPE_PARKINGLOT);
        }
        BizResult<List<ParkingLotDTO>> result = parkingLotQueryService.queryParkingLotGeoByCountryAndParkName(request);
        return new BizResultVO<>(result);
    }

    /*@ApiOperation(value = "根据停车场编号查询停车场经纬度信息")
    @PostMapping("/queryParkingLotGeoByPkNo")
    @ResponseBody
    public BizResultVO<ParkingLotGeoDTO> queryParkingLotGeoByPkNo(@RequestBody QueryParkLotInfoByPkNoRequest request) {
        logger.info("开始-根据停车场编号查询停车场经纬度  req={}", JSONObject.toJSONString(request));
        if(request.getLonLatType() == null){
        	request.setLonLatType(1);
        }
        BizResult<ParkingLotGeoDTO> result = parkingLotGeoQueryService.queryParkingLotGeoByParkNo(request);
        logger.info("开始-根据停车场编号查询停车场经纬度   result={}", JSONObject.toJSONString(result));
        return new BizResultVO<>(result);
    }*/

    @ApiOperation(value = "根据停车场编号列表查询停车场空闲车位数")
    @PostMapping("/queryParkFreeBerthsByPkNos")
    @ResponseBody
    public BizResultVO<Map<String, Integer>> queryParkFreeBerthsByPkNos(
        @RequestBody ParkFreeBerthGetByPlnoRequest request) {
        logger.info("开始-根据停车场编号查询停车场经纬度  req={}", JSONObject.toJSONString(request));
        BizResult<Map<String, Integer>> bizResult = parkFreeBerthService.getParkFreeBerthByPlno(request);
        logger.info("开始-根据停车场编号查询停车场经纬度   result={}", JSONObject.toJSONString(bizResult));
        return new BizResultVO<>(bizResult);
    }

    @ApiOperation(value = "查询省市的停车热点-按小时统计")
    @PostMapping("/queryParkHeatmapByHour")
    @ResponseBody
    public BizResultVO<List<ParkinglotHeatmapDTO>> queryParkHeatmapByHour(
        @RequestBody QueryHeatmapByDateRequest request) {
        logger.info("开始-查询按小时统计的省市的停车热点  req={}", JSONObject.toJSONString(request));
        /** 查询热力图-小时统计*/
        BizResult<List<ParkinglotHeatmapHourDTO>> result = parkHeatmapService.queryParkHeatmapByHour(request);
        List<ParkinglotHeatmapDTO> heatmapDTOList = new ArrayList<ParkinglotHeatmapDTO>();
        for (ParkinglotHeatmapHourDTO heatmapHourDTO : result.getData()) {
            ParkinglotHeatmapDTO parkinglotHeatmapDTO = new ParkinglotHeatmapDTO();
            parkinglotHeatmapDTO.setLat(heatmapHourDTO.getLat());
            parkinglotHeatmapDTO.setLon(heatmapHourDTO.getLon());
            parkinglotHeatmapDTO.setCurrentParkCount(heatmapHourDTO.getCurrentParkCount());
            heatmapDTOList.add(parkinglotHeatmapDTO);
        }
        BizResultVO<List<ParkinglotHeatmapDTO>> resultVO = new BizResultVO<>();
        resultVO.setData(heatmapDTOList);
        logger.info("结束-查询按小时统计的省市的停车热点   result={}", JSONObject.toJSONString(result));
        return resultVO;
    }

    @ApiOperation(value = "查询省市的停车热点-按日期统计")
    @PostMapping("/queryParkHeatmapByDay")
    @ResponseBody
    public BizResultVO<List<ParkinglotHeatmapDTO>> queryParkHeatmapByDay(
        @RequestBody QueryHeatmapByDateRequest request) {
        logger.info("开始-查询按日期统计的省市的停车热点  req={}", JSONObject.toJSONString(request));
        /** 查询热力图-小时统计*/
        BizResult<List<ParkinglotHeatmapDayDTO>> result = parkHeatmapService.queryParkHeatmapByDay(request);
        List<ParkinglotHeatmapDTO> heatmapDTOList = new ArrayList<ParkinglotHeatmapDTO>();
        for (ParkinglotHeatmapDayDTO heatmapDayDTO : result.getData()) {
            ParkinglotHeatmapDTO parkinglotHeatmapDTO = new ParkinglotHeatmapDTO();
            parkinglotHeatmapDTO.setLat(heatmapDayDTO.getLat());
            parkinglotHeatmapDTO.setLon(heatmapDayDTO.getLon());
            parkinglotHeatmapDTO.setCurrentParkCount(heatmapDayDTO.getCurrentParkCount());
            heatmapDTOList.add(parkinglotHeatmapDTO);
        }
        BizResultVO<List<ParkinglotHeatmapDTO>> resultVO = new BizResultVO<>();
        resultVO.setData(heatmapDTOList);
        logger.info("结束-查询按日期统计的省市的停车热点   result={}", JSONObject.toJSONString(result));
        return resultVO;
    }

}