package com.zteits.irain.portal.web.govclouds;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.alibaba.fastjson.JSONObject;
import com.clouds.common.cache.park.ParkFreeBerthsCacheUtil;
import com.clouds.common.utils.AppRsesultUtil;
import com.clouds.common.utils.DateUtil;
import com.clouds.common.web.BizController;
import com.clouds.common.web.vo.BizResultVO;
import com.google.common.collect.Lists;
import com.xiaoleilu.hutool.util.CollectionUtil;
import com.zteits.clouds.api.apibase.bean.BizResult;
import com.zteits.clouds.api.apibase.bean.PageBean;
import com.zteits.clouds.api.apibase.constants.BasicEnum;
import com.zteits.clouds.api.apibase.constants.ErrorType;
import com.zteits.clouds.api.dto.govclouds.dto.ParkEqpAndPDACountDTO;
import com.zteits.clouds.api.dto.govclouds.dto.ParkingCountForTypeDTO;
import com.zteits.clouds.api.dto.govclouds.dto.ParkingTrackDTO;
import com.zteits.clouds.api.dto.govclouds.param.QueryParkEqpAndPDACountRequest;
import com.zteits.clouds.api.dto.govclouds.param.QueryParkingCountRequest;
import com.zteits.clouds.api.dto.govclouds.param.QueryParkingTrackRequest;
import com.zteits.clouds.api.dto.park.dto.BerthsDTO;
import com.zteits.clouds.api.dto.park.dto.ParkingLotDTO;
import com.zteits.clouds.api.dto.park.dto.ParkingLotUseStatisticDTO;
import com.zteits.clouds.api.dto.park.dto.TodayVehicleFlowOccupyRateAndTurnOverDTO;
import com.zteits.clouds.api.dto.park.param.CommonPlnosQueryRequest;
import com.zteits.clouds.api.dto.park.param.ParkingLotUseStatisticForPageRequest;
import com.zteits.clouds.api.dto.park.param.QueryParkLotInfoByPkNoRequest;
import com.zteits.clouds.api.dto.pay.TdCFileDTO;
import com.zteits.clouds.api.dto.pay.param.SysFileGetBySourceIdAndTypeRequest;
import com.zteits.clouds.api.service.govclouds.ParkPreferenceService;
import com.zteits.clouds.api.service.park.BerthManageService;
import com.zteits.clouds.api.service.park.ParkingLotEqpService;
import com.zteits.clouds.api.service.park.ParkingLotQueryService;
import com.zteits.clouds.api.service.park.ParkingLotUseStatisticService;
import com.zteits.clouds.api.service.park.TpPPdaService;
import com.zteits.clouds.api.service.pay.TdCFileService;
import com.zteits.irain.portal.constant.ParkConstant;
import com.zteits.irain.portal.vo.govclouds.ParkingBusiCircleForTypeVO;
import com.zteits.irain.portal.vo.govclouds.ParkingCountForTypeVO;
import com.zteits.irain.portal.vo.govclouds.ParkingDeviceVO;
import com.zteits.irain.portal.vo.govclouds.ParkingStatisVO;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
/**
 * 政府云平台--->数据分析--->停车轨迹.<br/>
 * 
 * Copyright: Copyright (c) 2017  zteits
 * 
 * @ClassName: ParkingContrailController.java
 * @Description: 
 * @version: v1.0.0
 * @author: wangfs
 * @date: 2017年7月13日   上午9:36:52 
 * Modification History:
 * Date             Author          Version            Description
 *---------------------------------------------------------*
 * 2017年7月13日      wangfs           v1.0.0               创建
 */
@Api(value = "政府云平台--->数据分析--->停车轨迹", description = "政府云平台--->数据分析--->停车轨迹")
@Controller
@RequestMapping("/parkingContrail")
public class ParkingContrailController extends BizController{

	private static final  Logger logger = LoggerFactory.getLogger(ParkingContrailController.class);
	@Autowired
	private ParkPreferenceService parkPreferenceService;
	//停车场基本信息查询服务
	@Autowired
	private ParkingLotQueryService parkingLotQueryService;
	//附件查询服务-查询停车场图片
	@Autowired
	private TdCFileService tdCFileService;
	//停车场泊位信息查询
	@Autowired
	private BerthManageService berthManageService;
	//停车场空置率 周转率查询
	@Autowired
	private ParkingLotUseStatisticService parkingLotUseStatisticService;
	@Autowired
	//硬件设备服务
	private ParkingLotEqpService parkingLotEqpService;
	@Autowired
	private TpPPdaService tpPPdaService;
	
	@ApiOperation("停车编好->饼图")
	@PostMapping("/parkingCountForPlType")
	@ResponseBody
	public BizResultVO<List<ParkingCountForTypeVO>> parkingCountForPlType(@RequestBody QueryParkingCountRequest parkingCountRequest,HttpServletRequest request, HttpServletResponse response) throws Exception{
		BizResult<List<ParkingCountForTypeVO>> result = new  BizResult<List<ParkingCountForTypeVO>>();
		List<ParkingCountForTypeVO> list = new  ArrayList<ParkingCountForTypeVO>();
		logger.info("---begin停车轨迹-->停车编好->饼图Controller,入参＝"+JSONObject.toJSON(parkingCountRequest));
		BizResult<List<ParkingCountForTypeDTO>> bizResult =parkPreferenceService.queryParkingCountForPlType(parkingCountRequest);
		//int sumCurrentParkCount = 0;
		if(bizResult != null && !CollectionUtils.isEmpty(bizResult.getData())){
			for(ParkingCountForTypeDTO dto:bizResult.getData()){
				if(dto != null){
					//sumCurrentParkCount+= dto.getCurrentParkCount();
					ParkingCountForTypeVO parkingCountForTypeVO = new ParkingCountForTypeVO();
					BeanUtils.copyProperties(dto, parkingCountForTypeVO);
					list.add(parkingCountForTypeVO);
				}
			}
			
		}
		result.setErrCode(bizResult.getErrCode());
		result.setErrMsg(bizResult.getErrMsg());
		result.setData(list);
		logger.info("---begin停车轨迹-->停车编好->饼图Controller,结果＝"+result);
		
		return new BizResultVO<List<ParkingCountForTypeVO>>(result);
	}
	
	
	@ApiOperation("停车商圈属性对应的停车数量->柱状图")
	@PostMapping("/parkingCountForBusiCircle")
	@ResponseBody
	public BizResultVO<List<ParkingBusiCircleForTypeVO>> parkingCountForBusiCircle(@RequestBody QueryParkingCountRequest parkingCountRequest,HttpServletRequest request, HttpServletResponse response) throws Exception{
		BizResultVO<List<ParkingBusiCircleForTypeVO>> result = new  BizResultVO<List<ParkingBusiCircleForTypeVO>>();
		List<ParkingBusiCircleForTypeVO> list = new  ArrayList<ParkingBusiCircleForTypeVO>();
		logger.info("---begin停车轨迹-->停车商圈属性对应的停车数量->柱状图Controller,入参＝"+JSONObject.toJSON(parkingCountRequest));
		BizResult<List<ParkingCountForTypeDTO>> bizResult =parkPreferenceService.queryParkingBusiCircleForPlType(parkingCountRequest);
		if(bizResult != null && !CollectionUtils.isEmpty(bizResult.getData())){
			for(ParkingCountForTypeDTO dto:bizResult.getData()){
				if(dto != null){
					ParkingBusiCircleForTypeVO parkingBusiCircleForTypeVO = new ParkingBusiCircleForTypeVO();
					BeanUtils.copyProperties(dto, parkingBusiCircleForTypeVO);
					list.add(parkingBusiCircleForTypeVO);
				}
			}
		}
		result.setData(list);
		logger.info("---begin停车轨迹-->停车商圈属性对应的停车数量->柱状图Controller,结果＝"+result);
		return result;
	}
	
	
	
	@ApiOperation("停车场基本信息查询")
	@PostMapping("/queryParkingBaseInfo")
	@ResponseBody
	public BizResultVO<ParkingLotDTO> queryParkingBaseInfo(@RequestBody QueryParkLotInfoByPkNoRequest queryParkLotInfoByPkNoRequest,HttpServletRequest request, HttpServletResponse response) throws Exception{
		BizResultVO<ParkingLotDTO> result = new  BizResultVO<ParkingLotDTO>();
		logger.info("停车场停车资源-基本信息查询 Controller,入参={}",JSONObject.toJSON(queryParkLotInfoByPkNoRequest));

		queryParkLotInfoByPkNoRequest.setSysCode(BasicEnum.SYS_CODE.getValue());
		logger.debug("开始 查询停车场信息:" + JSONObject.toJSONString(queryParkLotInfoByPkNoRequest));
		BizResult<ParkingLotDTO> rtMap = parkingLotQueryService.QueryParkingLotByPkNo(queryParkLotInfoByPkNoRequest);
		logger.debug("结束 查询停车场信息:" + JSONObject.toJSONString(rtMap));
		ParkingLotDTO parkingLotDTO = new ParkingLotDTO();
		if(rtMap.isSuccess()){
			parkingLotDTO =rtMap.getData();
			if(parkingLotDTO ==null){
				AppRsesultUtil.fail(ErrorType.RESOURCE_NOT_EXISTS.getCode(), ErrorType.RESOURCE_NOT_EXISTS.getMsg());
			}
		}
		Integer  freeParkingSpace = ParkFreeBerthsCacheUtil.getFreeBerthsByPlNo(queryParkLotInfoByPkNoRequest.getPklNo());
		rtMap.getData().setBerthNum(freeParkingSpace);
		
		logger.debug("start  停车场图片查询");
		SysFileGetBySourceIdAndTypeRequest sysFileGetBySourceIdAndTypeRequest = new SysFileGetBySourceIdAndTypeRequest();
		sysFileGetBySourceIdAndTypeRequest.setSourceId(queryParkLotInfoByPkNoRequest.getPklNo());
		sysFileGetBySourceIdAndTypeRequest.setSysCode(queryParkLotInfoByPkNoRequest.getSysCode());
		BizResult<List<TdCFileDTO>> fileList = tdCFileService.getFilesBySourceIdAndType(sysFileGetBySourceIdAndTypeRequest);
		
		List<String> picUrls = Lists.newArrayList();
		if(fileList.isSuccess() && CollectionUtil.isNotEmpty(fileList.getData())){
			fileList.getData().forEach(file->picUrls.add(file.getFilePath()));
		}else{
			/** 如果没有查询停车场的真实图片--则展示默认的停车场图片**/
			SysFileGetBySourceIdAndTypeRequest sysFileRequest = new SysFileGetBySourceIdAndTypeRequest();
			/*** '停车场类型:1:路内(占用道路停车位)，2-路外',*/
			if(rtMap.getData().getPlType()==1){
				sysFileRequest.setSourceId("defaul_park_pic_out");
			}else{
				sysFileRequest.setSourceId("defaul_park_pic_in");
			}
			sysFileRequest.setFileType(1);
			sysFileRequest.setSysCode(queryParkLotInfoByPkNoRequest.getSysCode());
			BizResult<List<TdCFileDTO>> defaultfileList = tdCFileService.getFilesBySourceIdAndType(sysFileRequest);
			if(defaultfileList.isSuccess() && CollectionUtil.isNotEmpty(defaultfileList.getData())){
				defaultfileList.getData().forEach(file->picUrls.add(file.getFilePath()));
			}
		}
		logger.debug("end  停车场图片查询:{}",JSONObject.toJSONString(picUrls));
		
		BizResult<List<BerthsDTO>> rsMaplist = berthManageService.queryBerthsByPlNo(queryParkLotInfoByPkNoRequest);
		if(rsMaplist.isSuccess() && CollectionUtil.isNotEmpty(rsMaplist.getData())){
			rtMap.getData().setBerths(rsMaplist.getData());
		}
		
		result.setData(rtMap.getData());
		result.getData().setPicUrls(picUrls);
		return result;
	}
	
	
	@ApiOperation("停车场停车数据查询")
	@PostMapping("/queryParkingdatas")
	@ResponseBody
	public BizResultVO<ParkingStatisVO> queryParkingdatas(@RequestBody QueryParkLotInfoByPkNoRequest queryParkLotInfoByPkNoRequest,HttpServletRequest request, HttpServletResponse response) throws Exception{
		BizResultVO<ParkingStatisVO> result = new  BizResultVO<ParkingStatisVO>();
		
		List<ParkingDeviceVO> deviceVoList = Lists.newArrayList();
		logger.info("停车场停车资源-停车场停车数据查询 Controller,入参={}",JSONObject.toJSON(queryParkLotInfoByPkNoRequest));
		ParkingStatisVO vo  = new ParkingStatisVO();
	    List<String> plNos = Lists.newArrayList();
	    plNos.add(queryParkLotInfoByPkNoRequest.getPklNo());
		CommonPlnosQueryRequest commonPlnosQueryRequest = new CommonPlnosQueryRequest();
		commonPlnosQueryRequest.setPlNos(plNos);
		commonPlnosQueryRequest.setSysCode(queryParkLotInfoByPkNoRequest.getSysCode());
		BizResult<List<TodayVehicleFlowOccupyRateAndTurnOverDTO>> rsList  =  parkingLotUseStatisticService.queryTodayVehicleFlowOccupyRateAndTurnOver(commonPlnosQueryRequest);
		if(rsList.isSuccess() && CollectionUtil.isNotEmpty(rsList.getData())){
			TodayVehicleFlowOccupyRateAndTurnOverDTO  dto = rsList.getData().get(0);
			vo.setAvgOccupyRate(dto.getAvgOccupyRate());
			vo.setAvgTurnoverRate(dto.getAvgTurnoverRate());
		}
		
		ParkingLotUseStatisticForPageRequest staticRequest = new ParkingLotUseStatisticForPageRequest();
		staticRequest.setBeginTime(DateUtil.getTimeBeforeDay(DateUtil.getSysDate()));
		staticRequest.setEndTime(DateUtil.getSysDate());
		staticRequest.setQueryKind(ParkConstant.ParkingLotUseStatistic.StatisticType.PER1HOUR);
		staticRequest.setPlNos(plNos);
		staticRequest.getBaseRequest().setPageSize(100);
		staticRequest.setSysCode(queryParkLotInfoByPkNoRequest.getSysCode());
		BizResult<PageBean<ParkingLotUseStatisticDTO>> bizResult = parkingLotUseStatisticService
				.queryParkingLotUseStatisticForPage(staticRequest);
		/**周转率，空置率不为空**/
		if(bizResult.isSuccess() && CollectionUtil.isNotEmpty(bizResult.getData().getDataList())){
			vo.setStatisList(bizResult.getData().getDataList());
		}
		
		QueryParkEqpAndPDACountRequest queryParkEqpAndPDACountRequest = new QueryParkEqpAndPDACountRequest();
		queryParkEqpAndPDACountRequest.setPlNos(plNos);
		queryParkEqpAndPDACountRequest.setSysCode(queryParkLotInfoByPkNoRequest.getSysCode());
		logger.info("停车场停车资源-停车场停车数据查询 -查询硬件设备,入参={}",JSONObject.toJSON(queryParkEqpAndPDACountRequest));
		BizResult<List<ParkEqpAndPDACountDTO>> eqpList =  parkingLotEqpService.queryParkEqpCountByPlNos(queryParkEqpAndPDACountRequest);
		logger.info("停车场停车资源-停车场停车数据查询 -查询硬件设备 地磁,出参={}",JSONObject.toJSON(eqpList));
		if(eqpList.isSuccess() && CollectionUtil.isNotEmpty(eqpList.getData())){
			eqpList.getData().forEach(eqp->{
				ParkingDeviceVO device = new ParkingDeviceVO();
				device.setType(eqp.getEqpType());
				device.setAllCount(eqp.getAllEqpCount());
				device.setOnlineCount(eqp.getOnlineEqpCount());
				deviceVoList.add(device);
			});
		}
		BizResult<List<ParkEqpAndPDACountDTO>> pdaList = tpPPdaService.queryPDACountByPlNosAndPdaType(queryParkEqpAndPDACountRequest);
		logger.info("停车场停车资源-停车场停车数据查询 -查询硬件设备 PDA等,出参={}",JSONObject.toJSON(pdaList));
		if(pdaList.isSuccess() && CollectionUtil.isNotEmpty(pdaList.getData())){
			pdaList.getData().forEach(pda->{
				ParkingDeviceVO device = new ParkingDeviceVO();
				//device.setType(pda.getEqpType());
				device.setType(9);//PDA类型暂时设置为 9
				device.setAllCount(pda.getAllEqpCount());
				device.setOnlineCount(pda.getOnlineEqpCount());
				deviceVoList.add(device);
			});
		}
		/**获取停车场的空闲车位*/
		Integer  freeParkingSpace = ParkFreeBerthsCacheUtil.getFreeBerthsByPlNo(queryParkLotInfoByPkNoRequest.getPklNo());
		vo.setFreeParkingSpace(freeParkingSpace);
		vo.setDeviceVoList(deviceVoList);
		result.setData(vo);
		return result;
	}
	
	@ApiOperation("停车车轨迹")
	@PostMapping("/queryParkingTrack")
	@ResponseBody
	public BizResultVO<ParkingTrackDTO> queryParkingTrack(@RequestBody QueryParkingTrackRequest queryParkingTrackRequest,HttpServletRequest request, HttpServletResponse response) throws Exception{
		BizResultVO<List<ParkingTrackDTO>> result = new  BizResultVO<List<ParkingTrackDTO>>();
		logger.info("---begin停车轨迹-->根据车牌查询该车的行车轨迹Controller,入参={}",JSONObject.toJSON(queryParkingTrackRequest));
		BizResult<ParkingTrackDTO> bizResult =parkPreferenceService.queryParkingTrack(queryParkingTrackRequest);
		logger.info("---begin停车轨迹-->根据车牌查询该车的行车轨迹Controller,结果={}",result);
		return new BizResultVO<ParkingTrackDTO>(bizResult);
	}
	
}















