/**
 * 
 */
package com.zteits.irain.portal.web.govclouds;

import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import javax.validation.Valid;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSON;
import com.clouds.common.cache.park.ParkingLotGeoCacheUtil;
import com.clouds.common.cache.sys.SysCodeValueCacheUtil;
import com.clouds.common.constants.CodeValKindEnum;
import com.clouds.common.utils.SMSNotification;
import com.clouds.common.web.BizController;
import com.clouds.common.web.vo.BizResultVO;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.zteits.clouds.api.apibase.constants.LonLatTypeEnum;
import com.zteits.clouds.api.dto.govclouds.dto.ParkinglotMarkerDTO;
import com.zteits.clouds.api.dto.govclouds.param.CenterPOIInfoRequest;
import com.zteits.clouds.api.dto.govclouds.param.WarningNoticeRequest;
import com.zteits.clouds.api.dto.park.dto.ParkinglotAndGeoInfoDTO;
import com.zteits.irain.portal.vo.govclouds.CenterPOIInfoVO;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * @author hxz
 *
 */
@Api(value="停车数据LBS 热点区域",description="停车数据LBS 热点区域")
@RestController
@RequestMapping("/hotspot")
public class HotSpotAreaController extends BizController {
	private static final Logger logger = LoggerFactory.getLogger(HotSpotAreaController.class);
	
	@ApiOperation("热点区域-热点周边停车场")
	@PostMapping("/parkinglots")
	public BizResultVO<List<ParkinglotMarkerDTO>> getParkinglotsInHotSpotRound(@Valid @RequestBody List<CenterPOIInfoRequest> request) {
		logger.info("poi 中心点{}", request);
		List<ParkinglotMarkerDTO> list = Lists.newArrayList();
		//去重
		Set<String> distinctPlNos = Sets.newHashSet();
		for (CenterPOIInfoRequest centerPOIInfoRequest : request) {
			List<ParkinglotAndGeoInfoDTO> andGeoInfoDTOs = ParkingLotGeoCacheUtil.queryParkLotsWithCoordinate(LonLatTypeEnum.LON_LAT_TYPE_1,centerPOIInfoRequest.getLongitude(), centerPOIInfoRequest.getLatitude(), centerPOIInfoRequest.getRadius()+0.00, null);
			if(CollectionUtils.isEmpty(andGeoInfoDTOs)){
				continue;
			}
			for (ParkinglotAndGeoInfoDTO parkinglotAndGeoInfoDTO : andGeoInfoDTOs) {
				ParkinglotMarkerDTO markerDTO = new ParkinglotMarkerDTO();
				String plno = parkinglotAndGeoInfoDTO.getPlNo();
				if(distinctPlNos.contains(plno)){
					continue;
				}
				distinctPlNos.add(plno);
				markerDTO.setPlNo(parkinglotAndGeoInfoDTO.getPlNo());
				markerDTO.setAddress(parkinglotAndGeoInfoDTO.getPlAddress());
				markerDTO.setLatitude(parkinglotAndGeoInfoDTO.getLatId().doubleValue());
				markerDTO.setLongitude(parkinglotAndGeoInfoDTO.getLonId().doubleValue());
				markerDTO.setParkinglotName(parkinglotAndGeoInfoDTO.getPlName());
				markerDTO.setTotalBerthNum(parkinglotAndGeoInfoDTO.getPlBerthNum());
				list.add(markerDTO);
			}
		}
		logger.info("已获得热点区域 {}", list);
		return new BizResultVO<List<ParkinglotMarkerDTO>>().setData(list);
	}
	
	@ApiOperation("获取某个城市的热点区域坐标")
	@PostMapping("/getHotspotByCityId")
	public BizResultVO<List<CenterPOIInfoVO>> getCenterPOIs(@RequestParam String cityId,@RequestParam String sysCode){
		logger.info("获取城市："+cityId+" 的热点区域坐标");
		Map<String, String> map = SysCodeValueCacheUtil.queryCodeValueAndNames(null, CodeValKindEnum.GOV_CLOUDS_HOTSPOT_AREA_, cityId);
		List<CenterPOIInfoVO> centerPOIInfoVOs = Lists.newArrayList();
		if(map!=null && !map.isEmpty()){
			for (Entry<String, String> entry : map.entrySet()) {
				String name = entry.getValue();
				CenterPOIInfoVO infoVO = new CenterPOIInfoVO();
				infoVO.setName(name);
				String[] geo = entry.getKey().split(",");
				Double lon = Double.valueOf(geo[0]);
				Double lat = Double.valueOf(geo[1]);
				infoVO.setLatitude(lat);
				infoVO.setLongitude(lon);
				centerPOIInfoVOs.add(infoVO);
			}
		}
		return new BizResultVO<List<CenterPOIInfoVO>>().setData(centerPOIInfoVOs);
	}
	
	@ApiOperation("热点区域 预警下发")
	@PostMapping("/smsWarningNotice")
	public BizResultVO<Boolean> smsWarningNotice(@RequestBody WarningNoticeRequest request) throws Exception {
		logger.info("热点区域 预警下发："+JSON.toJSONString(request));
		List<String> phones = request.getPhones();
		for (String phone: phones) {
			if(StringUtils.isBlank(phone)){
				continue;
			}
			// sms notify
			//判断是否开启短信发送
			String isopensmssend = SysCodeValueCacheUtil.queryCodeValue(CodeValKindEnum.HOTAREA_IS_OPEN_SMS_SEND);
			if(StringUtils.isBlank(isopensmssend)||isopensmssend.equalsIgnoreCase("FALSE")){
				logger.info("没有配置是否开启短信发送开关，或短信发送开关为false,不下发短信");
			}else{
				SMSNotification.sendSms(phone, request.getContent(), null);
			}
		}
		return new BizResultVO<Boolean>().setData(true);
	}
}
