package com.zteits.irain.portal.web.govclouds;

import java.util.List;
import java.util.Map;

import com.alibaba.fastjson.JSONObject;

import com.clouds.common.cache.park.ParkingLotCacheUtil;
import com.clouds.common.constants.SysFileTypeEnum;
import com.clouds.common.utils.ResultUtils;
import com.clouds.common.web.vo.BizResultVO;
import com.zteits.clouds.api.apibase.bean.BaseInfo;
import com.zteits.clouds.api.apibase.bean.BizResult;
import com.zteits.clouds.api.apibase.bean.PageBean;
import com.zteits.clouds.api.apibase.constants.BasicEnum;
import com.zteits.clouds.api.apibase.constants.DataStatusEnum;
import com.zteits.clouds.api.apibase.constants.ErrorType;
import com.zteits.clouds.api.apibase.exception.BizException;
import com.zteits.clouds.api.dto.park.dto.GuideFirstInfoConfigDTO;
import com.zteits.clouds.api.dto.park.dto.GuideParkRelDTO;
import com.zteits.clouds.api.dto.park.dto.GuideScreenDTO;
import com.zteits.clouds.api.dto.park.dto.GuideScreenGeoDTO;
import com.zteits.clouds.api.dto.park.dto.GuideScreenLevelStatisticsDTO;
import com.zteits.clouds.api.dto.park.dto.ParkingLotDTO;
import com.zteits.clouds.api.dto.park.param.GuideFirstInfoConfigQueryRequest;
import com.zteits.clouds.api.dto.park.param.GuideScreenGetBaseInfoRequest;
import com.zteits.clouds.api.dto.park.param.GuideScreenGetInfoRequest;
import com.zteits.clouds.api.dto.park.param.GuideScreenListByAreaCodesRequest;
import com.zteits.clouds.api.dto.park.param.GuideScreenListGeoRequest;
import com.zteits.clouds.api.dto.park.param.GuideScreenStatisticsByAreaCodesRequest;
import com.zteits.clouds.api.dto.park.param.ParkFreeBerthGetByPlnoRequest;
import com.zteits.clouds.api.dto.park.param.QueryParkLotInfoByPkNoRequest;
import com.zteits.clouds.api.dto.pay.TdCFileDTO;
import com.zteits.clouds.api.dto.pay.param.SysFileGetBySourceIdAndTypeRequest;
import com.zteits.clouds.api.service.park.GuideScreenService;
import com.zteits.clouds.api.service.park.ParkFreeBerthService;
import com.zteits.clouds.api.service.park.ParkingLotQueryService;
import com.zteits.clouds.api.service.pay.TdCFileService;
import com.zteits.irain.portal.vo.parkinglotdatacenter.guide.FirstGuideInfoVO;
import com.zteits.irain.portal.vo.parkinglotdatacenter.guide.GuideInfoVO;
import com.zteits.irain.portal.vo.parkinglotdatacenter.guide.SecondGuideInfoVO;
import com.zteits.irain.portal.vo.parkinglotdatacenter.guide.ThirdGuidInfoVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import static com.google.common.collect.Lists.*;

/**
 * Copyright: Copyright (c) 2017  zteits
 *
 * @ClassName: com.zteits.irain.portal.web.parkinglotdatacentre
 * @Description: 诱导屏portal接口
 * @version: v1.0.0
 * @author: atao
 * @date: 2017/7/4   下午3:10
 * Modification History:
 * Date         Author          Version      Description
 * ---------------------------------------------------------*
 * 2017/7/4      atao          v1.0.0          创建
 */

@Api("诱导屏操作接口")
@RestController
@RequestMapping("/guideScreen")
public class GuideScreenController {

    private Logger log = LoggerFactory.getLogger(GuideScreenController.class);
    @Autowired
    private GuideScreenService guideScreenService;

    @Autowired
    private ParkFreeBerthService parkFreeBerthService;

    @Autowired
    private TdCFileService tdCFileService;

    @Autowired
    private ParkingLotQueryService parkingLotQueryService;

    /**
     * 根据行政区域编码 以及 诱导屏幕等级 查询诱导屏信息
     *
     * @param request 请求入参 必填
     * @return
     */
    @PostMapping("/listGuideScreenByAreaCodes")
    @ApiOperation("根据行政区域编码 以及 诱导屏幕等级 查询诱导屏信息")
    BizResultVO<PageBean<GuideScreenDTO>> listGuideScreenByAreaCodes(
        @RequestBody GuideScreenListByAreaCodesRequest request) {
        request.setSysCode(BasicEnum.SYS_CODE.getValue());
        log.info("根据行政区域编码 以及 诱导屏幕等级 查询诱导屏信息 req={}", JSONObject.toJSONString(request));
        BizResult<PageBean<GuideScreenDTO>> result = guideScreenService.listGuideScreenByAreaCodes(request);
        log.info("根据行政区域编码 以及 诱导屏幕等级 查询诱导屏信息 result={}", JSONObject.toJSONString(result));
        return new BizResultVO<>(result);
    }

    /**
     * 根据行政区编码 统计各个诱导屏数量
     *
     * @param request 请求入参 必填
     * @return
     */
    @PostMapping("/statisticsGuideScreenLevelByAreaCodes")
    @ApiOperation("根据行政区编码 统计各个诱导屏数量")
    BizResultVO<List<GuideScreenLevelStatisticsDTO>> statisticsGuideScreenLevelByAreaCodes(
        @RequestBody GuideScreenStatisticsByAreaCodesRequest request) {
        request.setSysCode(BasicEnum.SYS_CODE.getValue());
        log.info("根据行政区编码 统计各个诱导屏数量 req={}", JSONObject.toJSONString(request));
        BizResult<List<GuideScreenLevelStatisticsDTO>> result = guideScreenService
            .statisticsGuideScreenLevelByAreaCodes(request);
        log.info("根据行政区编码 统计各个诱导屏数量 result={}", JSONObject.toJSONString(result));
        return new BizResultVO<>(result);
    }

    /**
     * 根据区域编码 与级别 查询诱导屏的经纬度
     *
     * @param request 请求入参 必填
     * @return
     */
    @PostMapping("/listGuideScreenGeo")
    @ApiOperation("根据区域编码 与级别 查询诱导屏的经纬度")
    BizResultVO<List<GuideScreenGeoDTO>> listGuideScreenGeo(@RequestBody GuideScreenListGeoRequest request) {
        log.info("根据区域编码 与级别 查询诱导屏的经纬度 req={}", JSONObject.toJSONString(request));
        BizResult<List<GuideScreenGeoDTO>> result = guideScreenService.listGuideScreenGeo(request);
        log.info("根据区域编码 与级别 查询诱导屏的经纬度 result={}", JSONObject.toJSONString(result));
        return new BizResultVO<>(result);
    }

    /**
     * 根据诱导牌编号 查询诱导屏信息
     *
     * @param request 请求入参 必填
     * @return
     */
    @ApiOperation("根据诱导牌编号 查询诱导屏信息")
    @PostMapping("/getGuideScreenInfo")
    BizResultVO<GuideInfoVO> getGuideScreenInfo(@RequestBody GuideScreenGetInfoRequest request) {
        BizResultVO<GuideInfoVO> bizResultVO = new BizResultVO<>();
        GuideInfoVO guideInfoVO = new GuideInfoVO();
        log.info("根据诱导牌编号 查询诱导屏信息 req={}", JSONObject.toJSONString(request));
        if (StringUtils.isEmpty(request.getGuideNo())) {
            throw new BizException(ErrorType.PARAMM_NULL, "诱导屏编号");
        }
        GuideScreenGetBaseInfoRequest baseInfoRequest = new GuideScreenGetBaseInfoRequest();
        baseInfoRequest.setDataState(request.getDataState());
        baseInfoRequest.setGuideNo(request.getGuideNo());
        baseInfoRequest.setSysCode(request.getSysCode());
        BizResult<GuideScreenDTO> baseInfoResult = guideScreenService.getBaseGuideScreenInfo(baseInfoRequest);

        if (ResultUtils.isError(baseInfoResult)) {
            throw new BizException(baseInfoResult.getErrCode(), baseInfoResult.getErrMsg());
        }

        GuideScreenDTO guideScreenDTO = baseInfoResult.getData();
        if (null == guideScreenDTO || StringUtils.isEmpty(guideScreenDTO.getGuideNo()) || StringUtils.isEmpty(
            guideScreenDTO.getGuideName())) {
            throw new BizException(ErrorType.BIZ_ERROR, "诱导屏不存在!");

        }
        guideInfoVO.setGuideNo(guideScreenDTO.getGuideNo());
        guideInfoVO.setLevel(guideScreenDTO.getLevel());

        if (1 == guideInfoVO.getLevel()) {
            log.info("查询一级诱导屏信息");
            guideInfoVO = getFirstGuideInfo(guideInfoVO, request.getSysCode());
        } else if (2 == guideInfoVO.getLevel()) {
            log.info("查询二级诱导屏信息");
            guideInfoVO = getSecondGuideInfo(guideInfoVO, request.getSysCode());
        } else if (3 == guideInfoVO.getLevel()) {
            log.info("查询三级诱导屏信息");
            guideInfoVO = getThridGuideInfo(guideInfoVO, request.getSysCode());

        } else {
            log.info("未匹配到诱导屏等级信息");
        }

        log.info("根据诱导牌编号 查询诱导屏信息 result={}", JSONObject.toJSONString(guideInfoVO));

        bizResultVO.setData(guideInfoVO);
        bizResultVO.setCode(ErrorType.BIZ_SUCCESS.getCode());
        bizResultVO.setMsg("成功");
        return bizResultVO;
    }

    /**
     * 获取一级诱导信息
     *
     * @param guideInfoVO
     * @return
     */
    private GuideInfoVO getFirstGuideInfo(GuideInfoVO guideInfoVO, String sysCode) {

        FirstGuideInfoVO firstGuideInfoVO = new FirstGuideInfoVO();
        firstGuideInfoVO.setGuideNo(guideInfoVO.getGuideNo());
        firstGuideInfoVO.setLevel(guideInfoVO.getLevel());

        SysFileGetBySourceIdAndTypeRequest request = new SysFileGetBySourceIdAndTypeRequest();
        request.setSourceId(guideInfoVO.getGuideNo());
        request.setFileType(SysFileTypeEnum.GuideFirstFile.val());
        request.setSysCode(sysCode);
        BizResult<TdCFileDTO> bizResult = tdCFileService.getSysFileBySourceIdAndType(request);
        if (ResultUtils.isSuccess(bizResult)) {
            firstGuideInfoVO.setFilePath(bizResult.getData().getFilePath());
        } else {
            log.info("未查询到一级诱导图片 sourceId={},type={}", request.getSourceId(), request.getFileType());
        }

        //1、根据诱导屏编号查询一级诱导屏图片配置信息
        GuideFirstInfoConfigQueryRequest guideFirstInfoConfigQueryRequest = new GuideFirstInfoConfigQueryRequest();
        guideFirstInfoConfigQueryRequest.setGuideNo(guideInfoVO.getGuideNo());
        guideFirstInfoConfigQueryRequest.setSysCode(sysCode);
        BizResult<List<GuideFirstInfoConfigDTO>> guideConfigsResult = guideScreenService
            .queryFirstGuideInfoConfigByGuideNo(
                guideFirstInfoConfigQueryRequest);

        //2、组装配置信息
        if (ResultUtils.isError(guideConfigsResult)) {
            throw new BizException(guideConfigsResult.getErrCode(), guideConfigsResult.getErrMsg());
        }
        List<GuideFirstInfoConfigDTO> guideConfigs = guideConfigsResult.getData();
        
        //3、根据停车场编码 查询空余车位数
        List<String> plNos = newArrayList();
        guideConfigs.forEach(item->{plNos.add(item.getPlNo());});
        ParkFreeBerthGetByPlnoRequest parkFreeBerthGetByPlnoRequest = new ParkFreeBerthGetByPlnoRequest();
        parkFreeBerthGetByPlnoRequest.setSysCode(sysCode);
        parkFreeBerthGetByPlnoRequest.setPlNos(plNos);
        BizResult<Map<String, Integer>> result = parkFreeBerthService.getParkFreeBerthByPlno(parkFreeBerthGetByPlnoRequest);
        log.info("空余车位信息查询,返回信息为:result={}", JSONObject.toJSONString(result));
        
        Map<String,Integer> freeBerthsMap = ResultUtils.getBizResultData(result);
        
        for (GuideFirstInfoConfigDTO dto : guideConfigs) {
            
            Integer freeNum = freeBerthsMap.get(dto.getPlNo());
            
            //4、根据停车场编码查询车辆总数
            //4.1先从缓存中查询
            ParkingLotDTO parkingLotDTO = ParkingLotCacheUtil.getParkLotByPlNo(dto.getPlNo());
            if (null == parkingLotDTO) {
                //4.2 缓存中不存在，调用dubbo服务查询
                QueryParkLotInfoByPkNoRequest queryParkLotInfoByPkNoRequest = new QueryParkLotInfoByPkNoRequest();
                queryParkLotInfoByPkNoRequest.setPklNo(dto.getPlNo());
                queryParkLotInfoByPkNoRequest.setSysCode(sysCode);
                BizResult<ParkingLotDTO> parkingLotDTOBizResult = parkingLotQueryService.QueryParkingLotByPkNo(
                    queryParkLotInfoByPkNoRequest);
                log.info("停车场总车位信息查询,返回信息为:result={}", JSONObject.toJSONString(parkingLotDTOBizResult));
                if (ResultUtils.isSuccess(parkingLotDTOBizResult)) {
                    parkingLotDTO = parkingLotDTOBizResult.getData();
                }
            }
            Integer allBerthNum = null;
            if (null != parkingLotDTO) {
                allBerthNum = parkingLotDTO.getPlBerthNum();
            }

            firstGuideInfoVO.setConfigs(dto.getPlNo(), dto.getPlNameHeight(), dto.getPlNameWidth(), dto.getFreeHeight(),
                dto.getFreeWidth(), freeNum, allBerthNum);

        }

        return firstGuideInfoVO;

    }

    /**
     * 获取二级诱导信息
     *
     * @param guideInfoVO
     * @return
     */
    private GuideInfoVO getSecondGuideInfo(GuideInfoVO guideInfoVO, String sysCode) {

        SecondGuideInfoVO secondGuideInfoVO = new SecondGuideInfoVO();
        secondGuideInfoVO.setGuideNo(guideInfoVO.getGuideNo());
        secondGuideInfoVO.setLevel(guideInfoVO.getLevel());
        GuideScreenGetInfoRequest request = new GuideScreenGetInfoRequest();
        request.setGuideNo(guideInfoVO.getGuideNo());
        request.setDataState(DataStatusEnum.DATA_STATUS_VALID.value());
        request.setSysCode(sysCode);
        BizResult<List<GuideParkRelDTO>> bizResult = guideScreenService.getGuideScreenInfo(request);

        if (ResultUtils.isError(bizResult)) {
            throw new BizException(bizResult.getErrCode(), bizResult.getErrMsg());
        }
        List<GuideParkRelDTO> guideParkRelDTOS = bizResult.getData();
      //3、根据停车场编码 查询空余车位数
        List<String> plNos = newArrayList();
        guideParkRelDTOS.forEach(item->{plNos.add(item.getPlNo());});
        ParkFreeBerthGetByPlnoRequest parkFreeBerthGetByPlnoRequest = new ParkFreeBerthGetByPlnoRequest();
        parkFreeBerthGetByPlnoRequest.setSysCode(sysCode);
        parkFreeBerthGetByPlnoRequest.setPlNos(plNos);
        BizResult<Map<String, Integer>> result = parkFreeBerthService.getParkFreeBerthByPlno(parkFreeBerthGetByPlnoRequest);
        log.info("空余车位信息查询,返回信息为:result={}", JSONObject.toJSONString(result));
        
        
        for (GuideParkRelDTO dto : guideParkRelDTOS) {
        	Integer freeBerth = result.getData().get(dto.getPlNo());
        	secondGuideInfoVO.addGuideDetail(dto.getPlNo(), dto.getPlName(), freeBerth, dto.getGuidePoint());
        }

        return secondGuideInfoVO;

    }

    /**
     * 获取三级诱导信息
     *
     * @param guideInfoVO
     * @return
     */
    private GuideInfoVO getThridGuideInfo(GuideInfoVO guideInfoVO, String sysCode) {
        GuideScreenGetInfoRequest request = new GuideScreenGetInfoRequest();
        request.setSysCode(sysCode);
        request.setGuideNo(guideInfoVO.getGuideNo());
        request.setDataState(DataStatusEnum.DATA_STATUS_VALID.value());
        BizResult<List<GuideParkRelDTO>> bizResult = guideScreenService.getGuideScreenInfo(request);
        if (ResultUtils.isError(bizResult)) {
            throw new BizException(bizResult.getErrCode(), bizResult.getErrMsg());
        }
        ThirdGuidInfoVO thirdGuidInfoVO = new ThirdGuidInfoVO();
        thirdGuidInfoVO.setGuideNo(guideInfoVO.getGuideNo());
        thirdGuidInfoVO.setLevel(guideInfoVO.getLevel());
        if (!CollectionUtils.isEmpty(bizResult.getData())) {
            GuideParkRelDTO guideParkRelDTO = bizResult.getData().get(0);
            thirdGuidInfoVO.setHighLimitNum(guideParkRelDTO.getHighLimitNum());
            thirdGuidInfoVO.setHighLimitStatus(guideParkRelDTO.getHighLimitStatus());
            thirdGuidInfoVO.setSharpTurnStatus(guideParkRelDTO.getSharpTurnStatus());
            thirdGuidInfoVO.setTimeSystem(guideParkRelDTO.getTimeSystem());
            thirdGuidInfoVO.setFloor(guideParkRelDTO.getFloor());
            thirdGuidInfoVO.setFloorStatus(guideParkRelDTO.getFloorStatus());
            ParkFreeBerthGetByPlnoRequest temp = new ParkFreeBerthGetByPlnoRequest();
            temp.setSysCode(sysCode);
            List<String> plNos = newArrayList();
            plNos.add(guideParkRelDTO.getPlNo());
			temp.setPlNos(plNos );
            BizResult<Map<String,Integer>> result = parkFreeBerthService.getParkFreeBerthByPlno(temp);
            if (ResultUtils.isError(result)) {
                log.info("空余车位信息查询报错,返回信息为:result={}", JSONObject.toJSONString(result));
                thirdGuidInfoVO.setFreeNum(null);
            } else {
                thirdGuidInfoVO.setFreeNum(result.getData().get(guideParkRelDTO.getPlNo()));
            }
        }

        return thirdGuidInfoVO;
    }

    /**
     * 查询诱导屏信息（用于地图展示）
     *
     * @param request 请求入参
     * @return
     */
    @PostMapping("/listGuideScreenForMap")
    @ApiOperation("查询所有诱导屏信息用于地图展示")
    BizResultVO<PageBean<GuideScreenDTO>> listGuideScreenForMap(
        @RequestBody GuideScreenListByAreaCodesRequest request) {
        BaseInfo info = new BaseInfo();
        info.setPageSize(100);
        request.setSysCode(BasicEnum.SYS_CODE.getValue());
        request.setBaseRequest(info);
        BizResult<PageBean<GuideScreenDTO>> result = guideScreenService.listGuideScreenByAreaCodes(request);
        log.info("查询所有诱导屏信息用于地图展示 result={}", JSONObject.toJSONString(result));
        return new BizResultVO<>(result);
    }

}
