package com.zteits.irain.portal.web.govclouds;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.alibaba.fastjson.JSONObject;
import com.clouds.common.cache.park.EqpAndPosStatusSyncCacheUtil;
import com.clouds.common.cache.sys.SysCodeValueCacheUtil;
import com.clouds.common.constants.CodeValKindEnum;
import com.clouds.common.utils.ResultUtils;
import com.clouds.common.web.vo.BizResultVO;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.zteits.clouds.api.apibase.bean.BizResult;
import com.zteits.clouds.api.apibase.constants.ErrorType;
import com.zteits.clouds.api.apibase.exception.BizException;
import com.zteits.clouds.api.dto.clouds.dto.OrderTransDTO;
import com.zteits.clouds.api.dto.clouds.param.OrderTransactionQueryRequest;
import com.zteits.clouds.api.dto.govclouds.ParkTransactionDTO;
import com.zteits.clouds.api.dto.govclouds.dto.ParkEqpAndPDACountDTO;
import com.zteits.clouds.api.dto.govclouds.dto.ParkingOccupyDTO;
import com.zteits.clouds.api.dto.govclouds.param.QueryParkEqpAndPDACountRequest;
import com.zteits.clouds.api.dto.govclouds.param.QueryParkingOccupyRequest;
import com.zteits.clouds.api.dto.park.dto.ParkFreeBerthsCountStatisticByCountryDTO;
import com.zteits.clouds.api.dto.park.dto.ParkLotCountStatisticByCountryDTO;
import com.zteits.clouds.api.dto.park.dto.ParkLotEqpTypeCountStatisticByCountryDTO;
import com.zteits.clouds.api.dto.park.dto.ParkingLotDTO;
import com.zteits.clouds.api.dto.park.param.ParkTransactionRequest;
import com.zteits.clouds.api.dto.park.param.StatisticParkLotCountByCountryRequest;
import com.zteits.clouds.api.dto.pay.ParkingFlowCountDTO;
import com.zteits.clouds.api.dto.pay.param.QueryTodayFlowRequest;
import com.zteits.clouds.api.service.govclouds.ParkOccupyService;
import com.zteits.clouds.api.service.govclouds.ParkTransactionService;
import com.zteits.clouds.api.service.park.ParkFreeBerthService;
import com.zteits.clouds.api.service.park.ParkingLotEqpService;
import com.zteits.clouds.api.service.park.ParkingLotQueryService;
import com.zteits.clouds.api.service.park.TpPPdaService;
import com.zteits.clouds.api.service.pay.TdBOrderService;
import com.zteits.irain.portal.constant.ParkConstant;
import com.zteits.irain.portal.vo.govclouds.StatisticParkLotEqpCountByCountryVO;
import com.zteits.irain.portal.vo.parkinglotdatacenter.BerthSpaceRatioVO;
import com.zteits.irain.portal.vo.parkinglotdatacenter.BerthSpaceRatioVO.BerthSeriesVO;
import com.zteits.irain.portal.vo.parkinglotdatacenter.ParkLotAndBerthsCountVO;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * 数据概括 相关Controller
 * 
 * Copyright: Copyright (c) 2017  zteits
 * 
 * @ClassName: DataGeneralizeController.java
 * @Description: 
 * @version: v1.0.0
 * @author: zhaowg
 * @date: 2017年6月27日   下午2:11:07 
 * Modification History: 
 * Date             Author          Version            Description
 *---------------------------------------------------------*
 * 2017年6月27日      zhaowg              v1.0.0               创建
 */
@RestController
@Api(value="数据中心-数据概括",description="数据中心-数据概括")
@RequestMapping("/dataGeneralize")
public class DataGeneralizeController {
	private Logger logger = LoggerFactory.getLogger(DataGeneralizeController.class);
	
	@Value("${project.syscode}")
	private String sysCode;
	@Autowired
	private ParkingLotQueryService parkingLotQueryService;
	@Autowired
	private ParkingLotEqpService parkingLotEqpService;
	@Autowired
	private ParkFreeBerthService parkFreeBerthService;
	@Autowired
	private ParkTransactionService parkTransactionService;
	@Autowired
	private TpPPdaService tpPPdaService;
	@Autowired
	private TdBOrderService tdBOrderService;
	@Autowired
	private ParkOccupyService parkOccupyService;
	
	
	/** 
     * 这里用的是@SendToUser，这就是发送给单一客户端的标志。本例中， 
     * 客户端接收一对一消息的主题应该是“/user/” + 用户Id + “/message” ,这里的用户id可以是一个普通的字符串，只要每个用户端都使用自己的id并且服务端知道每个用户的id就行。 
     * @return 
     */ 
	@ApiOperation(value="空闲车位雷达图")
	@PostMapping("freeBerthRadarChart")
	@ResponseBody
//	@MessageMapping("/freeBerthRadarChartByWebSocket")
//	@SendToUser("/freeBerthRadarChartByWebSocket")
	public BizResultVO<Map<String,Integer>> getFreeBerthRadarChart(@RequestBody StatisticParkLotCountByCountryRequest request){
		if(null == request.getCityId()){
			throw new BizException(ErrorType.PARAMM_NULL, "城市编号");
		}
		logger.info("对城市："+request.getCityId()+" 按照区域统计空闲车位数量等信息");
		Map<String,Integer> freeBerthsMap = Maps.newHashMap();
		//TODO 空闲车位数量 先查询缓存
		BizResult<List<ParkFreeBerthsCountStatisticByCountryDTO>> bizResultParkLot = parkFreeBerthService.StatisticParkFreeBerthsCountByCountry(request);
		logger.info("调用后场dubbo服务,响应为: result={}", JSONObject.toJSONString(bizResultParkLot));
        //如果不成功
        if (!ResultUtils.isSuccess(bizResultParkLot)) {
            return new BizResultVO<>(bizResultParkLot.getErrCode(), bizResultParkLot.getErrMsg());
        }
        List<ParkFreeBerthsCountStatisticByCountryDTO> parkFreeBerthList=bizResultParkLot.getData();
        //空闲车位数
        if(CollectionUtils.isNotEmpty(parkFreeBerthList)){
        	for (ParkFreeBerthsCountStatisticByCountryDTO dto : parkFreeBerthList) {
        		String countryName = dto.getPlCountryName();
				//停车位个数
				Integer pkberthsCount = dto.getFreeBerthsNum()==null?0:dto.getFreeBerthsNum();
				freeBerthsMap.put(countryName, pkberthsCount);
			}
        }
		return new BizResultVO<Map<String,Integer>>().setData(freeBerthsMap);
	}

	@ApiOperation(value="统计停车场服务次数线上线下排行")
	@PostMapping("queryParkTransaction")
	@ResponseBody
	public BizResultVO<List<ParkTransactionDTO>> queryParkTransaction(@RequestBody StatisticParkLotCountByCountryRequest request){
		BizResultVO<List<ParkTransactionDTO>> parkTransVO = new BizResultVO<>();
		//先查询城市下面的停车场
		BizResult<List<ParkingLotDTO>> result = parkingLotQueryService.queryParkLotByCountry(request);
		if (ResultUtils.isError(result)) {
            //如果失败
	    	parkTransVO.setCode(result.getErrCode().getCode());
	    	parkTransVO.setMsg(result.getErrMsg());
            return parkTransVO;
        }
		ParkTransactionRequest pRequest = new ParkTransactionRequest();
		pRequest = this.getParkingLot(result.getData());  //拼接参数
		//TODO 停车场线上线下服务次数排行
		BizResult<List<ParkTransactionDTO>> bizResultParkLot = parkTransactionService.queryParkTransaction(pRequest);
	    if (ResultUtils.isError(bizResultParkLot)) {
            //如果失败
	    	parkTransVO.setCode(bizResultParkLot.getErrCode().getCode());
	    	parkTransVO.setMsg(bizResultParkLot.getErrMsg());
            return parkTransVO;
        }
	    List<ParkTransactionDTO> parkingLotList = new ArrayList<ParkTransactionDTO>();
	    parkingLotList = this.changeParkTrans(result.getData(), bizResultParkLot.getData());
		parkTransVO.setData(parkingLotList);
		return parkTransVO;
	}
	/**
	 * 拼接参数-查询线上排行
	 * @param parkList
	 * @return
	 */
	private ParkTransactionRequest getParkingLot(List<ParkingLotDTO> parkList){
		ParkTransactionRequest pRequest = new ParkTransactionRequest();
		List<ParkTransactionDTO> parkTransList = new ArrayList<ParkTransactionDTO>();
		for(ParkingLotDTO parkingLotDTO:parkList){
			ParkTransactionDTO parkTransactionDTO = new ParkTransactionDTO();
			parkTransactionDTO.setParkId(parkingLotDTO.getPlNo());
			parkTransactionDTO.setParkName(parkingLotDTO.getPlName());
			parkTransList.add(parkTransactionDTO);
		}
		pRequest.setParkTransactionDTO(parkTransList);
		pRequest.setSysCode("城市下面包含的所有停车场");
		return pRequest;
	}
	
	/**
	 * list
	 * @param list
	 * @return
	 */
	private List<ParkTransactionDTO> changeParkTrans(List<ParkingLotDTO> parkingLotList,List<ParkTransactionDTO> list){
		for(ParkTransactionDTO parkTransactionDTO:list){
			for(ParkingLotDTO parkingLotDTO:parkingLotList){
				if(parkingLotDTO.getPlNo().equals(parkTransactionDTO.getParkId())){
					parkTransactionDTO.setParkName(parkingLotDTO.getPlName());
				}
			}
		}
		return list;
	}
	/**
	 * 分区统计停车场、停车位数量
	 * langlw 2017-9-5
	 * @param request
	 * @return
	 */
	@ApiOperation(value="停车场柱图")
	@PostMapping("parkinglotColumnChart")
	@ResponseBody
	public BizResultVO<ParkLotAndBerthsCountVO> getParkAndBerthAndEquChart(@RequestBody StatisticParkLotCountByCountryRequest request){
		if(null == request.getCityId()){
			throw new BizException(ErrorType.PARAMM_NULL, "城市编号");
		}
		logger.info("对城市："+request.getCityId()+" 按照区域统计停车场、车位数量等信息");
		//停车场数量 先查询缓存
		BizResult<List<ParkLotCountStatisticByCountryDTO>> bizResultParkLot = parkingLotQueryService.StatisticParkLotCountByCountry(request);
		logger.info("调用后场dubbo服务,响应为: result={}", JSONObject.toJSONString(bizResultParkLot));
        //如果不成功
        if (!ResultUtils.isSuccess(bizResultParkLot)) {
            return new BizResultVO<>(bizResultParkLot.getErrCode(), bizResultParkLot.getErrMsg());
        }
        List<ParkLotCountStatisticByCountryDTO> parkLotCountList=bizResultParkLot.getData();
        //停车场车位数
        Map<String,Integer> berthsCountMap = Maps.newHashMap();
        //停车场数
        Map<String,Integer> parkLotCountMap = Maps.newHashMap();
        
        if(CollectionUtils.isNotEmpty(parkLotCountList)){
        	for (ParkLotCountStatisticByCountryDTO dto : parkLotCountList) {
				String countryName = dto.getPlCountryName();
				//停车场个数
				int pkCount = dto.getParkLotCount()==null?0:dto.getParkLotCount();
				parkLotCountMap.put(countryName, pkCount);
				//停车位个数
				int pkberthsCount = dto.getTotalBerths();
				berthsCountMap.put(countryName, pkberthsCount);
			}
        }
        ParkLotAndBerthsCountVO parkLotAndBerthsCountVO = new ParkLotAndBerthsCountVO();
        parkLotAndBerthsCountVO.setPkberthsCount(berthsCountMap);
        parkLotAndBerthsCountVO.setPkCount(parkLotCountMap);
		return new BizResultVO<ParkLotAndBerthsCountVO>().setData(parkLotAndBerthsCountVO);
	}
	
	
	/**
	 * 返回值说明：Map<设备名称,Map<区县中文名称，对应的数量>>
	 * @param request
	 * @return
	 * 2017年7月12日 zhaowg
	 */
	@ApiOperation(value="根据某市按照区域统计设备数量")
	@PostMapping("statisticParkLotEqpCountByCountry")
	@ResponseBody
	public BizResultVO<StatisticParkLotEqpCountByCountryVO> StatisticParkLotEqpCountByCountry(@RequestBody StatisticParkLotCountByCountryRequest request){
		logger.info("对城市："+request.getCityId()+" 按照区域统计设备数量等信息");
		StatisticParkLotEqpCountByCountryVO result = new StatisticParkLotEqpCountByCountryVO();
		// 通过设备类型+是否在线或离线,和区域分组
     	Map<String, Map<String, Integer>> detailEquTypeGroupMap = Maps.newLinkedHashMap();
     	// 通过设备类型,和区域分组
     	Map<String, Map<String, Integer>> totalEquTypeGroupMap = Maps.newHashMap();
     	result.setDetailEqpMap(detailEquTypeGroupMap);
     	result.setTotalEqpMap(totalEquTypeGroupMap);
     	
		// 设备类型编号和名称对应关系
        Map<String, String> equNamemap = SysCodeValueCacheUtil.queryCodeValueAndNames(null, CodeValKindEnum.PARKING_LOT_EQP_TYPE_, request.getCityId()+"");
        if(equNamemap==null || equNamemap.isEmpty()){
        	return new BizResultVO<StatisticParkLotEqpCountByCountryVO>().setData(result);
        }
        
        //将为赋值的设备初始化 离线在前，在线在后
        for (Entry<String, String> e : equNamemap.entrySet()) {
        	String equName = e.getValue();
        	//不包含某个设备，初始化
        	if(!detailEquTypeGroupMap.containsKey(equName+"在线")){
        		detailEquTypeGroupMap.put(equName+"在线", Maps.newHashMap());
        	}
        	if(!detailEquTypeGroupMap.containsKey(equName+"离线")){
        		detailEquTypeGroupMap.put(equName+"离线", Maps.newHashMap());
        	}
        	if(!totalEquTypeGroupMap.containsKey(equName)){
        		totalEquTypeGroupMap.put(equName, Maps.newHashMap());
        	}
        	
		}
        
        BizResult<List<ParkLotEqpTypeCountStatisticByCountryDTO>> bizResultParkEqp = parkingLotEqpService.StatisticParkLotEqpCountByCountry(request);
        //如果不成功 或空 返回0
        if (ResultUtils.isSuccess(bizResultParkEqp)) {
        	List<ParkLotEqpTypeCountStatisticByCountryDTO> parkEquTypeList=bizResultParkEqp.getData();
            if(CollectionUtils.isNotEmpty(parkEquTypeList)){
            	for (ParkLotEqpTypeCountStatisticByCountryDTO dto : parkEquTypeList) {
            		//TODO 临时方案，zhaowg3 20170726  原因：红山区目前地磁状态同步接口未做，只同步总的在线，离线数量，故直接获取他同步的结果即可
    				if(dto.getPlCountryId()==923){
    					continue;
    				}
            		////////////////////////////////////以上为临时方案//////////////////
    				
    				
    				
            		//获取对应的设备名称
    				String equTypeName = equNamemap.get(dto.getEqpType()+"");
    				//获取设备状态 设备状态:1-未安装，2-使用中，3-损坏
    				Integer eqpState = dto.getEqpState();
    				if(eqpState == null || eqpState==1){
    					continue;
    				}
    				//记录在线/离线数量
    				String detailKey = equTypeName+(eqpState==2?"在线":"离线");
    				if(!detailEquTypeGroupMap.containsKey(detailKey)){
    					Map<String, Integer> equCountMap=Maps.newHashMap();
    					equCountMap.put(dto.getPlCountryName(), dto.getEqpNum());
    					detailEquTypeGroupMap.put(detailKey, equCountMap);
    				}else{
    					detailEquTypeGroupMap.get(detailKey).put(dto.getPlCountryName(), dto.getEqpNum());
    				}
    				
    				//记录某个设备总数
    				String totalKey = equTypeName;
    				if(!totalEquTypeGroupMap.containsKey(totalKey)){
    					Map<String, Integer> equCountMap=Maps.newHashMap();
    					equCountMap.put(dto.getPlCountryName(), dto.getEqpNum());
    					totalEquTypeGroupMap.put(totalKey, equCountMap);
    				}else{
    					Map<String, Integer> countryMap = totalEquTypeGroupMap.get(totalKey);
    					Integer eqpTotalNum = dto.getEqpNum();
    					if(countryMap.containsKey(dto.getPlCountryName())){
    						eqpTotalNum = countryMap.get(dto.getPlCountryName())+dto.getEqpNum();
    					}
    					totalEquTypeGroupMap.get(totalKey).put(dto.getPlCountryName(), eqpTotalNum);
    				}
    			}
            }
        }
        
        //TODO 临时方案，zhaowg3 20170726  原因：红山区目前地磁状态同步接口未做，只同步总的在线，离线数量，故直接获取他同步的结果
        this.tmpHongShanQuEqpData(detailEquTypeGroupMap,totalEquTypeGroupMap);
        
        return new BizResultVO<StatisticParkLotEqpCountByCountryVO>().setData(result);
	}
	
	//TODO 临时方案，zhaowg3 20170726  原因：红山区目前地磁状态同步接口未做，只同步总的在线，离线数量，故直接获取他同步的结果
	private void tmpHongShanQuEqpData(Map<String, Map<String, Integer>> equTypeGroupMap, Map<String, Map<String, Integer>> totalEquTypeGroupMap) {
		Map<String, String> map = EqpAndPosStatusSyncCacheUtil.getGeoPosTotalNum();
		String[] geostatus = map.get("geo").split(",");

		totalEquTypeGroupMap.get("地磁").put("红山区", Integer.valueOf(geostatus[0])+Integer.valueOf(geostatus[1]));
        
        if(equTypeGroupMap.containsKey("地磁在线")){
        	equTypeGroupMap.get("地磁在线").put("红山区", Integer.valueOf(geostatus[0]));
        }else{
        	Map<String, Integer> tmpMap = new HashMap<String, Integer>();
        	tmpMap.put("红山区", Integer.valueOf(geostatus[0]));
        	equTypeGroupMap.put("地磁在线",tmpMap);
        }
        if(equTypeGroupMap.containsKey("地磁离线")){
        	equTypeGroupMap.get("地磁离线").put("红山区", Integer.valueOf(geostatus[1]));
        }else{
        	Map<String, Integer> tmpMap = new HashMap<String, Integer>();
        	tmpMap.put("红山区", Integer.valueOf(geostatus[1]));
        	equTypeGroupMap.put("地磁离线",tmpMap);
        }
		
		String[] posstatus = map.get("pos").split(",");
        totalEquTypeGroupMap.get("POS机").put("红山区", Integer.valueOf(posstatus[0])+Integer.valueOf(posstatus[1]));
        if(equTypeGroupMap.containsKey("POS机离线")){
        	equTypeGroupMap.get("POS机离线").put("红山区", Integer.valueOf(posstatus[1]));
        }else{
        	Map<String, Integer> tmpMap = new HashMap<String, Integer>();
        	tmpMap.put("红山区", Integer.valueOf(posstatus[1]));
        	equTypeGroupMap.put("POS机离线",tmpMap);
        }
        if(equTypeGroupMap.containsKey("POS机在线")){
        	equTypeGroupMap.get("POS机在线").put("红山区", Integer.valueOf(posstatus[0]));
        }else{
        	Map<String, Integer> tmpMap = new HashMap<String, Integer>();
        	tmpMap.put("红山区", Integer.valueOf(posstatus[0]));
        	equTypeGroupMap.put("POS机在线",tmpMap);
        }
	}

	@ApiOperation("查询某个城市首页要显示的区县")
	@PostMapping("displayCountryByCityId")
	public BizResultVO<List<String>> getDisplayCountry(@RequestBody StatisticParkLotCountByCountryRequest request){
		Map<String, String> map = SysCodeValueCacheUtil.queryCodeValueAndNames(null, CodeValKindEnum.DATA_CENTRE_INDEX_DISPLAY_, request.getCityId()+"");
		if(map == null || map.isEmpty()){
			return new BizResultVO<List<String>>().setData(Lists.newArrayList());
		}
		List<String> displayCountry = Lists.newArrayList();
		map.entrySet().forEach(e->{displayCountry.add(e.getValue());});
		return new BizResultVO<List<String>>().setData(displayCountry);
	}
	/**
	 * 车位配比图
	 * langlw 2017-9-5
	 * @param request
	 * @return
	 */
	@ApiOperation(value="车位配比图")
	@PostMapping("berthSpaceRatioChart")
	@ResponseBody
	public BizResultVO<BerthSpaceRatioVO> getBerthSpaceRatioChart(@RequestBody StatisticParkLotCountByCountryRequest request){
		if(null == request.getCityId()){
			throw new BizException(ErrorType.PARAMM_NULL, "城市编号");
		}
		logger.info("对城市："+request.getCityId()+" 按照区域统计空闲车位数量信息");
		BerthSpaceRatioVO berthSpaceRatioVO=new BerthSpaceRatioVO();
		// 车位配比 区域和配比值对应关系
        Map<String, String> berthSpaceRatiomap = SysCodeValueCacheUtil.queryCodeValueAndNames(null, CodeValKindEnum.DATA_CENTRE_INDEX_BERTH_RATIO_, request.getCityId()+"");
        List<BerthSeriesVO> b=Lists.newArrayList();
        for (Entry<String, String> entry : berthSpaceRatiomap.entrySet()) {
        	BerthSeriesVO berthSeriesVO=new BerthSeriesVO();
        	berthSeriesVO.setName(entry.getKey());
        	String value=entry.getValue()==null?"0":entry.getValue();
        	berthSeriesVO.setData(Double.valueOf(value).doubleValue());
			b.add(berthSeriesVO);
		}
        
		berthSpaceRatioVO.setBerthSpaceRatio(b);
       
		return new BizResultVO<BerthSpaceRatioVO>().setData(berthSpaceRatioVO);
	}
	
	
	/**
	 * 获取停车场设备和PDA在线离线总数
	 * langlw 2017-9-5
	 * @param request
	 * @return
	 */
	@ApiOperation(value="获取停车场设备和PDA在线离线总数")
	@PostMapping("queryParkEqpAndPDACount")
	@ResponseBody
	public BizResultVO<ParkEqpAndPDACountDTO> queryParkEqpAndPDACount(@RequestBody QueryParkEqpAndPDACountRequest request){
		if(null == request.getEqpType() || null == request.getPdaType() || CollectionUtils.isEmpty(request.getPlNos())){
			throw new BizException(ErrorType.PARAMM_NULL, "入参不能为空");
		}
		logger.info("调用dubbo服务,请求入参: request={}", JSONObject.toJSONString(request));
		ParkEqpAndPDACountDTO parkEqpAndPDACountDTO=new ParkEqpAndPDACountDTO();
		//查询停车场设备
		BizResult<List<ParkEqpAndPDACountDTO>> result = parkingLotEqpService.queryParkEqpCountByPlNosAndEqpType(request);
		logger.info("调用后场dubbo服务,响应为: result={}", JSONObject.toJSONString(result));
		List<ParkEqpAndPDACountDTO> parkEqpList=result.getData();
		//PDA
		int onlineEqpCountSum=0;
		int allEqpCountSum=0;
		int onlinePDACountSum=0;
		int allPDACountSum=0;
		
		if(CollectionUtils.isNotEmpty(parkEqpList)){
			for (ParkEqpAndPDACountDTO dto : parkEqpList) {
				if(null != dto){
					onlineEqpCountSum=onlineEqpCountSum+(null==dto.getOnlineEqpCount()?0:dto.getOnlineEqpCount());
					allEqpCountSum=allEqpCountSum+(null==dto.getAllEqpCount()?0:dto.getAllEqpCount());
				}
			}
		}
		
		//查询PDA在线和离线总数
		BizResult<List<ParkEqpAndPDACountDTO>> bizResult = tpPPdaService.queryPDACountByPlNosAndPdaType(request);
		logger.info("调用后场dubbo服务,响应为: result={}", JSONObject.toJSONString(bizResult));
        List<ParkEqpAndPDACountDTO> parkPDACountList=bizResult.getData();
        //PDA
        if(CollectionUtils.isNotEmpty(parkPDACountList)){
        	for (ParkEqpAndPDACountDTO dto : parkPDACountList) {
        		if(null != dto){
        			onlinePDACountSum=onlinePDACountSum+(null==dto.getOnlinePDACount()?0:dto.getOnlinePDACount());
        			allPDACountSum=allPDACountSum+(null==dto.getAllPDACount()?0:dto.getAllPDACount());
				}
			}
        }
        parkEqpAndPDACountDTO.setAllEqpCount(allEqpCountSum);
        parkEqpAndPDACountDTO.setAllPDACount(allPDACountSum);
        parkEqpAndPDACountDTO.setOnlineEqpCount(onlineEqpCountSum);
        parkEqpAndPDACountDTO.setOnlinePDACount(onlinePDACountSum);
        
        
		return new BizResultVO<ParkEqpAndPDACountDTO>().setData(parkEqpAndPDACountDTO);
	}
	
	
	/**
	 * 分区统计停车场、停车位数量
	 * langlw 2017-9-5
	 * @param request
	 * @return
	 */
	@ApiOperation(value="分区、停车场类型统计停车场、停车位数量")
	@PostMapping("getParkAndBerthAndEquChartForPlType")
	@ResponseBody
	public BizResultVO<ParkLotAndBerthsCountVO> getParkAndBerthAndEquChartForPlType(@RequestBody StatisticParkLotCountByCountryRequest request){
		if(null == request.getCityId()){
			throw new BizException(ErrorType.PARAMM_NULL, "城市编号");
		}
		logger.info("对城市："+request.getCityId()+" 按照区域统计停车场、车位数量等信息");
		//停车场数量 先查询缓存
		BizResult<List<ParkLotCountStatisticByCountryDTO>> bizResultParkLot = parkingLotQueryService.statisticParkLotCountByCountryForPlType(request);
		logger.info("调用后场dubbo服务,响应为: result={}", JSONObject.toJSONString(bizResultParkLot));
        List<ParkLotCountStatisticByCountryDTO> parkLotCountList=bizResultParkLot.getData();
        
        Map<String,Object> pkberthsCountObjMap=Maps.newHashMap();
        Map<String,Object> parkLotCountObjMap=Maps.newHashMap();
       
        
        if(CollectionUtils.isNotEmpty(parkLotCountList)){
        	for (ParkLotCountStatisticByCountryDTO dto : parkLotCountList) {
				String countryName = dto.getPlCountryName();
				 //停车场车位数
		        Map<Integer,Integer> berthsCountMap = Maps.newHashMap();
		        //停车场数
		        Map<Integer,Integer> parkLotCountMap = Maps.newHashMap();
				//停车场个数
		        int pkCount = dto.getParkLotCount()==null?0:dto.getParkLotCount();
		        Integer plType=dto.getPlType();
		        parkLotCountMap.put(plType, pkCount);
				parkLotCountObjMap.put(countryName, parkLotCountMap);
				//停车位个数
				int pkberthsCount = dto.getTotalBerths();
				berthsCountMap.put(plType, pkberthsCount);
				pkberthsCountObjMap.put(countryName, berthsCountMap);
			}
        }
        ParkLotAndBerthsCountVO parkLotAndBerthsCountVO = new ParkLotAndBerthsCountVO();
        parkLotAndBerthsCountVO.setPkberthsCountMap(pkberthsCountObjMap);
        parkLotAndBerthsCountVO.setPkCountMap(parkLotCountObjMap);
		return new BizResultVO<ParkLotAndBerthsCountVO>().setData(parkLotAndBerthsCountVO);
	}
	
	
	@SuppressWarnings("serial")
	@ApiOperation(value="今日车流量")
	@PostMapping("queryTodayVehicleFlow")
	@ResponseBody
	public BizResultVO<List<ParkingFlowCountDTO>> queryTodayVehicleFlow(@RequestBody StatisticParkLotCountByCountryRequest request){
		BizResultVO<List<ParkingFlowCountDTO>> parkFlowDTOs = new BizResultVO<>();
		List<ParkingFlowCountDTO> parkingFlowCountDTOs = new ArrayList<>();
		
		List<QueryTodayFlowRequest> requests = new ArrayList<>();
		List<String> HSPlNos = new ArrayList<String>(){{add("-1");}};
		List<String> SSPlNos = new ArrayList<String>(){{add("-1");}};
		List<String> YBSPlNos = new ArrayList<String>(){{add("-1");}};
		List<String> QTPlNos = new ArrayList<String>(){{add("-1");}};
		
		
		//先查询城市下面的停车场
		BizResult<List<ParkingLotDTO>> parkResult = parkingLotQueryService.queryParkLotByCountry(request);
		if (ResultUtils.isError(parkResult)) {
            //如果失败
			parkFlowDTOs.setCode(parkResult.getErrCode().getCode());
			parkFlowDTOs.setMsg(parkResult.getErrMsg());
            return parkFlowDTOs;
        }
		QueryTodayFlowRequest HSRequest = new QueryTodayFlowRequest(); 
		QueryTodayFlowRequest SSRequest = new QueryTodayFlowRequest(); 
		QueryTodayFlowRequest YBSRequest = new QueryTodayFlowRequest(); 
		QueryTodayFlowRequest QTRequest = new QueryTodayFlowRequest(); 
		QueryTodayFlowRequest flowRequest = new QueryTodayFlowRequest();
		BeanUtils.copyProperties(request, flowRequest);
		Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(Calendar.HOUR_OF_DAY, 0);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);
        Date beginTime = calendar.getTime();
		flowRequest.setBeginTime(beginTime);
		flowRequest.setEndTime(new Date());
		flowRequest.setDataState(1);
		flowRequest.setOrderType(1);
		for (ParkingLotDTO dto : parkResult.getData()) {
			switch (dto.getPlCountryId().intValue()) {
			case 923://红山区
				HSPlNos.add(dto.getPlNo());
				BeanUtils.copyProperties(flowRequest, HSRequest);
				HSRequest.setPlCountryId(dto.getPlCountryId());
				HSRequest.setPlCountryName(dto.getPlCountryName());
				break;
			case 925://松山区
				SSPlNos.add(dto.getPlNo());
				BeanUtils.copyProperties(flowRequest, SSRequest);
				SSRequest.setPlCountryId(dto.getPlCountryId());
				SSRequest.setPlCountryName(dto.getPlCountryName());
				break;
			case 924://元宝山区
				YBSPlNos.add(dto.getPlNo());
				BeanUtils.copyProperties(flowRequest, YBSRequest);
				YBSRequest.setPlCountryId(dto.getPlCountryId());
				YBSRequest.setPlCountryName(dto.getPlCountryName());
				break;
			default://其他
				QTPlNos.add(dto.getPlNo());
				BeanUtils.copyProperties(flowRequest, QTRequest);
				QTRequest.setPlCountryId(9999L);
				QTRequest.setPlCountryName("其他");
				
				break;
			}
		}
		
		HSRequest.setPlNos(HSPlNos);
		SSRequest.setPlNos(SSPlNos);
		YBSRequest.setPlNos(YBSPlNos);
		QTRequest.setPlNos(QTPlNos);
		requests.add(HSRequest);
		requests.add(SSRequest);
		requests.add(YBSRequest);
		requests.add(QTRequest);
		for (QueryTodayFlowRequest re : requests) {
			BizResult<ParkingFlowCountDTO> dtoBiz = tdBOrderService.queryTodayVehicleFlow(re);
			if(dtoBiz.getData()!=null){
				BeanUtils.copyProperties(re, dtoBiz.getData());
				parkingFlowCountDTOs.add(dtoBiz.getData());
			}
		}
		parkFlowDTOs.setData(parkingFlowCountDTOs);
		logger.info("调用后场dubbo服务,响应为: result={}", JSONObject.toJSONString(parkFlowDTOs));
		return parkFlowDTOs;
	}
	
	@ApiOperation(value="24小时占用率")
	@PostMapping("queryTwentyFourHoursOccupyRate")
	@ResponseBody
	public BizResultVO<List<ParkingOccupyDTO>> queryTwentyFourHoursOccupyRate(@RequestBody StatisticParkLotCountByCountryRequest request){
		BizResultVO<List<ParkingOccupyDTO>> parkOccupyDTOs = new BizResultVO<>();
		QueryParkingOccupyRequest occupyRequest = new QueryParkingOccupyRequest();
		List<String> plNos = new ArrayList<>();
		//先查询城市下面的停车场
		BizResult<List<ParkingLotDTO>> parkResult = parkingLotQueryService.queryParkLotByCountry(request);
		if (ResultUtils.isError(parkResult)) {
            //如果失败
			parkOccupyDTOs.setCode(parkResult.getErrCode().getCode());
			parkOccupyDTOs.setMsg(parkResult.getErrMsg());
            return parkOccupyDTOs;
        }
		for (ParkingLotDTO parkDto : parkResult.getData()) {
			plNos.add(parkDto.getPlNo());
		}
		if(plNos.size()<1){
			throw new BizException(ErrorType.PARAMM_NULL,"停车场编号");
		}
		BeanUtils.copyProperties(request, occupyRequest);
		occupyRequest.setPlNos(plNos);
		occupyRequest.setDataStatus(1);
		occupyRequest.setStatisticType(ParkConstant.ParkingLotUseStatistic.StatisticType.PER1HOUR);
		Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);
        Date endTime = calendar.getTime();
        
        //往前倒三个月
        //calendar.add(Calendar.MONTH, -3);
        calendar.add(Calendar.DAY_OF_MONTH, -1);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);
        Date beginTime = calendar.getTime();
        
        occupyRequest.setBeginTime(beginTime);
        occupyRequest.setEndTime(endTime);
        
        BizResult<List<ParkingOccupyDTO>>  result = parkOccupyService.queryTwentyFourHoursOccupyRate(occupyRequest);
        if(!(result.isSuccess())){
        	//如果失败
        	parkOccupyDTOs.setCode(result.getErrCode().getCode());
        	parkOccupyDTOs.setMsg(result.getErrMsg());
            return parkOccupyDTOs;
        }
        parkOccupyDTOs.setData(result.getData());
		logger.info("调用后场dubbo服务,响应为: result={}", JSONObject.toJSONString(parkOccupyDTOs));
		return parkOccupyDTOs;
	}
	
	@ApiOperation(value="今日交易")
	@PostMapping("queryTodayOrderTrans")
	@ResponseBody
	public BizResultVO<OrderTransDTO> queryTodayOrderTrans(@RequestBody StatisticParkLotCountByCountryRequest request){
		BizResultVO<OrderTransDTO> orderDTO = new BizResultVO<>();
		OrderTransactionQueryRequest orderTransRequest = new OrderTransactionQueryRequest();
		List<String> plNos = new ArrayList<>();
		//先查询城市下面的停车场
		BizResult<List<ParkingLotDTO>> parkResult = parkingLotQueryService.queryParkLotByCountry(request);
		if (ResultUtils.isError(parkResult)) {
            //如果失败
			orderDTO.setCode(parkResult.getErrCode().getCode());
			orderDTO.setMsg(parkResult.getErrMsg());
            return orderDTO;
        }
		for (ParkingLotDTO parkDto : parkResult.getData()) {
			plNos.add(parkDto.getPlNo());
		}
		if(plNos.size()<1){
			throw new BizException(ErrorType.PARAMM_NULL,"停车场编号");
		}
		BeanUtils.copyProperties(request, orderTransRequest);
		orderTransRequest.setParkIds(plNos);
		
		Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(Calendar.HOUR_OF_DAY, 0);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);
        Date beginTime = calendar.getTime();
        orderTransRequest.setBeginTime(beginTime);
        orderTransRequest.setEndTime(new Date());
        
        BizResult<OrderTransDTO> result = tdBOrderService.queryOrderTrans(orderTransRequest);
        if(!(result.isSuccess())){
        	//如果失败
        	orderDTO.setCode(result.getErrCode().getCode());
        	orderDTO.setMsg(result.getErrMsg());
            return orderDTO;
        }
        orderDTO.setData(result.getData());
        //分->元
        BigDecimal hundred = new BigDecimal("100");
        OrderTransDTO o = orderDTO.getData();
        o.setAliTotalAmount(o.getAliTotalAmount()!=null?o.getAliTotalAmount().divide(hundred):new BigDecimal("0"));
        o.setCashTotalAmount(o.getCashTotalAmount()!=null?o.getCashTotalAmount().divide(hundred):new BigDecimal("0"));
        o.setPayedTotalAmount(o.getPayedTotalAmount()!=null?o.getPayedTotalAmount().divide(hundred):new BigDecimal("0"));
        o.setWxTotalAmount(o.getWxTotalAmount()!=null?o.getWxTotalAmount().divide(hundred):new BigDecimal("0"));
        o.setYlTotalAmount(o.getYlTotalAmount()!=null?o.getYlTotalAmount().divide(hundred):new BigDecimal("0"));
        orderDTO.setData(o);
		logger.info("调用后场dubbo服务,响应为: result={}", JSONObject.toJSONString(orderDTO));
		return orderDTO;
	}
}
